/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.avatar;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import rocks.xmpp.core.Jid;
import rocks.xmpp.core.XmppException;
import rocks.xmpp.core.XmppUtils;
import rocks.xmpp.core.session.ExtensionManager;
import rocks.xmpp.core.session.SessionStatusEvent;
import rocks.xmpp.core.session.SessionStatusListener;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.MessageEvent;
import rocks.xmpp.core.stanza.MessageListener;
import rocks.xmpp.core.stanza.PresenceEvent;
import rocks.xmpp.core.stanza.PresenceListener;
import rocks.xmpp.core.stanza.model.AbstractPresence;
import rocks.xmpp.core.stanza.model.client.Message;
import rocks.xmpp.core.stanza.model.client.Presence;
import rocks.xmpp.core.stream.model.ClientStreamElement;
import rocks.xmpp.extensions.avatar.AvatarChangeEvent;
import rocks.xmpp.extensions.avatar.AvatarChangeListener;
import rocks.xmpp.extensions.avatar.DirectoryAvatarCache;
import rocks.xmpp.extensions.avatar.model.data.AvatarData;
import rocks.xmpp.extensions.avatar.model.metadata.AvatarMetadata;
import rocks.xmpp.extensions.muc.model.user.MucUser;
import rocks.xmpp.extensions.pubsub.PubSubManager;
import rocks.xmpp.extensions.pubsub.PubSubService;
import rocks.xmpp.extensions.pubsub.model.Item;
import rocks.xmpp.extensions.pubsub.model.event.Event;
import rocks.xmpp.extensions.vcard.avatar.model.AvatarUpdate;
import rocks.xmpp.extensions.vcard.temp.VCardManager;
import rocks.xmpp.extensions.vcard.temp.model.VCard;

public final class AvatarManager
extends ExtensionManager {
    private static final Logger logger = Logger.getLogger(VCardManager.class.getName());
    private final Map<Jid, String> userHashes = new ConcurrentHashMap<Jid, String>();
    private final ConcurrentHashMap<Jid, Lock> requestingAvatarLocks = new ConcurrentHashMap();
    private final Set<AvatarChangeListener> avatarChangeListeners = new CopyOnWriteArraySet<AvatarChangeListener>();
    private final ExecutorService avatarRequester;
    private final VCardManager vCardManager;
    private final Set<String> nonConformingResources = Collections.synchronizedSet(new HashSet());
    private final Map<String, byte[]> avatarCache;

    private AvatarManager(final XmppSession xmppSession) {
        super(xmppSession, new String[]{"urn:xmpp:avatar:metadata+notify", "urn:xmpp:avatar:metadata"});
        this.vCardManager = (VCardManager)xmppSession.getExtensionManager(VCardManager.class);
        this.avatarCache = new DirectoryAvatarCache(new File(System.getProperty("user.dir"), "avatars"));
        this.avatarRequester = Executors.newSingleThreadExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r, "Avatar Request Thread");
                thread.setDaemon(true);
                return thread;
            }
        });
        xmppSession.addSessionStatusListener(new SessionStatusListener(){

            public void sessionStatusChanged(SessionStatusEvent e) {
                if (e.getStatus() == XmppSession.Status.CLOSED) {
                    AvatarManager.this.avatarChangeListeners.clear();
                    AvatarManager.this.requestingAvatarLocks.clear();
                    AvatarManager.this.nonConformingResources.clear();
                    AvatarManager.this.userHashes.clear();
                    AvatarManager.this.avatarRequester.shutdown();
                }
            }
        });
        xmppSession.addPresenceListener(new PresenceListener(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void handle(PresenceEvent e) {
                if (!AvatarManager.this.isEnabled()) return;
                Presence presence = e.getPresence();
                if (e.isIncoming()) {
                    Jid contact;
                    AvatarUpdate avatarUpdate = (AvatarUpdate)presence.getExtension(AvatarUpdate.class);
                    if (presence.getFrom().asBareJid().equals((Object)xmppSession.getConnectedResource().asBareJid()) && presence.getFrom().getResource() != null && !presence.getFrom().getResource().equals(xmppSession.getConnectedResource().getResource())) {
                        if (avatarUpdate == null) {
                            if (presence.isAvailable()) {
                                AvatarManager.this.nonConformingResources.add(presence.getFrom().getResource());
                            } else if (presence.getType() == AbstractPresence.Type.UNAVAILABLE && AvatarManager.this.nonConformingResources.remove(presence.getFrom().getResource()) && AvatarManager.this.nonConformingResources.isEmpty()) {
                                AvatarManager.this.resetHash();
                            }
                        } else if (avatarUpdate.getHash() != null && !avatarUpdate.getHash().equals(AvatarManager.this.userHashes.get(xmppSession.getConnectedResource().asBareJid()))) {
                            AvatarManager.this.resetHash();
                        }
                    }
                    if (avatarUpdate == null || avatarUpdate.getHash() == null) return;
                    MucUser mucUser = (MucUser)presence.getExtension(MucUser.class);
                    if (mucUser != null) {
                        if (mucUser.getItem() == null || mucUser.getItem().getJid() == null) return;
                        contact = mucUser.getItem().getJid().asBareJid();
                    } else {
                        contact = presence.getFrom().asBareJid();
                    }
                    if (avatarUpdate.getHash().equals(AvatarManager.this.userHashes.put(contact, avatarUpdate.getHash()))) return;
                    byte[] imageData = AvatarManager.this.loadFromCache(avatarUpdate.getHash());
                    byte[] avatar = null;
                    if (imageData != null) {
                        avatar = imageData;
                    }
                    if (avatar != null) {
                        AvatarManager.this.notifyListeners(contact, avatar);
                        return;
                    } else {
                        AvatarManager.this.avatarRequester.execute(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    AvatarManager.this.notifyListeners(contact, AvatarManager.this.getAvatarByVCard(contact));
                                }
                                catch (XmppException e1) {
                                    logger.log(Level.WARNING, e1.getMessage(), e1);
                                }
                            }
                        });
                    }
                    return;
                } else {
                    if (!presence.isAvailable() || !AvatarManager.this.nonConformingResources.isEmpty()) return;
                    String myHash = (String)AvatarManager.this.userHashes.get(xmppSession.getConnectedResource().asBareJid());
                    if (myHash == null) {
                        presence.getExtensions().add(new AvatarUpdate());
                        AvatarManager.this.avatarRequester.execute(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    AvatarManager.this.getAvatarByVCard(xmppSession.getConnectedResource().asBareJid());
                                    Presence lastSentPresence = xmppSession.getPresenceManager().getLastSentPresence();
                                    Presence presence = new Presence();
                                    if (lastSentPresence != null) {
                                        presence.setPriority(lastSentPresence.getPriority());
                                        presence.getStatuses().addAll(lastSentPresence.getStatuses());
                                        presence.setShow(lastSentPresence.getShow());
                                        presence.setLanguage(lastSentPresence.getLanguage());
                                    }
                                    xmppSession.send((ClientStreamElement)presence);
                                }
                                catch (XmppException e1) {
                                    logger.log(Level.WARNING, e1.getMessage(), e1);
                                }
                            }
                        });
                        return;
                    } else {
                        if (presence.getExtension(AvatarUpdate.class) != null) return;
                        presence.getExtensions().add(new AvatarUpdate(myHash));
                    }
                }
            }
        });
        xmppSession.addMessageListener(new MessageListener(){

            public void handle(MessageEvent e) {
                Message message;
                Event event;
                if (e.isIncoming() && AvatarManager.this.isEnabled() && (event = (Event)(message = e.getMessage()).getExtension(Event.class)) != null) {
                    for (Item item : event.getItems()) {
                        if (!(item.getPayload() instanceof AvatarMetadata)) continue;
                        AvatarMetadata avatarMetadata = (AvatarMetadata)item.getPayload();
                        if (avatarMetadata.getInfoList().isEmpty()) {
                            AvatarManager.this.notifyListeners(message.getFrom().asBareJid(), null);
                            continue;
                        }
                        try {
                            Item i;
                            byte[] cachedImage = AvatarManager.this.loadFromCache(item.getId());
                            if (cachedImage != null) {
                                AvatarManager.this.notifyListeners(message.getFrom().asBareJid(), cachedImage);
                                continue;
                            }
                            AvatarMetadata.Info chosenInfo = null;
                            for (AvatarMetadata.Info info : avatarMetadata.getInfoList()) {
                                if (info.getUrl() != null) continue;
                                chosenInfo = info;
                            }
                            if (chosenInfo == null) {
                                for (AvatarMetadata.Info info : avatarMetadata.getInfoList()) {
                                    if (info.getUrl() == null) continue;
                                    chosenInfo = info;
                                    break;
                                }
                            }
                            if (chosenInfo != null && chosenInfo.getUrl() != null) {
                                URLConnection urlConnection = chosenInfo.getUrl().openConnection();
                                String type = urlConnection.getContentType();
                                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                                try (InputStream in = urlConnection.getInputStream();){
                                    int n;
                                    byte[] data = new byte[4096];
                                    while ((n = in.read(data, 0, 4096)) != -1) {
                                        baos.write(data, 0, n);
                                    }
                                }
                                byte[] data = baos.toByteArray();
                                AvatarManager.this.storeToCache(item.getId(), data);
                                AvatarManager.this.notifyListeners(message.getFrom().asBareJid(), data);
                                continue;
                            }
                            PubSubService pubSubService = ((PubSubManager)xmppSession.getExtensionManager(PubSubManager.class)).createPubSubService(message.getFrom());
                            List<Item> items = pubSubService.getNode("urn:xmpp:avatar:data").getItems(item.getId());
                            if (items.isEmpty() || !((i = items.get(0)).getPayload() instanceof AvatarData)) continue;
                            AvatarData avatarData = (AvatarData)i.getPayload();
                            AvatarManager.this.storeToCache(item.getId(), avatarData.getData());
                            AvatarManager.this.notifyListeners(message.getFrom().asBareJid(), avatarData.getData());
                        }
                        catch (IOException | XmppException e1) {
                            logger.log(Level.WARNING, e1.getMessage(), e1);
                        }
                    }
                }
            }
        });
        this.setEnabled(false);
    }

    private void resetHash() {
        this.userHashes.remove(this.xmppSession.getConnectedResource().asBareJid());
        Presence presence = this.xmppSession.getPresenceManager().getLastSentPresence();
        if (presence == null) {
            presence = new Presence();
        }
        presence.getExtensions().clear();
        this.xmppSession.send((ClientStreamElement)presence);
    }

    private void notifyListeners(Jid contact, byte[] avatar) {
        for (AvatarChangeListener avatarChangeListener : this.avatarChangeListeners) {
            try {
                avatarChangeListener.avatarChanged(new AvatarChangeEvent(this, contact, avatar));
            }
            catch (Exception e1) {
                logger.log(Level.WARNING, e1.getMessage(), e1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getAvatarByVCard(Jid contact) throws XmppException {
        byte[] avatar = null;
        Lock lock = new ReentrantLock();
        Lock existingLock = this.requestingAvatarLocks.putIfAbsent(contact, lock);
        if (existingLock != null) {
            lock = existingLock;
        }
        lock.lock();
        try {
            byte[] imageData;
            String hash = this.userHashes.get(contact);
            if (hash != null && (imageData = this.loadFromCache(hash)) != null) {
                avatar = imageData;
            }
            if (avatar == null) {
                VCard.Image image;
                avatar = new byte[]{};
                hash = "";
                VCardManager vCardManager = (VCardManager)this.xmppSession.getExtensionManager(VCardManager.class);
                VCard vCard = contact.equals((Object)this.xmppSession.getConnectedResource().asBareJid()) ? vCardManager.getVCard() : vCardManager.getVCard(contact);
                if (vCard != null && (image = vCard.getPhoto()) != null && image.getValue() != null && (hash = XmppUtils.hash((byte[])image.getValue())) != null) {
                    avatar = image.getValue();
                }
                this.userHashes.put(contact, hash);
                if (!Arrays.equals(avatar, new byte[0])) {
                    this.storeToCache(hash, avatar);
                }
            }
            byte[] byArray = avatar;
            return byArray;
        }
        finally {
            lock.unlock();
            this.requestingAvatarLocks.remove(contact);
        }
    }

    private synchronized byte[] loadFromCache(String hash) {
        if (this.avatarCache != null) {
            return this.avatarCache.get(hash);
        }
        return null;
    }

    private synchronized void storeToCache(String hash, byte[] image) {
        if (this.avatarCache != null) {
            this.avatarCache.put(hash, image);
        }
    }

    public byte[] getAvatar(Jid contact) throws XmppException {
        return this.getAvatarByVCard(contact.asBareJid());
    }

    public void publishAvatar(byte[] imageData) throws XmppException {
        if (imageData != null) {
            String hash = XmppUtils.hash((byte[])imageData);
            this.publishToVCard(imageData, null, hash);
            this.publishToPersonalEventingService(imageData, hash, new AvatarMetadata.Info(imageData.length, hash, hash));
        } else {
            this.publishToVCard(null, null, null);
            this.publishToPersonalEventingService(null, null, null);
        }
    }

    private void publishToVCard(byte[] avatar, String type, String hash) throws XmppException {
        VCard vCard = this.vCardManager.getVCard();
        if (avatar != null) {
            if (vCard.getPhoto() == null || !Arrays.equals(vCard.getPhoto().getValue(), avatar)) {
                this.userHashes.put(this.xmppSession.getConnectedResource().asBareJid(), hash);
                vCard.setPhoto(new VCard.Image(type, avatar));
                this.vCardManager.setVCard(vCard);
            }
        } else {
            this.userHashes.put(this.xmppSession.getConnectedResource().asBareJid(), "");
            if (vCard.getPhoto() != null && vCard.getPhoto().getValue() != null) {
                vCard.setPhoto(null);
                this.vCardManager.setVCard(vCard);
            }
        }
    }

    private void publishToPersonalEventingService(byte[] avatar, String itemId, AvatarMetadata.Info info) throws XmppException {
        PubSubService personalEventingService = ((PubSubManager)this.xmppSession.getExtensionManager(PubSubManager.class)).createPersonalEventingService();
        if (avatar != null) {
            if (info.getUrl() == null) {
                personalEventingService.getNode("urn:xmpp:avatar:data").publish(itemId, new AvatarData(avatar));
            }
            personalEventingService.getNode("urn:xmpp:avatar:metadata").publish(itemId, new AvatarMetadata(new AvatarMetadata.Info[]{info}));
        } else {
            personalEventingService.getNode("urn:xmpp:avatar:metadata").publish(itemId, new AvatarMetadata(new AvatarMetadata.Info[0]));
        }
    }

    public void addAvatarChangeListener(AvatarChangeListener avatarChangeListener) {
        this.avatarChangeListeners.add(avatarChangeListener);
    }

    public void removeAvatarChangeListener(AvatarChangeListener avatarChangeListener) {
        this.avatarChangeListeners.remove(avatarChangeListener);
    }
}

