/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.bob;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import rocks.xmpp.core.Jid;
import rocks.xmpp.core.XmppException;
import rocks.xmpp.core.session.ExtensionManager;
import rocks.xmpp.core.session.SessionStatusEvent;
import rocks.xmpp.core.session.SessionStatusListener;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.IQEvent;
import rocks.xmpp.core.stanza.IQListener;
import rocks.xmpp.core.stanza.model.AbstractIQ;
import rocks.xmpp.core.stanza.model.StanzaError;
import rocks.xmpp.core.stanza.model.client.IQ;
import rocks.xmpp.core.stanza.model.errors.Condition;
import rocks.xmpp.core.stanza.model.errors.ItemNotFound;
import rocks.xmpp.core.stream.model.ClientStreamElement;
import rocks.xmpp.extensions.bob.model.Data;

class BitsOfBinaryManager
extends ExtensionManager {
    private final Map<String, Data> dataCache = new ConcurrentHashMap<String, Data>();

    private BitsOfBinaryManager(final XmppSession xmppSession) {
        super(xmppSession, new String[]{"urn:xmpp:bob"});
        xmppSession.addSessionStatusListener(new SessionStatusListener(){

            public void sessionStatusChanged(SessionStatusEvent e) {
                if (e.getStatus() == XmppSession.Status.CLOSED) {
                    BitsOfBinaryManager.this.dataCache.clear();
                }
            }
        });
        xmppSession.addIQListener(new IQListener(){

            public void handle(IQEvent e) {
                Data data;
                IQ iq = e.getIQ();
                if (e.isIncoming() && BitsOfBinaryManager.this.isEnabled() && !e.isConsumed() && iq.getType() == AbstractIQ.Type.GET && (data = (Data)iq.getExtension(Data.class)) != null) {
                    Data cachedData = (Data)BitsOfBinaryManager.this.dataCache.get(data.getContentId());
                    if (cachedData != null) {
                        IQ result = iq.createResult();
                        result.setExtension((Object)cachedData);
                        xmppSession.send((ClientStreamElement)result);
                    } else {
                        xmppSession.send((ClientStreamElement)iq.createError(new StanzaError((Condition)new ItemNotFound())));
                    }
                    e.consume();
                }
            }
        });
    }

    public Data getData(String contentId, Jid to) throws XmppException {
        IQ result = this.xmppSession.query(new IQ(to, AbstractIQ.Type.GET, (Object)new Data(contentId)));
        Data data = (Data)result.getExtension(Data.class);
        return data;
    }

    public void put(Data data) {
        this.dataCache.put(data.getContentId(), data);
    }
}

