/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.bytestreams.ibb;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import rocks.xmpp.core.XmppException;
import rocks.xmpp.extensions.bytestreams.ibb.IbbSession;

final class IbbOutputStream
extends OutputStream {
    private final IbbSession ibbSession;
    private final byte[] buffer;
    private int n;
    private volatile boolean closed;

    public IbbOutputStream(IbbSession ibbSession, int blockSize) {
        this.ibbSession = ibbSession;
        this.buffer = new byte[blockSize];
    }

    @Override
    public synchronized void write(int b) throws IOException {
        this.buffer[this.n++] = (byte)b;
        if (this.n == this.buffer.length) {
            this.flush();
        }
    }

    @Override
    public synchronized void flush() throws IOException {
        super.flush();
        if (this.closed) {
            throw new IOException("Stream is closed.");
        }
        if (this.n == 0) {
            return;
        }
        try {
            this.ibbSession.send(Arrays.copyOf(this.buffer, this.n));
        }
        catch (XmppException e) {
            throw new IOException(e);
        }
        finally {
            this.n = 0;
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            super.close();
            this.flush();
            this.closed = true;
            this.ibbSession.close();
        }
    }
}

