/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.bytestreams.ibb;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import rocks.xmpp.core.Jid;
import rocks.xmpp.core.XmppException;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.model.AbstractIQ;
import rocks.xmpp.core.stanza.model.client.IQ;
import rocks.xmpp.extensions.bytestreams.ByteStreamSession;
import rocks.xmpp.extensions.bytestreams.ibb.IbbInputStream;
import rocks.xmpp.extensions.bytestreams.ibb.IbbOutputStream;
import rocks.xmpp.extensions.bytestreams.ibb.InBandByteStreamManager;
import rocks.xmpp.extensions.bytestreams.ibb.model.InBandByteStream;

final class IbbSession
extends ByteStreamSession {
    private final IbbOutputStream outputStream;
    private final IbbInputStream inputStream;
    private final Jid jid;
    private final int blockSize;
    private final XmppSession xmppSession;
    private final InBandByteStreamManager inBandByteStreamManager;
    private int incomingSequence = 0;
    private int outgoingSequence = 0;
    private volatile boolean closed;

    IbbSession(String sessionId, XmppSession xmppSession, Jid jid, int blockSize, InBandByteStreamManager manager) {
        super(sessionId);
        this.outputStream = new IbbOutputStream(this, blockSize);
        this.inputStream = new IbbInputStream(this);
        this.jid = jid;
        this.xmppSession = xmppSession;
        this.blockSize = blockSize;
        this.inBandByteStreamManager = manager;
    }

    boolean dataReceived(InBandByteStream.Data data) {
        if (this.incomingSequence++ == data.getSequence()) {
            this.inputStream.queue.offer(data);
            return true;
        }
        return false;
    }

    void open() throws XmppException {
        IQ iq = new IQ(AbstractIQ.Type.SET, (Object)new InBandByteStream.Open(this.blockSize, this.getSessionId()));
        iq.setTo(this.jid);
        this.xmppSession.query(iq);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (this.closed) {
            throw new IOException("IBB session is closed.");
        }
        return this.outputStream;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.closed) {
            throw new IOException("IBB session is closed.");
        }
        return this.inputStream;
    }

    @Override
    public int getReadTimeout() {
        return this.inputStream.readTimeout;
    }

    @Override
    public void setReadTimeout(int readTimeout) {
        this.inputStream.readTimeout = readTimeout;
    }

    synchronized void send(byte[] bytes) throws XmppException {
        this.xmppSession.query(new IQ(this.jid, AbstractIQ.Type.SET, (Object)new InBandByteStream.Data(bytes, this.getSessionId(), this.outgoingSequence)));
        if (++this.outgoingSequence > 65535) {
            this.outgoingSequence = 0;
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            try {
                this.inputStream.close();
                this.outputStream.close();
                this.xmppSession.query(new IQ(this.jid, AbstractIQ.Type.SET, (Object)new InBandByteStream.Close(this.getSessionId())));
            }
            catch (XmppException e) {
                throw new IOException(e);
            }
            finally {
                this.inBandByteStreamManager.ibbSessionMap.remove(this.getSessionId());
            }
        }
    }

    void closedByPeer() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.inputStream.close();
            this.outputStream.close();
        }
    }

    public String toString() {
        return "In-Band Bytestream Session: " + this.getSessionId();
    }
}

