/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.bytestreams.s5b;

import java.io.IOException;
import java.util.List;
import rocks.xmpp.core.Jid;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.model.StanzaError;
import rocks.xmpp.core.stanza.model.client.IQ;
import rocks.xmpp.core.stanza.model.errors.Condition;
import rocks.xmpp.core.stanza.model.errors.ItemNotFound;
import rocks.xmpp.core.stanza.model.errors.NotAcceptable;
import rocks.xmpp.core.stream.model.ClientStreamElement;
import rocks.xmpp.extensions.bytestreams.ByteStreamEvent;
import rocks.xmpp.extensions.bytestreams.ByteStreamSession;
import rocks.xmpp.extensions.bytestreams.s5b.S5bSession;
import rocks.xmpp.extensions.bytestreams.s5b.Socks5ByteStreamManager;
import rocks.xmpp.extensions.bytestreams.s5b.model.Socks5ByteStream;
import rocks.xmpp.extensions.bytestreams.s5b.model.StreamHost;

final class S5bEvent
extends ByteStreamEvent {
    private final XmppSession xmppSession;
    private final IQ iq;
    private final List<StreamHost> streamHosts;

    public S5bEvent(Object source, String sessionId, XmppSession xmppSession, IQ iq, List<StreamHost> streamHosts) {
        super(source, sessionId);
        this.xmppSession = xmppSession;
        this.iq = iq;
        this.streamHosts = streamHosts;
    }

    @Override
    public ByteStreamSession accept() throws IOException {
        try {
            S5bSession s5bSession = Socks5ByteStreamManager.createS5bSession(this.iq.getFrom(), this.iq.getTo(), this.getSessionId(), this.streamHosts);
            IQ result = this.iq.createResult();
            result.setExtension((Object)Socks5ByteStream.streamHostUsed((Jid)s5bSession.getStreamHost()));
            this.xmppSession.send((ClientStreamElement)result);
            return s5bSession;
        }
        catch (IOException e) {
            this.xmppSession.send((ClientStreamElement)this.iq.createError(new StanzaError((Condition)new ItemNotFound())));
            throw e;
        }
    }

    @Override
    public void reject() {
        this.xmppSession.send((ClientStreamElement)this.iq.createError(new StanzaError((Condition)new NotAcceptable())));
    }
}

