/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.muc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import rocks.xmpp.core.Jid;
import rocks.xmpp.core.XmppException;
import rocks.xmpp.core.session.SessionStatusEvent;
import rocks.xmpp.core.session.SessionStatusListener;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.MessageEvent;
import rocks.xmpp.core.stanza.MessageListener;
import rocks.xmpp.core.stanza.PresenceEvent;
import rocks.xmpp.core.stanza.PresenceListener;
import rocks.xmpp.core.stanza.StanzaEvent;
import rocks.xmpp.core.stanza.StanzaFilter;
import rocks.xmpp.core.stanza.model.AbstractIQ;
import rocks.xmpp.core.stanza.model.AbstractMessage;
import rocks.xmpp.core.stanza.model.AbstractPresence;
import rocks.xmpp.core.stanza.model.client.IQ;
import rocks.xmpp.core.stanza.model.client.Message;
import rocks.xmpp.core.stanza.model.client.Presence;
import rocks.xmpp.core.stream.model.ClientStreamElement;
import rocks.xmpp.extensions.data.model.DataForm;
import rocks.xmpp.extensions.delay.model.DelayedDelivery;
import rocks.xmpp.extensions.disco.ServiceDiscoveryManager;
import rocks.xmpp.extensions.disco.model.info.Feature;
import rocks.xmpp.extensions.disco.model.info.Identity;
import rocks.xmpp.extensions.disco.model.info.InfoNode;
import rocks.xmpp.extensions.disco.model.items.ItemNode;
import rocks.xmpp.extensions.muc.InvitationDeclineEvent;
import rocks.xmpp.extensions.muc.InvitationDeclineListener;
import rocks.xmpp.extensions.muc.Occupant;
import rocks.xmpp.extensions.muc.OccupantEvent;
import rocks.xmpp.extensions.muc.OccupantListener;
import rocks.xmpp.extensions.muc.RoomInfo;
import rocks.xmpp.extensions.muc.SubjectChangeEvent;
import rocks.xmpp.extensions.muc.SubjectChangeListener;
import rocks.xmpp.extensions.muc.conference.model.DirectInvitation;
import rocks.xmpp.extensions.muc.model.Actor;
import rocks.xmpp.extensions.muc.model.Affiliation;
import rocks.xmpp.extensions.muc.model.History;
import rocks.xmpp.extensions.muc.model.Item;
import rocks.xmpp.extensions.muc.model.Muc;
import rocks.xmpp.extensions.muc.model.MucFeature;
import rocks.xmpp.extensions.muc.model.RequestVoiceForm;
import rocks.xmpp.extensions.muc.model.Role;
import rocks.xmpp.extensions.muc.model.RoomInfoForm;
import rocks.xmpp.extensions.muc.model.admin.MucAdmin;
import rocks.xmpp.extensions.muc.model.owner.MucOwner;
import rocks.xmpp.extensions.muc.model.user.Decline;
import rocks.xmpp.extensions.muc.model.user.Invite;
import rocks.xmpp.extensions.muc.model.user.MucUser;
import rocks.xmpp.extensions.muc.model.user.Status;
import rocks.xmpp.extensions.register.model.Registration;

public final class ChatRoom {
    private static final Logger logger = Logger.getLogger(ChatRoom.class.getName());
    private final Set<InvitationDeclineListener> invitationDeclineListeners = new CopyOnWriteArraySet<InvitationDeclineListener>();
    private final Set<SubjectChangeListener> subjectChangeListeners = new CopyOnWriteArraySet<SubjectChangeListener>();
    private final Set<OccupantListener> occupantListeners = new CopyOnWriteArraySet<OccupantListener>();
    private final Set<MessageListener> messageListeners = new CopyOnWriteArraySet<MessageListener>();
    private final Map<String, Occupant> occupantMap = new HashMap<String, Occupant>();
    private final MessageListener messageListener;
    private final PresenceListener presenceListener;
    private ServiceDiscoveryManager serviceDiscoveryManager;
    private String name;
    private Jid roomJid;
    private XmppSession xmppSession;
    private volatile String nick;
    private volatile boolean entered;

    ChatRoom(String name, final Jid roomJid, XmppSession xmppSession) {
        this.name = name;
        this.roomJid = roomJid;
        this.xmppSession = xmppSession;
        this.serviceDiscoveryManager = (ServiceDiscoveryManager)xmppSession.getExtensionManager(ServiceDiscoveryManager.class);
        xmppSession.addSessionStatusListener(new SessionStatusListener(){

            public void sessionStatusChanged(SessionStatusEvent e) {
                if (e.getStatus() == XmppSession.Status.CLOSED) {
                    ChatRoom.this.invitationDeclineListeners.clear();
                    ChatRoom.this.subjectChangeListeners.clear();
                    ChatRoom.this.occupantListeners.clear();
                    ChatRoom.this.messageListeners.clear();
                    ChatRoom.this.occupantMap.clear();
                }
            }
        });
        this.messageListener = new MessageListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handle(MessageEvent e) {
                MessageListener messageListener = ChatRoom.this.messageListener;
                synchronized (messageListener) {
                    Message message;
                    if (e.isIncoming() && (message = e.getMessage()).getFrom().asBareJid().equals((Object)roomJid)) {
                        if (message.getType() == AbstractMessage.Type.GROUPCHAT) {
                            if (message.getSubject() != null && message.getBody() == null) {
                                DelayedDelivery delayedDelivery = (DelayedDelivery)message.getExtension(DelayedDelivery.class);
                                Date date = delayedDelivery != null ? delayedDelivery.getTimeStamp() : new Date();
                                ChatRoom.this.notifySubjectChangeListeners(new SubjectChangeEvent(ChatRoom.this, message.getSubject(), message.getFrom().getResource(), delayedDelivery != null, date));
                            } else {
                                ChatRoom.this.notifyMessageListeners(new MessageEvent((Object)ChatRoom.this, message, true));
                            }
                        } else {
                            Decline decline;
                            MucUser mucUser = (MucUser)message.getExtension(MucUser.class);
                            if (mucUser != null && (decline = mucUser.getDecline()) != null) {
                                ChatRoom.this.notifyInvitationDeclineListeners(new InvitationDeclineEvent(ChatRoom.this, roomJid, decline.getFrom(), decline.getReason()));
                            }
                        }
                    }
                }
            }
        };
        this.presenceListener = new PresenceListener(){

            public void handle(PresenceEvent e) {
                String nick;
                MucUser mucUser;
                Presence presence = e.getPresence();
                if (presence.getFrom() != null && presence.getFrom().asBareJid().equals((Object)roomJid) && e.isIncoming() && (mucUser = (MucUser)presence.getExtension(MucUser.class)) != null && (nick = presence.getFrom().getResource()) != null) {
                    boolean isSelfPresence = ChatRoom.this.isSelfPresence(presence);
                    if (presence.isAvailable()) {
                        Occupant occupant = new Occupant(presence, isSelfPresence);
                        Occupant previousOccupant = ChatRoom.this.occupantMap.put(nick, occupant);
                        if (previousOccupant == null) {
                            if (!isSelfPresence && ChatRoom.this.entered) {
                                ChatRoom.this.notifyOccupantListeners(new OccupantEvent(ChatRoom.this, occupant, OccupantEvent.Type.ENTERED, null, null, null));
                            }
                        } else {
                            ChatRoom.this.notifyOccupantListeners(new OccupantEvent(ChatRoom.this, occupant, OccupantEvent.Type.STATUS_CHANGED, null, null, null));
                        }
                    } else if (presence.getType() == AbstractPresence.Type.UNAVAILABLE) {
                        Occupant occupant = (Occupant)ChatRoom.this.occupantMap.remove(nick);
                        if (occupant != null) {
                            if (mucUser.getItem() != null) {
                                Actor actor = mucUser.getItem().getActor();
                                String reason = mucUser.getItem().getReason();
                                if (!mucUser.getStatusCodes().isEmpty()) {
                                    if (mucUser.getStatusCodes().contains(Status.kicked())) {
                                        ChatRoom.this.notifyOccupantListeners(new OccupantEvent(ChatRoom.this, occupant, OccupantEvent.Type.KICKED, actor, reason, null));
                                    } else if (mucUser.getStatusCodes().contains(Status.banned())) {
                                        ChatRoom.this.notifyOccupantListeners(new OccupantEvent(ChatRoom.this, occupant, OccupantEvent.Type.BANNED, actor, reason, null));
                                    } else if (mucUser.getStatusCodes().contains(Status.membershipRevoked())) {
                                        ChatRoom.this.notifyOccupantListeners(new OccupantEvent(ChatRoom.this, occupant, OccupantEvent.Type.MEMBERSHIP_REVOKED, actor, reason, null));
                                    } else if (mucUser.getStatusCodes().contains(Status.nicknameChanged())) {
                                        ChatRoom.this.notifyOccupantListeners(new OccupantEvent(ChatRoom.this, occupant, OccupantEvent.Type.NICKNAME_CHANGED, actor, reason, null));
                                    } else if (mucUser.getStatusCodes().contains(Status.systemShutdown())) {
                                        ChatRoom.this.notifyOccupantListeners(new OccupantEvent(ChatRoom.this, occupant, OccupantEvent.Type.SYSTEM_SHUTDOWN, actor, reason, null));
                                    }
                                } else if (mucUser.getDestroy() != null) {
                                    ChatRoom.this.notifyOccupantListeners(new OccupantEvent(ChatRoom.this, occupant, OccupantEvent.Type.ROOM_DESTROYED, actor, mucUser.getDestroy().getReason(), mucUser.getDestroy().getJid()));
                                } else {
                                    ChatRoom.this.notifyOccupantListeners(new OccupantEvent(ChatRoom.this, occupant, OccupantEvent.Type.EXITED, null, null, null));
                                }
                            } else {
                                ChatRoom.this.notifyOccupantListeners(new OccupantEvent(ChatRoom.this, occupant, OccupantEvent.Type.EXITED, null, null, null));
                            }
                        }
                        if (isSelfPresence) {
                            ChatRoom.this.userHasExited();
                        }
                    }
                }
            }
        };
    }

    private void userHasExited() {
        this.xmppSession.removeMessageListener(this.messageListener);
        this.xmppSession.removePresenceListener(this.presenceListener);
    }

    private void notifyInvitationDeclineListeners(InvitationDeclineEvent invitationDeclineEvent) {
        for (InvitationDeclineListener invitationDeclineListener : this.invitationDeclineListeners) {
            try {
                invitationDeclineListener.invitationDeclined(invitationDeclineEvent);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
    }

    private void notifyOccupantListeners(OccupantEvent occupantEvent) {
        for (OccupantListener occupantListener : this.occupantListeners) {
            try {
                occupantListener.occupantChanged(occupantEvent);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
    }

    private void notifySubjectChangeListeners(SubjectChangeEvent subjectChangeEvent) {
        for (SubjectChangeListener subjectChangeListener : this.subjectChangeListeners) {
            try {
                subjectChangeListener.subjectChanged(subjectChangeEvent);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
    }

    private void notifyMessageListeners(MessageEvent messageEvent) {
        for (MessageListener messageListener : this.messageListeners) {
            try {
                messageListener.handle((StanzaEvent)messageEvent);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
    }

    private boolean isSelfPresence(Presence presence) {
        boolean isSelfPresence = false;
        MucUser mucUser = (MucUser)presence.getExtension(MucUser.class);
        if (mucUser != null) {
            isSelfPresence = mucUser.getStatusCodes().contains(Status.self()) || mucUser.getStatusCodes().contains(Status.serviceHasAssignedOrModifiedNick());
        }
        return isSelfPresence || this.nick != null && presence.getFrom() != null && this.nick.equals(presence.getFrom().getResource());
    }

    public void addInvitationDeclineListener(InvitationDeclineListener invitationDeclineListener) {
        this.invitationDeclineListeners.add(invitationDeclineListener);
    }

    public void removeInvitationDeclineListener(InvitationDeclineListener invitationDeclineListener) {
        this.invitationDeclineListeners.remove(invitationDeclineListener);
    }

    public void addSubjectChangeListener(SubjectChangeListener subjectChangeListener) {
        this.subjectChangeListeners.add(subjectChangeListener);
    }

    public void removeSubjectChangeListener(SubjectChangeListener subjectChangeListener) {
        this.subjectChangeListeners.remove(subjectChangeListener);
    }

    public void addMessageListener(MessageListener messageListener) {
        this.messageListeners.add(messageListener);
    }

    public void removeMessageListener(MessageListener messageListener) {
        this.messageListeners.remove(messageListener);
    }

    public void addOccupantListener(OccupantListener occupantListener) {
        this.occupantListeners.add(occupantListener);
    }

    public void removeOccupantListener(OccupantListener occupantListener) {
        this.occupantListeners.remove(occupantListener);
    }

    public void enter(String nick) throws XmppException {
        this.enter(nick, null, null);
    }

    public void enter(String nick, String password) throws XmppException {
        this.enter(nick, password, null);
    }

    public void enter(String nick, History history) throws XmppException {
        this.enter(nick, null, history);
    }

    public synchronized void enter(String nick, String password, History history) throws XmppException {
        if (nick == null) {
            throw new IllegalArgumentException("nick must not be null.");
        }
        if (this.entered) {
            throw new IllegalStateException("You already entered this room.");
        }
        try {
            this.xmppSession.addMessageListener(this.messageListener);
            this.xmppSession.addPresenceListener(this.presenceListener);
            Presence enterPresence = new Presence();
            enterPresence.setTo(this.roomJid.withResource(nick));
            enterPresence.getExtensions().add(new Muc(password, history));
            this.nick = nick;
            this.xmppSession.sendAndAwaitPresence((ClientStreamElement)enterPresence, (StanzaFilter)new StanzaFilter<Presence>(){

                public boolean accept(Presence presence) {
                    Jid room = presence.getFrom().asBareJid();
                    return room.equals((Object)ChatRoom.this.roomJid) && ChatRoom.this.isSelfPresence(presence);
                }
            });
        }
        catch (XmppException e) {
            this.xmppSession.removeMessageListener(this.messageListener);
            this.xmppSession.removePresenceListener(this.presenceListener);
            throw e;
        }
        this.entered = true;
    }

    public void changeSubject(final String subject) throws XmppException {
        Message message = new Message(this.roomJid, AbstractMessage.Type.GROUPCHAT);
        message.setSubject(subject);
        this.xmppSession.sendAndAwaitMessage((ClientStreamElement)message, (StanzaFilter)new StanzaFilter<Message>(){

            public boolean accept(Message message) {
                return message.getSubject() != null && message.getSubject().equals(subject);
            }
        });
    }

    public void sendMessage(String message) {
        Message m = new Message(this.roomJid, AbstractMessage.Type.GROUPCHAT);
        m.setBody(message);
        this.xmppSession.send((ClientStreamElement)m);
    }

    public void sendMessage(Message message) {
        message.setType(AbstractMessage.Type.GROUPCHAT);
        message.setTo(this.roomJid);
        this.xmppSession.send((ClientStreamElement)message);
    }

    public synchronized void changeNickname(String newNickname) throws XmppException {
        if (!this.entered) {
            throw new IllegalStateException("You must have entered the room to change your nickname.");
        }
        final Presence changeNickNamePresence = new Presence();
        changeNickNamePresence.setTo(this.roomJid.withResource(newNickname));
        this.xmppSession.sendAndAwaitPresence((ClientStreamElement)changeNickNamePresence, (StanzaFilter)new StanzaFilter<Presence>(){

            public boolean accept(Presence presence) {
                return presence.getFrom().equals((Object)changeNickNamePresence.getTo());
            }
        });
    }

    public synchronized void changeAvailabilityStatus(AbstractPresence.Show show, String status) {
        if (!this.entered) {
            throw new IllegalStateException("You must have entered the room to change the availability status.");
        }
        Presence presence = new Presence();
        presence.setTo(this.roomJid.withResource(this.nick));
        presence.setShow(show);
        presence.setStatus(status);
        this.xmppSession.send((ClientStreamElement)presence);
    }

    public void invite(Jid invitee, String reason) {
        this.invite(invitee, reason, false);
    }

    public void invite(Jid invitee, String reason, boolean direct) {
        Message message;
        if (direct) {
            message = new Message(invitee, AbstractMessage.Type.NORMAL);
            message.getExtensions().add(new DirectInvitation(this.roomJid, null, reason));
        } else {
            message = new Message(this.roomJid, AbstractMessage.Type.NORMAL);
            message.getExtensions().add(MucUser.withInvites((Invite[])new Invite[]{new Invite(invitee, reason)}));
        }
        this.xmppSession.send((ClientStreamElement)message);
    }

    public DataForm getRegistrationForm() throws XmppException {
        IQ iq = new IQ(this.roomJid, AbstractIQ.Type.GET, (Object)new Registration());
        IQ result = this.xmppSession.query(iq);
        Registration registration = (Registration)result.getExtension(Registration.class);
        if (registration != null) {
            return registration.getRegistrationForm();
        }
        return null;
    }

    public void submitRegistrationForm(DataForm dataForm) throws XmppException {
        if (dataForm == null) {
            throw new IllegalArgumentException("dataForm must not be null.");
        }
        if (dataForm.getType() != DataForm.Type.SUBMIT) {
            throw new IllegalArgumentException("Data Form must be of type 'submit'");
        }
        if (!"http://jabber.org/protocol/muc#register".equals(dataForm.getFormType())) {
            throw new IllegalArgumentException("Data Form is not of type 'http://jabber.org/protocol/muc#register'");
        }
        Registration registration = new Registration(dataForm);
        IQ iq = new IQ(this.roomJid, AbstractIQ.Type.SET, (Object)registration);
        this.xmppSession.query(iq);
    }

    public String getReservedNickname() throws XmppException {
        ServiceDiscoveryManager serviceDiscoveryManager = (ServiceDiscoveryManager)this.xmppSession.getExtensionManager(ServiceDiscoveryManager.class);
        InfoNode infoNode = serviceDiscoveryManager.discoverInformation(this.roomJid, "x-roomuser-item");
        if (infoNode != null) {
            for (Identity identity : infoNode.getIdentities()) {
                if (!"conference".equals(identity.getCategory()) || !"text".equals(identity.getType())) continue;
                return identity.getName();
            }
        }
        return null;
    }

    public void requestVoice() {
        Message message = new Message(this.roomJid);
        DataForm dataForm = new DataForm(DataForm.Type.SUBMIT);
        RequestVoiceForm requestVoiceForm = new RequestVoiceForm(dataForm);
        requestVoiceForm.setRole(Role.PARTICIPANT);
        message.getExtensions().add(dataForm);
        this.xmppSession.send((ClientStreamElement)message);
    }

    public void exit() {
        this.exit(null);
    }

    public synchronized void exit(String message) {
        if (!this.entered) {
            throw new IllegalStateException("You can't exit a room, when you didn't enter it.");
        }
        Presence presence = new Presence(AbstractPresence.Type.UNAVAILABLE);
        presence.setTo(this.roomJid.withResource(this.nick));
        presence.setStatus(message);
        this.xmppSession.send((ClientStreamElement)presence);
        this.userHasExited();
        this.nick = null;
        this.entered = false;
        this.occupantMap.clear();
    }

    public List<? extends Item> getVoiceList() throws XmppException {
        IQ result = this.xmppSession.query(new IQ(this.roomJid, AbstractIQ.Type.GET, (Object)MucAdmin.withItem((Role)Role.PARTICIPANT, null, null)));
        MucAdmin mucAdmin = (MucAdmin)result.getExtension(MucAdmin.class);
        return mucAdmin.getItems();
    }

    public void changeAffiliationsOrRoles(List<Item> items) throws XmppException {
        this.xmppSession.query(new IQ(this.roomJid, AbstractIQ.Type.SET, (Object)MucAdmin.withItems(items)));
    }

    public List<? extends Item> getBanList() throws XmppException {
        IQ result = this.xmppSession.query(new IQ(this.roomJid, AbstractIQ.Type.GET, (Object)MucAdmin.withItem((Affiliation)Affiliation.OUTCAST, null, null)));
        MucAdmin mucAdmin = (MucAdmin)result.getExtension(MucAdmin.class);
        return mucAdmin.getItems();
    }

    public void changeAffiliation(Affiliation affiliation, Jid user, String reason) throws XmppException {
        this.xmppSession.query(new IQ(this.roomJid, AbstractIQ.Type.SET, (Object)MucAdmin.withItem((Affiliation)affiliation, (Jid)user, (String)reason)));
    }

    public void changeRole(Role role, String nickname, String reason) throws XmppException {
        this.xmppSession.query(new IQ(this.roomJid, AbstractIQ.Type.SET, (Object)MucAdmin.withItem((Role)role, (String)nickname, (String)reason)));
    }

    public List<? extends Item> getMembers() throws XmppException {
        IQ result = this.xmppSession.query(new IQ(this.roomJid, AbstractIQ.Type.GET, (Object)MucAdmin.withItem((Affiliation)Affiliation.MEMBER, null, null)));
        MucAdmin mucAdmin = (MucAdmin)result.getExtension(MucAdmin.class);
        return mucAdmin.getItems();
    }

    public List<? extends Item> getModerators() throws XmppException {
        IQ result = this.xmppSession.query(new IQ(this.roomJid, AbstractIQ.Type.GET, (Object)MucAdmin.withItem((Role)Role.MODERATOR, null, null)));
        MucAdmin mucAdmin = (MucAdmin)result.getExtension(MucAdmin.class);
        return mucAdmin.getItems();
    }

    public void createRoom() throws XmppException {
        this.enter(this.nick);
        this.xmppSession.query(new IQ(this.roomJid, AbstractIQ.Type.SET, (Object)new MucOwner(new DataForm(DataForm.Type.SUBMIT))));
    }

    public RoomInfo getRoomInfo() throws XmppException {
        InfoNode infoNode = this.serviceDiscoveryManager.discoverInformation(this.roomJid);
        Identity identity = null;
        HashSet<MucFeature> mucFeatures = new HashSet<MucFeature>();
        RoomInfoForm roomInfoForm = null;
        if (infoNode != null) {
            Set identities = infoNode.getIdentities();
            Iterator iterator = identities.iterator();
            if (iterator.hasNext()) {
                identity = (Identity)iterator.next();
            }
            for (Feature feature : infoNode.getFeatures()) {
                for (MucFeature mucFeature : MucFeature.values()) {
                    if (!mucFeature.getServiceDiscoveryFeature().equals(feature.getVar())) continue;
                    mucFeatures.add(mucFeature);
                }
            }
            for (DataForm dataForm : infoNode.getExtensions()) {
                DataForm.Field formType = dataForm.findField("FORM_TYPE");
                if (formType == null || formType.getValues().isEmpty() || !((String)formType.getValues().get(0)).equals("http://jabber.org/protocol/muc#roominfo")) continue;
                roomInfoForm = new RoomInfoForm(dataForm);
                break;
            }
        }
        return new RoomInfo(identity, mucFeatures, roomInfoForm);
    }

    public List<String> discoverOccupants() throws XmppException {
        ItemNode itemNode = this.serviceDiscoveryManager.discoverItems(this.roomJid);
        ArrayList<String> occupants = new ArrayList<String>();
        List items = itemNode.getItems();
        for (rocks.xmpp.extensions.disco.model.items.Item item : items) {
            String nickname;
            if (item.getJid() == null || (nickname = item.getJid().getResource()) == null) continue;
            occupants.add(nickname);
        }
        return occupants;
    }

    public Collection<Occupant> getOccupants() {
        return this.occupantMap.values();
    }

    public Occupant getOccupant(String nickname) {
        return this.occupantMap.get(nickname);
    }

    public DataForm getConfigurationForm() throws XmppException {
        IQ result = this.xmppSession.query(new IQ(this.roomJid, AbstractIQ.Type.GET, (Object)new MucOwner()));
        MucOwner mucOwner = (MucOwner)result.getExtension(MucOwner.class);
        return mucOwner.getConfigurationForm();
    }

    public void submitConfigurationForm(DataForm dataForm) throws XmppException {
        if (dataForm == null) {
            throw new IllegalArgumentException("dataForm must not be null.");
        }
        if (dataForm.getType() != DataForm.Type.SUBMIT && dataForm.getType() != DataForm.Type.CANCEL) {
            throw new IllegalArgumentException("Data Form must be of type 'submit' or 'cancel'");
        }
        if (!"http://jabber.org/protocol/muc#roomconfig".equals(dataForm.getFormType())) {
            throw new IllegalArgumentException("Data Form is not of type 'http://jabber.org/protocol/muc#roomconfig'");
        }
        MucOwner mucOwner = new MucOwner(dataForm);
        IQ iq = new IQ(this.roomJid, AbstractIQ.Type.SET, (Object)mucOwner);
        this.xmppSession.query(iq);
    }

    public String getName() {
        return this.name;
    }

    public void destroy(String reason) throws XmppException {
        MucOwner mucOwner = MucOwner.withDestroy((Jid)this.roomJid, (String)reason);
        IQ iq = new IQ(this.roomJid, AbstractIQ.Type.SET, (Object)mucOwner);
        this.xmppSession.query(iq);
    }

    public Jid getAddress() {
        return this.roomJid;
    }

    public String toString() {
        return this.roomJid.toString();
    }
}

