/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.offline;

import java.util.ArrayList;
import java.util.List;
import rocks.xmpp.core.Jid;
import rocks.xmpp.core.XmppException;
import rocks.xmpp.core.session.ExtensionManager;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.model.AbstractIQ;
import rocks.xmpp.core.stanza.model.client.IQ;
import rocks.xmpp.extensions.data.model.DataForm;
import rocks.xmpp.extensions.disco.ServiceDiscoveryManager;
import rocks.xmpp.extensions.disco.model.info.Feature;
import rocks.xmpp.extensions.disco.model.info.InfoNode;
import rocks.xmpp.extensions.disco.model.items.Item;
import rocks.xmpp.extensions.disco.model.items.ItemNode;
import rocks.xmpp.extensions.offline.model.OfflineMessage;
import rocks.xmpp.extensions.offline.model.OfflineMessageHeader;

public final class OfflineMessageManager
extends ExtensionManager {
    private OfflineMessageManager(XmppSession xmppSession) {
        super(xmppSession, new String[0]);
    }

    public boolean isSupported() throws XmppException {
        ServiceDiscoveryManager serviceDiscoveryManager = (ServiceDiscoveryManager)this.xmppSession.getExtensionManager(ServiceDiscoveryManager.class);
        InfoNode infoNode = serviceDiscoveryManager.discoverInformation(null);
        return infoNode.getFeatures().contains(new Feature("http://jabber.org/protocol/offline"));
    }

    public int requestNumberOfMessages() throws XmppException {
        DataForm dataForm;
        ServiceDiscoveryManager serviceDiscoveryManager = (ServiceDiscoveryManager)this.xmppSession.getExtensionManager(ServiceDiscoveryManager.class);
        InfoNode infoDiscovery = serviceDiscoveryManager.discoverInformation(null, "http://jabber.org/protocol/offline");
        if (!infoDiscovery.getExtensions().isEmpty() && (dataForm = (DataForm)infoDiscovery.getExtensions().get(0)) != null) {
            for (DataForm.Field field : dataForm.getFields()) {
                if (!"number_of_messages".equals(field.getVar())) continue;
                String numberOfMessages = (String)field.getValues().get(0);
                return Integer.parseInt(numberOfMessages);
            }
        }
        return 0;
    }

    public List<OfflineMessageHeader> requestMessageHeaders() throws XmppException {
        ArrayList<OfflineMessageHeader> result = new ArrayList<OfflineMessageHeader>();
        ServiceDiscoveryManager serviceDiscoveryManager = (ServiceDiscoveryManager)this.xmppSession.getExtensionManager(ServiceDiscoveryManager.class);
        ItemNode itemNode = serviceDiscoveryManager.discoverItems(null, "http://jabber.org/protocol/offline");
        for (Item item : itemNode.getItems()) {
            result.add(new OfflineMessageHeader(Jid.valueOf((String)item.getName()), item.getNode()));
        }
        return result;
    }

    public void requestMessage(String id) throws XmppException {
        this.xmppSession.query(new IQ(AbstractIQ.Type.GET, (Object)new OfflineMessage(new OfflineMessage.Item(id, OfflineMessage.Item.Action.VIEW))));
    }

    public void removeMessages(String ... ids) throws XmppException {
        OfflineMessage offlineMessage = new OfflineMessage();
        for (String id : ids) {
            offlineMessage.getItems().add(new OfflineMessage.Item(id, OfflineMessage.Item.Action.REMOVE));
        }
        this.xmppSession.query(new IQ(AbstractIQ.Type.SET, (Object)offlineMessage));
    }

    public void requestAllMessages() throws XmppException {
        this.xmppSession.query(new IQ(AbstractIQ.Type.GET, (Object)new OfflineMessage(true, false)));
    }

    public void removeAllMessages() throws XmppException {
        this.xmppSession.query(new IQ(AbstractIQ.Type.SET, (Object)new OfflineMessage(false, true)));
    }
}

