/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.chatstates;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import rocks.xmpp.core.Jid;
import rocks.xmpp.core.session.ChatSession;
import rocks.xmpp.core.session.ChatSessionEvent;
import rocks.xmpp.core.session.ChatSessionListener;
import rocks.xmpp.core.session.ExtensionManager;
import rocks.xmpp.core.session.SessionStatusEvent;
import rocks.xmpp.core.session.SessionStatusListener;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.MessageEvent;
import rocks.xmpp.core.stanza.MessageListener;
import rocks.xmpp.core.stanza.model.client.Message;
import rocks.xmpp.extensions.chatstates.ChatState;
import rocks.xmpp.extensions.chatstates.ChatStateEvent;
import rocks.xmpp.extensions.chatstates.ChatStateListener;
import rocks.xmpp.extensions.chatstates.model.Active;
import rocks.xmpp.extensions.chatstates.model.Composing;
import rocks.xmpp.extensions.chatstates.model.Gone;
import rocks.xmpp.extensions.chatstates.model.Inactive;
import rocks.xmpp.extensions.chatstates.model.Paused;

public final class ChatStateManager
extends ExtensionManager {
    private final Set<ChatStateListener> chatStateListeners = new CopyOnWriteArraySet<ChatStateListener>();
    private final Map<ChatSession, ChatState> chatSessionMap = new ConcurrentHashMap<ChatSession, ChatState>();
    private final Map<Jid, Boolean> contactSupportsChatStateNotifications = new HashMap<Jid, Boolean>();

    private ChatStateManager(XmppSession xmppSession) {
        super(xmppSession, new String[]{"http://jabber.org/protocol/chatstates"});
        xmppSession.addSessionStatusListener(new SessionStatusListener(){

            public void sessionStatusChanged(SessionStatusEvent e) {
                if (e.getStatus() == XmppSession.Status.CLOSED) {
                    ChatStateManager.this.chatStateListeners.clear();
                    ChatStateManager.this.chatSessionMap.clear();
                    ChatStateManager.this.contactSupportsChatStateNotifications.clear();
                }
            }
        });
        xmppSession.getChatManager().addChatSessionListener(new ChatSessionListener(){

            public void chatSessionCreated(ChatSessionEvent chatSessionEvent) {
                final ChatSession chatSession = chatSessionEvent.getChatSession();
                chatSession.addMessageListener(new MessageListener(){

                    public void handle(MessageEvent e) {
                        if (ChatStateManager.this.isEnabled()) {
                            Message message = e.getMessage();
                            if (!e.isIncoming() && !ChatStateManager.this.contactSupportsChatStateNotifications.containsKey(message.getTo()) && ((Boolean)ChatStateManager.this.contactSupportsChatStateNotifications.get(message.getTo())).booleanValue() && message.getExtension(Active.class) == null && message.getExtension(Composing.class) == null && message.getExtension(Gone.class) == null && message.getExtension(Inactive.class) == null && message.getExtension(Paused.class) == null) {
                                message.getExtensions().add(new Active());
                                ChatStateManager.this.notifyChatStateListeners(chatSession, ChatState.ACTIVE, !e.isIncoming());
                            }
                            if (message.getExtension(Active.class) != null) {
                                ChatStateManager.this.notifyChatStateListeners(chatSession, ChatState.ACTIVE, !e.isIncoming());
                            } else if (message.getExtension(Composing.class) != null) {
                                ChatStateManager.this.notifyChatStateListeners(chatSession, ChatState.COMPOSING, !e.isIncoming());
                            } else if (message.getExtension(Gone.class) != null) {
                                ChatStateManager.this.notifyChatStateListeners(chatSession, ChatState.GONE, !e.isIncoming());
                            } else if (message.getExtension(Inactive.class) != null) {
                                ChatStateManager.this.notifyChatStateListeners(chatSession, ChatState.INACTIVE, !e.isIncoming());
                            } else if (message.getExtension(Paused.class) != null) {
                                ChatStateManager.this.notifyChatStateListeners(chatSession, ChatState.PAUSED, !e.isIncoming());
                            }
                        }
                    }
                });
            }
        });
    }

    private void notifyChatStateListeners(ChatSession chatSession, ChatState chatState, boolean local) {
        for (ChatStateListener chatStateListener : this.chatStateListeners) {
            chatStateListener.chatStateUpdated(new ChatStateEvent((Object)this, chatSession, chatState, local));
        }
    }
}

