/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.muc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import rocks.xmpp.core.Jid;
import rocks.xmpp.core.XmppException;
import rocks.xmpp.core.session.ExtensionManager;
import rocks.xmpp.core.session.SessionStatusEvent;
import rocks.xmpp.core.session.SessionStatusListener;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.MessageEvent;
import rocks.xmpp.core.stanza.MessageListener;
import rocks.xmpp.core.stanza.model.client.Message;
import rocks.xmpp.extensions.disco.ServiceDiscoveryManager;
import rocks.xmpp.extensions.disco.model.info.Feature;
import rocks.xmpp.extensions.disco.model.info.InfoNode;
import rocks.xmpp.extensions.disco.model.items.Item;
import rocks.xmpp.extensions.disco.model.items.ItemNode;
import rocks.xmpp.extensions.muc.ChatService;
import rocks.xmpp.extensions.muc.InvitationEvent;
import rocks.xmpp.extensions.muc.InvitationListener;
import rocks.xmpp.extensions.muc.conference.model.DirectInvitation;
import rocks.xmpp.extensions.muc.model.user.Invite;
import rocks.xmpp.extensions.muc.model.user.MucUser;

public final class MultiUserChatManager
extends ExtensionManager {
    private static final Logger logger = Logger.getLogger(MultiUserChatManager.class.getName());
    private final ServiceDiscoveryManager serviceDiscoveryManager;
    private final Set<InvitationListener> invitationListeners = new CopyOnWriteArraySet<InvitationListener>();

    private MultiUserChatManager(final XmppSession xmppSession) {
        super(xmppSession, new String[]{"http://jabber.org/protocol/muc"});
        xmppSession.addSessionStatusListener(new SessionStatusListener(){

            public void sessionStatusChanged(SessionStatusEvent e) {
                if (e.getStatus() == XmppSession.Status.CLOSED) {
                    MultiUserChatManager.this.invitationListeners.clear();
                }
            }
        });
        xmppSession.addMessageListener(new MessageListener(){

            public void handle(MessageEvent e) {
                if (e.isIncoming()) {
                    Message message = e.getMessage();
                    MucUser mucUser = (MucUser)message.getExtension(MucUser.class);
                    if (mucUser != null) {
                        for (Invite invite : mucUser.getInvites()) {
                            MultiUserChatManager.this.notifyListeners(new InvitationEvent((Object)MultiUserChatManager.this, xmppSession, invite.getFrom(), message.getFrom(), invite.getReason(), mucUser.getPassword(), invite.isContinue(), invite.getThread(), true));
                        }
                    } else {
                        DirectInvitation directInvitation = (DirectInvitation)message.getExtension(DirectInvitation.class);
                        if (directInvitation != null) {
                            MultiUserChatManager.this.notifyListeners(new InvitationEvent((Object)MultiUserChatManager.this, xmppSession, message.getFrom(), directInvitation.getRoomAddress(), directInvitation.getReason(), directInvitation.getPassword(), directInvitation.isContinue(), directInvitation.getThread(), false));
                        }
                    }
                }
            }
        });
        this.serviceDiscoveryManager = (ServiceDiscoveryManager)xmppSession.getExtensionManager(ServiceDiscoveryManager.class);
    }

    private void notifyListeners(InvitationEvent invitationEvent) {
        for (InvitationListener invitationListener : this.invitationListeners) {
            try {
                invitationListener.invitationReceived(invitationEvent);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
    }

    public void addInvitationListener(InvitationListener invitationListener) {
        this.invitationListeners.add(invitationListener);
    }

    public void removeInvitationListener(InvitationListener invitationListener) {
        this.invitationListeners.remove(invitationListener);
    }

    public Collection<ChatService> getChatServices() throws XmppException {
        ItemNode itemDiscovery = this.serviceDiscoveryManager.discoverItems(null);
        ArrayList<ChatService> chatServices = new ArrayList<ChatService>();
        for (Item item : itemDiscovery.getItems()) {
            InfoNode infoDiscovery = this.serviceDiscoveryManager.discoverInformation(item.getJid());
            if (!infoDiscovery.getFeatures().contains(new Feature("http://jabber.org/protocol/muc"))) continue;
            chatServices.add(new ChatService(item.getJid(), this.xmppSession, this.serviceDiscoveryManager));
        }
        return chatServices;
    }

    public ChatService createChatService(Jid chatService) {
        return new ChatService(chatService, this.xmppSession, this.serviceDiscoveryManager);
    }
}

