/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.pubsub;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import rocks.xmpp.core.Jid;
import rocks.xmpp.core.XmppException;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.model.AbstractIQ;
import rocks.xmpp.core.stanza.model.client.IQ;
import rocks.xmpp.extensions.data.model.DataForm;
import rocks.xmpp.extensions.disco.ServiceDiscoveryManager;
import rocks.xmpp.extensions.disco.model.info.Identity;
import rocks.xmpp.extensions.disco.model.info.InfoNode;
import rocks.xmpp.extensions.disco.model.items.ItemNode;
import rocks.xmpp.extensions.pubsub.NodeInfo;
import rocks.xmpp.extensions.pubsub.model.Affiliation;
import rocks.xmpp.extensions.pubsub.model.Item;
import rocks.xmpp.extensions.pubsub.model.PubSub;
import rocks.xmpp.extensions.pubsub.model.PubSubFeature;
import rocks.xmpp.extensions.pubsub.model.PubSubMetaDataForm;
import rocks.xmpp.extensions.pubsub.model.Subscription;
import rocks.xmpp.extensions.pubsub.model.owner.PubSubOwner;

public final class PubSubNode {
    private final String name;
    private final Type type;
    private final Jid pubSubServiceAddress;
    private final XmppSession xmppSession;
    private final ServiceDiscoveryManager serviceDiscoveryManager;
    private String nodeId;

    PubSubNode(String nodeId, String name, Jid pubSubServiceAddress, XmppSession xmppSession) {
        this(nodeId, name, nodeId == null ? Type.LEAF : Type.COLLECTION, pubSubServiceAddress, xmppSession);
    }

    PubSubNode(String nodeId, String name, Type type, Jid pubSubServiceAddress, XmppSession xmppSession) {
        this.nodeId = nodeId;
        this.name = name;
        this.type = type;
        this.pubSubServiceAddress = pubSubServiceAddress;
        this.xmppSession = xmppSession;
        this.serviceDiscoveryManager = (ServiceDiscoveryManager)xmppSession.getExtensionManager(ServiceDiscoveryManager.class);
    }

    public NodeInfo getNodeInfo() throws XmppException {
        InfoNode infoNode = this.serviceDiscoveryManager.discoverInformation(this.pubSubServiceAddress);
        Identity identity = null;
        HashSet<PubSubFeature> features = new HashSet<PubSubFeature>();
        PubSubMetaDataForm metaDataForm = null;
        if (infoNode != null) {
            Set identities = infoNode.getIdentities();
            Iterator iterator = identities.iterator();
            if (iterator.hasNext()) {
                identity = (Identity)iterator.next();
            }
            for (DataForm dataForm : infoNode.getExtensions()) {
                String formType = dataForm.getFormType();
                if (!"http://jabber.org/protocol/pubsub#meta-data".equals(formType)) continue;
                metaDataForm = new PubSubMetaDataForm(dataForm);
                break;
            }
        }
        return new NodeInfo(identity, features, metaDataForm);
    }

    public List<Item> discoverItems() throws XmppException {
        ItemNode itemNode = this.serviceDiscoveryManager.discoverItems(this.pubSubServiceAddress, this.nodeId);
        ArrayList<Item> result = new ArrayList<Item>();
        for (rocks.xmpp.extensions.disco.model.items.Item item : itemNode.getItems()) {
            result.add((Item)new PubSub.ItemElement(item.getName()));
        }
        return result;
    }

    public List<Subscription> getSubscriptions() throws XmppException {
        IQ result = this.xmppSession.query(new IQ(this.pubSubServiceAddress, AbstractIQ.Type.GET, (Object)PubSub.withSubscriptions((String)this.nodeId)));
        PubSub pubSub = (PubSub)result.getExtension(PubSub.class);
        return pubSub.getSubscriptions();
    }

    public List<Affiliation> getAffiliations() throws XmppException {
        IQ result = this.xmppSession.query(new IQ(this.pubSubServiceAddress, AbstractIQ.Type.GET, (Object)PubSub.withAffiliations((String)this.nodeId)));
        PubSub pubSub = (PubSub)result.getExtension(PubSub.class);
        return pubSub.getAffiliations();
    }

    public Subscription subscribe() throws XmppException {
        return this.subscribe(null);
    }

    public Subscription subscribe(DataForm dataForm) throws XmppException {
        if (this.nodeId == null) {
            throw new IllegalArgumentException("nodeId must not be null");
        }
        IQ result = this.xmppSession.query(new IQ(this.pubSubServiceAddress, AbstractIQ.Type.SET, (Object)PubSub.withSubscribe((String)this.nodeId, (Jid)this.xmppSession.getConnectedResource().asBareJid(), (DataForm)dataForm)));
        PubSub pubSub = (PubSub)result.getExtension(PubSub.class);
        return pubSub.getSubscription();
    }

    public void unsubscribe() throws XmppException {
        this.unsubscribe(null);
    }

    public void unsubscribe(String subscriptionId) throws XmppException {
        this.xmppSession.query(new IQ(this.pubSubServiceAddress, AbstractIQ.Type.SET, (Object)PubSub.withUnsubscribe((String)this.nodeId, (Jid)this.xmppSession.getConnectedResource().asBareJid(), (String)subscriptionId)));
    }

    public DataForm getSubscriptionOptions() throws XmppException {
        IQ result = this.xmppSession.query(new IQ(this.pubSubServiceAddress, AbstractIQ.Type.GET, (Object)PubSub.withOptions((String)this.nodeId, (Jid)this.xmppSession.getConnectedResource().asBareJid())));
        PubSub pubSub = (PubSub)result.getExtension(PubSub.class);
        return pubSub.getOptions().getDataForm();
    }

    public void submitSubscriptionOptions(DataForm dataForm) throws XmppException {
        this.xmppSession.query(new IQ(this.pubSubServiceAddress, AbstractIQ.Type.SET, (Object)PubSub.withOptions((String)this.nodeId, (Jid)this.xmppSession.getConnectedResource().asBareJid())));
    }

    public DataForm getDefaultSubscriptionOptions() throws XmppException {
        IQ result = this.xmppSession.query(new IQ(this.pubSubServiceAddress, AbstractIQ.Type.GET, (Object)PubSub.withDefault((String)this.nodeId)));
        PubSub pubSub = (PubSub)result.getExtension(PubSub.class);
        return pubSub.getDefault().getDataForm();
    }

    public List<Item> getItems() throws XmppException {
        IQ result = this.xmppSession.query(new IQ(this.pubSubServiceAddress, AbstractIQ.Type.GET, (Object)PubSub.withItems((String)this.nodeId)));
        PubSub pubSub = (PubSub)result.getExtension(PubSub.class);
        return pubSub.getItems();
    }

    public List<Item> getItems(String ... ids) throws XmppException {
        IQ result = this.xmppSession.query(new IQ(this.pubSubServiceAddress, AbstractIQ.Type.GET, (Object)PubSub.withItems((String)this.nodeId, (String[])ids)));
        PubSub pubSub = (PubSub)result.getExtension(PubSub.class);
        return pubSub.getItems();
    }

    public List<Item> getItems(int maxItems) throws XmppException {
        IQ result = this.xmppSession.query(new IQ(this.pubSubServiceAddress, AbstractIQ.Type.GET, (Object)PubSub.withItems((String)this.nodeId, (int)maxItems)));
        PubSub pubSub = (PubSub)result.getExtension(PubSub.class);
        return pubSub.getItems();
    }

    public String publish(Object item) throws XmppException {
        return this.publish(null, item);
    }

    public String publish(String id, Object item) throws XmppException {
        IQ result = this.xmppSession.query(new IQ(this.pubSubServiceAddress, AbstractIQ.Type.SET, (Object)PubSub.withPublish((String)this.nodeId, (String)id, (Object)item)));
        PubSub pubSub = (PubSub)result.getExtension(PubSub.class);
        if (pubSub != null && pubSub.getPublish() != null && pubSub.getPublish().getItem() != null) {
            return pubSub.getPublish().getItem().getId();
        }
        return id;
    }

    private void deleteItem(String id, boolean notify) throws XmppException {
        this.xmppSession.query(new IQ(this.pubSubServiceAddress, AbstractIQ.Type.SET, (Object)PubSub.withRetract((String)this.nodeId, (String)id, (boolean)notify)));
    }

    public String create() throws XmppException {
        return this.create(null);
    }

    public String create(DataForm dataForm) throws XmppException {
        String generatedNodeId;
        IQ result = this.xmppSession.query(new IQ(this.pubSubServiceAddress, AbstractIQ.Type.SET, (Object)PubSub.withCreate((String)this.nodeId, (DataForm)dataForm)));
        if (this.nodeId != null) {
            return this.nodeId;
        }
        PubSub pubSub = (PubSub)result.getExtension(PubSub.class);
        if (pubSub != null && (generatedNodeId = pubSub.getNode()) != null) {
            this.nodeId = generatedNodeId;
        }
        return this.nodeId;
    }

    public DataForm getNodeConfiguration() throws XmppException {
        IQ result = this.xmppSession.query(new IQ(this.pubSubServiceAddress, AbstractIQ.Type.GET, (Object)PubSubOwner.withConfigure((String)this.nodeId)));
        PubSubOwner pubSubOwner = (PubSubOwner)result.getExtension(PubSubOwner.class);
        return pubSubOwner.getConfigurationForm();
    }

    public void submitNodeConfiguration(DataForm dataForm) throws XmppException {
        this.xmppSession.query(new IQ(this.pubSubServiceAddress, AbstractIQ.Type.SET, (Object)PubSubOwner.withConfigure((String)this.nodeId, (DataForm)dataForm)));
    }

    public void delete() throws XmppException {
        this.xmppSession.query(new IQ(this.pubSubServiceAddress, AbstractIQ.Type.SET, (Object)PubSubOwner.withDelete((String)this.nodeId)));
    }

    public void delete(URI uri) throws XmppException {
        this.xmppSession.query(new IQ(this.pubSubServiceAddress, AbstractIQ.Type.SET, (Object)PubSubOwner.withDelete((String)this.nodeId, (URI)uri)));
    }

    public void purge() throws XmppException {
        this.xmppSession.query(new IQ(this.pubSubServiceAddress, AbstractIQ.Type.SET, (Object)PubSubOwner.withPurge((String)this.nodeId)));
    }

    public List<PubSubNode> getNodes() throws XmppException {
        ItemNode itemNode = this.serviceDiscoveryManager.discoverItems(this.pubSubServiceAddress, this.nodeId);
        ArrayList<PubSubNode> nodes = new ArrayList<PubSubNode>();
        for (rocks.xmpp.extensions.disco.model.items.Item item : itemNode.getItems()) {
            PubSubNode n = new PubSubNode(item.getNode(), item.getName(), this.pubSubServiceAddress, this.xmppSession);
            nodes.add(n);
        }
        return nodes;
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.nodeId;
    }

    public Type getType() {
        return this.type;
    }

    public String toString() {
        return this.nodeId;
    }

    public static enum Type {
        LEAF,
        COLLECTION;

    }
}

