/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.pubsub;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import rocks.xmpp.core.Jid;
import rocks.xmpp.core.XmppException;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.model.AbstractIQ;
import rocks.xmpp.core.stanza.model.client.IQ;
import rocks.xmpp.extensions.data.model.DataForm;
import rocks.xmpp.extensions.disco.ServiceDiscoveryManager;
import rocks.xmpp.extensions.disco.model.info.Feature;
import rocks.xmpp.extensions.disco.model.info.InfoNode;
import rocks.xmpp.extensions.disco.model.items.Item;
import rocks.xmpp.extensions.disco.model.items.ItemNode;
import rocks.xmpp.extensions.pubsub.PubSubNode;
import rocks.xmpp.extensions.pubsub.model.Affiliation;
import rocks.xmpp.extensions.pubsub.model.PubSub;
import rocks.xmpp.extensions.pubsub.model.PubSubFeature;
import rocks.xmpp.extensions.pubsub.model.Subscription;
import rocks.xmpp.extensions.pubsub.model.owner.PubSubOwner;

public final class PubSubService {
    private static final Logger logger = Logger.getLogger(PubSubService.class.getName());
    private final Jid service;
    private final ServiceDiscoveryManager serviceDiscoveryManager;
    private final XmppSession xmppSession;

    PubSubService(Jid service, XmppSession xmppSession, ServiceDiscoveryManager serviceDiscoveryManager) {
        this.service = service;
        this.serviceDiscoveryManager = serviceDiscoveryManager;
        this.xmppSession = xmppSession;
    }

    public Collection<PubSubFeature> getFeatures() throws XmppException {
        InfoNode infoNode = this.serviceDiscoveryManager.discoverInformation(this.service);
        return this.getFeatures(infoNode);
    }

    Collection<PubSubFeature> getFeatures(InfoNode infoNode) {
        EnumSet<PubSubFeature> features = EnumSet.noneOf(PubSubFeature.class);
        for (Feature feature : infoNode.getFeatures()) {
            if (!feature.getVar().startsWith("http://jabber.org/protocol/pubsub#")) continue;
            String f = feature.getVar().substring(feature.getVar().indexOf("#") + 1);
            try {
                PubSubFeature pubSubFeature = PubSubFeature.valueOf((String)f.toUpperCase().replace("-", "_"));
                if (pubSubFeature == null) continue;
                features.add(pubSubFeature);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Server advertised unknown pubsub feature: " + f);
            }
        }
        return features;
    }

    public List<PubSubNode> getNodes() throws XmppException {
        ItemNode itemNode = this.serviceDiscoveryManager.discoverItems(this.service);
        ArrayList<PubSubNode> nodes = new ArrayList<PubSubNode>();
        for (Item item : itemNode.getItems()) {
            PubSubNode n = new PubSubNode(item.getNode(), item.getName(), this.service, this.xmppSession);
            nodes.add(n);
        }
        return nodes;
    }

    public PubSubNode getNode(String node) {
        return new PubSubNode(node, null, this.service, this.xmppSession);
    }

    private List<Subscription> getSubscriptions() throws XmppException {
        IQ result = this.xmppSession.query(new IQ(this.service, AbstractIQ.Type.GET, (Object)PubSub.withSubscriptions()));
        PubSub pubSub = (PubSub)result.getExtension(PubSub.class);
        return pubSub.getSubscriptions();
    }

    private List<Affiliation> getAffiliations() throws XmppException {
        IQ result = this.xmppSession.query(new IQ(this.service, AbstractIQ.Type.GET, (Object)PubSub.withAffiliations()));
        PubSub pubSub = (PubSub)result.getExtension(PubSub.class);
        return pubSub.getAffiliations();
    }

    private DataForm getDefaultSubscriptionOptions() throws XmppException {
        IQ result = this.xmppSession.query(new IQ(this.service, AbstractIQ.Type.GET, (Object)PubSub.withDefault()));
        PubSub pubSub = (PubSub)result.getExtension(PubSub.class);
        return pubSub.getDefault().getDataForm();
    }

    private DataForm getDefaultNodeConfiguration() throws XmppException {
        IQ result = this.xmppSession.query(new IQ(this.service, AbstractIQ.Type.GET, (Object)PubSubOwner.withDefault()));
        PubSubOwner pubSubOwner = (PubSubOwner)result.getExtension(PubSubOwner.class);
        return pubSubOwner.getConfigurationForm();
    }

    public Jid getAddress() {
        return this.service;
    }

    public String toString() {
        return this.service.toString();
    }
}

