/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.avatar;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

final class DirectoryAvatarCache
implements Map<String, byte[]> {
    private final File cacheDirectory;

    public DirectoryAvatarCache(File cacheDirectory) {
        this.cacheDirectory = cacheDirectory;
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsKey(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] get(final Object key) {
        File dir = new File(this.cacheDirectory, ".");
        File[] files = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(key.toString());
            }
        });
        if (files == null) return null;
        if (files.length <= 0) return null;
        File file = files[0];
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            byte[] data = new byte[(int)file.length()];
            if (fileInputStream.read(data, 0, data.length) <= -1) return null;
            byte[] byArray = data;
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] put(String hash, byte[] imageData) {
        Throwable throwable;
        File file;
        boolean exists = this.cacheDirectory.exists();
        if (!exists) {
            exists = this.cacheDirectory.mkdir();
        }
        if ((file = new File(this.cacheDirectory, hash + ".avatar")).exists()) {
            try {
                throwable = null;
                try (FileInputStream fileInputStream = new FileInputStream(file);){
                    byte[] data = new byte[(int)file.length()];
                    if (fileInputStream.read(data, 0, data.length) > -1) {
                        byte[] byArray = data;
                        return byArray;
                    }
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (!exists) return null;
        try {
            throwable = null;
            try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                fileOutputStream.write(imageData);
                return null;
            }
            catch (Throwable throwable7) {
                throwable = throwable7;
                throw throwable7;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public byte[] remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends String, ? extends byte[]> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<String> keySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<byte[]> values() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Map.Entry<String, byte[]>> entrySet() {
        throw new UnsupportedOperationException();
    }
}

