/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.blocking;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import rocks.xmpp.core.Jid;
import rocks.xmpp.core.XmppException;
import rocks.xmpp.core.session.ExtensionManager;
import rocks.xmpp.core.session.SessionStatusEvent;
import rocks.xmpp.core.session.SessionStatusListener;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.IQEvent;
import rocks.xmpp.core.stanza.IQListener;
import rocks.xmpp.core.stanza.model.AbstractIQ;
import rocks.xmpp.core.stanza.model.client.IQ;
import rocks.xmpp.core.stream.model.ClientStreamElement;
import rocks.xmpp.extensions.blocking.BlockingEvent;
import rocks.xmpp.extensions.blocking.BlockingListener;
import rocks.xmpp.extensions.blocking.model.Block;
import rocks.xmpp.extensions.blocking.model.BlockList;
import rocks.xmpp.extensions.blocking.model.Unblock;

public final class BlockingManager
extends ExtensionManager {
    private static final Logger logger = Logger.getLogger(BlockingManager.class.getName());
    private final Set<Jid> blockedContacts = new HashSet<Jid>();
    private final Set<BlockingListener> blockingListeners = new CopyOnWriteArraySet<BlockingListener>();

    private BlockingManager(final XmppSession xmppSession) {
        super(xmppSession, new String[0]);
        xmppSession.addSessionStatusListener(new SessionStatusListener(){

            public void sessionStatusChanged(SessionStatusEvent e) {
                if (e.getStatus() == XmppSession.Status.CLOSED) {
                    BlockingManager.this.blockingListeners.clear();
                    BlockingManager.this.blockedContacts.clear();
                }
            }
        });
        xmppSession.addIQListener(new IQListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handle(IQEvent e) {
                IQ iq = e.getIQ();
                if (e.isIncoming() && !e.isConsumed() && iq.getType() == AbstractIQ.Type.SET && (iq.getFrom() == null || iq.getFrom().equals((Object)xmppSession.getConnectedResource().asBareJid()))) {
                    Block block = (Block)iq.getExtension(Block.class);
                    if (block != null) {
                        ArrayList<Jid> pushedContacts = new ArrayList<Jid>();
                        Set set = BlockingManager.this.blockedContacts;
                        synchronized (set) {
                            for (Jid item : block.getItems()) {
                                BlockingManager.this.blockedContacts.add(item);
                                pushedContacts.add(item);
                            }
                        }
                        xmppSession.send((ClientStreamElement)iq.createResult());
                        e.consume();
                        BlockingManager.this.notifyListeners(pushedContacts, Collections.emptyList());
                    } else {
                        Unblock unblock = (Unblock)iq.getExtension(Unblock.class);
                        if (unblock != null) {
                            ArrayList<Jid> pushedContacts = new ArrayList<Jid>();
                            Set set = BlockingManager.this.blockedContacts;
                            synchronized (set) {
                                if (unblock.getItems().isEmpty()) {
                                    pushedContacts.addAll(BlockingManager.this.blockedContacts);
                                    BlockingManager.this.blockedContacts.clear();
                                } else {
                                    for (Jid item : unblock.getItems()) {
                                        BlockingManager.this.blockedContacts.remove(item);
                                        pushedContacts.add(item);
                                    }
                                }
                            }
                            xmppSession.send((ClientStreamElement)iq.createResult());
                            e.consume();
                            BlockingManager.this.notifyListeners(Collections.emptyList(), pushedContacts);
                        }
                    }
                }
            }
        });
    }

    private void notifyListeners(List<Jid> blockedContacts, List<Jid> unblockedContacts) {
        for (BlockingListener blockingListener : this.blockingListeners) {
            try {
                blockingListener.blockListChanged(new BlockingEvent((Object)this, blockedContacts, unblockedContacts));
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, ex.getMessage(), ex);
            }
        }
    }

    public void addBlockingListener(BlockingListener blockingListener) {
        this.blockingListeners.add(blockingListener);
    }

    public void removeBlockingListener(BlockingListener blockingListener) {
        this.blockingListeners.remove(blockingListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Jid> getBlockedContacts() throws XmppException {
        Set<Jid> set = this.blockedContacts;
        synchronized (set) {
            IQ result = this.xmppSession.query(new IQ(AbstractIQ.Type.GET, (Object)new BlockList()));
            BlockList blockList = (BlockList)result.getExtension(BlockList.class);
            if (blockList != null) {
                for (Jid item : blockList.getItems()) {
                    this.blockedContacts.add(item);
                }
            }
            return this.blockedContacts;
        }
    }

    public void blockContact(Jid ... jids) throws XmppException {
        ArrayList items = new ArrayList();
        Collections.addAll(items, jids);
        this.xmppSession.query(new IQ(AbstractIQ.Type.SET, (Object)new Block(items)));
    }

    public void unblockContact(Jid ... jids) throws XmppException {
        ArrayList items = new ArrayList();
        Collections.addAll(items, jids);
        this.xmppSession.query(new IQ(AbstractIQ.Type.SET, (Object)new Unblock(items)));
    }
}

