/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.bookmarks;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import rocks.xmpp.core.Jid;
import rocks.xmpp.core.XmppException;
import rocks.xmpp.core.session.ExtensionManager;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.extensions.bookmarks.model.Bookmark;
import rocks.xmpp.extensions.bookmarks.model.BookmarkStorage;
import rocks.xmpp.extensions.bookmarks.model.ChatRoomBookmark;
import rocks.xmpp.extensions.bookmarks.model.WebPageBookmark;
import rocks.xmpp.extensions.privatedata.PrivateDataManager;

public final class BookmarkManager
extends ExtensionManager {
    private final PrivateDataManager privateDataManager;

    private BookmarkManager(XmppSession xmppSession) {
        super(xmppSession, new String[0]);
        this.privateDataManager = (PrivateDataManager)xmppSession.getExtensionManager(PrivateDataManager.class);
    }

    public Collection<ChatRoomBookmark> getChatRoomBookmarks() throws XmppException {
        return this.getBookmarks(ChatRoomBookmark.class);
    }

    public Collection<WebPageBookmark> getWebPageBookmarks() throws XmppException {
        return this.getBookmarks(WebPageBookmark.class);
    }

    public void addBookmark(Bookmark bookmark) throws XmppException {
        BookmarkStorage bookmarkStorage = this.privateDataManager.getData(BookmarkStorage.class);
        ArrayList<Bookmark> bookmarks = new ArrayList<Bookmark>(bookmarkStorage.getBookmarks());
        bookmarks.remove(bookmark);
        bookmarks.add(bookmark);
        this.privateDataManager.storeData(new BookmarkStorage(bookmarks));
    }

    public void removeChatRoomBookmark(Jid chatRoom) throws XmppException {
        BookmarkStorage bookmarkStorage = this.privateDataManager.getData(BookmarkStorage.class);
        ArrayList bookmarks = new ArrayList(bookmarkStorage.getBookmarks());
        bookmarks.remove(new ChatRoomBookmark("", chatRoom));
        this.privateDataManager.storeData(new BookmarkStorage(bookmarks));
    }

    public void removeWebPageBookmark(URL webPage) throws XmppException {
        BookmarkStorage bookmarkStorage = this.privateDataManager.getData(BookmarkStorage.class);
        ArrayList bookmarks = new ArrayList(bookmarkStorage.getBookmarks());
        bookmarks.remove(new WebPageBookmark("", webPage));
        this.privateDataManager.storeData(new BookmarkStorage(bookmarks));
    }

    private <T extends Bookmark> Collection<T> getBookmarks(Class<T> clazz) throws XmppException {
        ArrayList<Bookmark> bookmarks = new ArrayList<Bookmark>();
        BookmarkStorage bookmarkStorage = this.privateDataManager.getData(BookmarkStorage.class);
        for (Bookmark bookmark : bookmarkStorage.getBookmarks()) {
            if (bookmark.getClass() != clazz) continue;
            bookmarks.add(bookmark);
        }
        Collections.sort(bookmarks);
        return bookmarks;
    }
}

