/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.bytestreams.ibb;

import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import rocks.xmpp.extensions.bytestreams.ibb.IbbSession;
import rocks.xmpp.extensions.bytestreams.ibb.model.InBandByteStream;

final class IbbInputStream
extends InputStream {
    final BlockingQueue<InBandByteStream.Data> queue = new LinkedBlockingQueue<InBandByteStream.Data>();
    private final IbbSession ibbSession;
    int readTimeout;
    private byte[] buffer;
    private int n = 0;
    private volatile boolean closed;

    IbbInputStream(IbbSession ibbSession) {
        this.ibbSession = ibbSession;
    }

    @Override
    public synchronized int read() throws IOException {
        if (this.n == 0) {
            try {
                if (this.closed) {
                    return -1;
                }
                InBandByteStream.Data data = null;
                if (this.readTimeout <= 0) {
                    while (data == null) {
                        if (this.closed && this.queue.isEmpty()) {
                            return -1;
                        }
                        data = this.queue.poll(1L, TimeUnit.SECONDS);
                    }
                } else {
                    data = this.queue.poll(this.readTimeout, TimeUnit.MILLISECONDS);
                    if (data == null) {
                        if (this.closed) {
                            return -1;
                        }
                        throw new SocketTimeoutException();
                    }
                }
                this.buffer = data.getBytes();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        int b = this.buffer[this.n++] & 0xFF;
        if (this.n >= this.buffer.length) {
            this.n = 0;
        }
        return b;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            super.close();
            this.closed = true;
            this.ibbSession.close();
        }
    }
}

