/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.bytestreams.ibb;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import rocks.xmpp.core.Jid;
import rocks.xmpp.core.XmppException;
import rocks.xmpp.core.session.SessionStatusEvent;
import rocks.xmpp.core.session.SessionStatusListener;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.IQEvent;
import rocks.xmpp.core.stanza.IQListener;
import rocks.xmpp.core.stanza.MessageEvent;
import rocks.xmpp.core.stanza.MessageListener;
import rocks.xmpp.core.stanza.model.AbstractIQ;
import rocks.xmpp.core.stanza.model.StanzaError;
import rocks.xmpp.core.stanza.model.client.IQ;
import rocks.xmpp.core.stanza.model.errors.Condition;
import rocks.xmpp.core.stanza.model.errors.ItemNotFound;
import rocks.xmpp.core.stanza.model.errors.ResourceConstraint;
import rocks.xmpp.core.stanza.model.errors.UnexpectedRequest;
import rocks.xmpp.core.stream.model.ClientStreamElement;
import rocks.xmpp.extensions.bytestreams.ByteStreamManager;
import rocks.xmpp.extensions.bytestreams.ByteStreamSession;
import rocks.xmpp.extensions.bytestreams.ibb.IbbEvent;
import rocks.xmpp.extensions.bytestreams.ibb.IbbSession;
import rocks.xmpp.extensions.bytestreams.ibb.model.InBandByteStream;

public final class InBandByteStreamManager
extends ByteStreamManager {
    private static final Logger logger = Logger.getLogger(InBandByteStreamManager.class.getName());
    final Map<String, IbbSession> ibbSessionMap = new ConcurrentHashMap<String, IbbSession>();

    private InBandByteStreamManager(final XmppSession xmppSession) {
        super(xmppSession, "http://jabber.org/protocol/ibb");
        xmppSession.addSessionStatusListener(new SessionStatusListener(){

            public void sessionStatusChanged(SessionStatusEvent e) {
                if (e.getStatus() == XmppSession.Status.CLOSED) {
                    InBandByteStreamManager.this.ibbSessionMap.clear();
                }
            }
        });
        xmppSession.addIQListener(new IQListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handle(IQEvent e) {
                IQ iq = e.getIQ();
                if (e.isIncoming() && InBandByteStreamManager.this.isEnabled() && !e.isConsumed() && iq.getType() == AbstractIQ.Type.SET) {
                    InBandByteStream.Data data = (InBandByteStream.Data)iq.getExtension(InBandByteStream.Data.class);
                    if (data != null) {
                        IbbSession ibbSession = InBandByteStreamManager.this.getIbbSession(iq, data.getSessionId());
                        if (ibbSession != null) {
                            if (ibbSession.dataReceived(data)) {
                                xmppSession.send((ClientStreamElement)iq.createResult());
                            } else {
                                xmppSession.send((ClientStreamElement)iq.createError(new StanzaError(StanzaError.Type.CANCEL, (Condition)new UnexpectedRequest())));
                            }
                        }
                        e.consume();
                    } else {
                        InBandByteStream.Open open = (InBandByteStream.Open)iq.getExtension(InBandByteStream.Open.class);
                        if (open != null) {
                            if (open.getBlockSize() > 65535) {
                                xmppSession.send((ClientStreamElement)iq.createError(new StanzaError(StanzaError.Type.MODIFY, (Condition)new ResourceConstraint())));
                            } else {
                                InBandByteStreamManager.this.notifyByteStreamEvent(new IbbEvent((Object)InBandByteStreamManager.this, open.getSessionId(), xmppSession, iq, open.getBlockSize()));
                            }
                            e.consume();
                        } else {
                            InBandByteStream.Close close = (InBandByteStream.Close)iq.getExtension(InBandByteStream.Close.class);
                            if (close != null) {
                                IbbSession ibbSession = InBandByteStreamManager.this.getIbbSession(iq, close.getSessionId());
                                if (ibbSession != null) {
                                    try {
                                        InBandByteStreamManager.this.ibbSessionMap.remove(close.getSessionId());
                                        ibbSession.closedByPeer();
                                    }
                                    catch (IOException e1) {
                                        logger.log(Level.WARNING, e1.getMessage(), e1);
                                    }
                                    finally {
                                        xmppSession.send((ClientStreamElement)iq.createResult());
                                    }
                                }
                                e.consume();
                            }
                        }
                    }
                }
            }
        });
        xmppSession.addMessageListener(new MessageListener(){

            public void handle(MessageEvent e) {
                InBandByteStream.Data data;
                if (e.isIncoming() && InBandByteStreamManager.this.isEnabled() && (data = (InBandByteStream.Data)e.getMessage().getExtension(InBandByteStream.Data.class)) != null) {
                    IbbSession ibbSession = InBandByteStreamManager.this.ibbSessionMap.get(data.getSessionId());
                    if (ibbSession != null) {
                        if (!ibbSession.dataReceived(data)) {
                            xmppSession.send((ClientStreamElement)e.getMessage().createError(new StanzaError(StanzaError.Type.CANCEL, (Condition)new UnexpectedRequest())));
                        }
                    } else {
                        xmppSession.send((ClientStreamElement)e.getMessage().createError(new StanzaError((Condition)new ItemNotFound())));
                    }
                }
            }
        });
        this.setEnabled(true);
    }

    private IbbSession getIbbSession(IQ iq, String sessionId) {
        IbbSession ibbSession = this.ibbSessionMap.get(sessionId);
        if (ibbSession == null) {
            this.xmppSession.send((ClientStreamElement)iq.createError(new StanzaError((Condition)new ItemNotFound())));
        }
        return ibbSession;
    }

    IbbSession createSession(Jid receiver, String sessionId, int blockSize) {
        IbbSession ibbSession = new IbbSession(sessionId, this.xmppSession, receiver, blockSize, this);
        this.ibbSessionMap.put(ibbSession.getSessionId(), ibbSession);
        return ibbSession;
    }

    public ByteStreamSession initiateSession(Jid receiver, String sessionId, int blockSize) throws XmppException {
        if (blockSize > 65535) {
            throw new IllegalArgumentException("blockSize must not be greater than 65535.");
        }
        IbbSession ibbSession = this.createSession(receiver, sessionId, blockSize);
        ibbSession.open();
        return ibbSession;
    }
}

