/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.caps;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import rocks.xmpp.core.Jid;
import rocks.xmpp.core.XmppException;
import rocks.xmpp.core.session.ExtensionManager;
import rocks.xmpp.core.session.SessionStatusEvent;
import rocks.xmpp.core.session.SessionStatusListener;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.PresenceEvent;
import rocks.xmpp.core.stanza.PresenceListener;
import rocks.xmpp.core.stanza.model.client.Presence;
import rocks.xmpp.core.stream.model.ClientStreamElement;
import rocks.xmpp.core.subscription.PresenceManager;
import rocks.xmpp.extensions.caps.model.EntityCapabilities;
import rocks.xmpp.extensions.data.model.DataForm;
import rocks.xmpp.extensions.disco.ServiceDiscoveryManager;
import rocks.xmpp.extensions.disco.model.info.Feature;
import rocks.xmpp.extensions.disco.model.info.Identity;
import rocks.xmpp.extensions.disco.model.info.InfoDiscovery;
import rocks.xmpp.extensions.disco.model.info.InfoNode;

public final class EntityCapabilitiesManager
extends ExtensionManager {
    private static final Logger logger = Logger.getLogger(EntityCapabilitiesManager.class.getName());
    private static final String DEFAULT_NODE = "http://babbler-xmpp.blogspot.de/";
    private static final String HASH_ALGORITHM = "sha-1";
    private final ServiceDiscoveryManager serviceDiscoveryManager;
    private final Map<Verification, InfoNode> cache = new ConcurrentHashMap<Verification, InfoNode>();
    private final Map<Jid, InfoNode> jidInfos = new ConcurrentHashMap<Jid, InfoNode>();
    private boolean capsSent;
    private String currentVerificationString;
    private String node;

    private EntityCapabilitiesManager(final XmppSession xmppSession) {
        super(xmppSession, new String[]{"http://jabber.org/protocol/caps"});
        this.serviceDiscoveryManager = (ServiceDiscoveryManager)xmppSession.getExtensionManager(ServiceDiscoveryManager.class);
        this.serviceDiscoveryManager.addPropertyChangeListener(new PropertyChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void propertyChange(PropertyChangeEvent e) {
                ServiceDiscoveryManager serviceDiscoveryManager = EntityCapabilitiesManager.this.serviceDiscoveryManager;
                synchronized (serviceDiscoveryManager) {
                    if (EntityCapabilitiesManager.this.capsSent) {
                        try {
                            EntityCapabilitiesManager.this.recomputeVerificationString(EntityCapabilitiesManager.HASH_ALGORITHM);
                        }
                        catch (NoSuchAlgorithmException e1) {
                            logger.log(Level.WARNING, e1.getMessage(), e1);
                        }
                        EntityCapabilitiesManager.this.publishCapsNode();
                        PresenceManager presenceManager = xmppSession.getPresenceManager();
                        Presence lastPresence = presenceManager.getLastSentPresence();
                        Presence presence = new Presence();
                        presence.setError(lastPresence.getError());
                        presence.setFrom(lastPresence.getFrom());
                        presence.setPriority(lastPresence.getPriority());
                        presence.setLanguage(lastPresence.getLanguage());
                        presence.setShow(lastPresence.getShow());
                        presence.setStatus(lastPresence.getStatus());
                        presence.setTo(lastPresence.getTo());
                        xmppSession.send((ClientStreamElement)presence);
                    }
                }
            }
        });
        xmppSession.addSessionStatusListener(new SessionStatusListener(){

            public void sessionStatusChanged(SessionStatusEvent e) {
                if (e.getStatus() == XmppSession.Status.CLOSED) {
                    EntityCapabilitiesManager.this.jidInfos.clear();
                    EntityCapabilitiesManager.this.cache.clear();
                    EntityCapabilitiesManager.this.capsSent = false;
                    EntityCapabilitiesManager.this.currentVerificationString = null;
                }
            }
        });
        xmppSession.addPresenceListener(new PresenceListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handle(PresenceEvent e) {
                Presence presence = e.getPresence();
                if (!e.isIncoming()) {
                    if (EntityCapabilitiesManager.this.isEnabled() && presence.isAvailable() && presence.getTo() == null) {
                        try {
                            ServiceDiscoveryManager serviceDiscoveryManager = EntityCapabilitiesManager.this.serviceDiscoveryManager;
                            synchronized (serviceDiscoveryManager) {
                                if (EntityCapabilitiesManager.this.currentVerificationString == null) {
                                    EntityCapabilitiesManager.this.recomputeVerificationString(EntityCapabilitiesManager.HASH_ALGORITHM);
                                    EntityCapabilitiesManager.this.publishCapsNode();
                                }
                                presence.getExtensions().add(new EntityCapabilities(EntityCapabilitiesManager.this.getNode(), EntityCapabilitiesManager.HASH_ALGORITHM, EntityCapabilitiesManager.this.currentVerificationString));
                                EntityCapabilitiesManager.this.capsSent = true;
                            }
                        }
                        catch (NoSuchAlgorithmException e1) {
                            logger.log(Level.WARNING, e1.getMessage(), e1);
                        }
                    }
                } else {
                    EntityCapabilities entityCapabilities = (EntityCapabilities)presence.getExtension(EntityCapabilities.class);
                    if (entityCapabilities != null) {
                        EntityCapabilitiesManager entityCapabilitiesManager = EntityCapabilitiesManager.this;
                        synchronized (entityCapabilitiesManager) {
                            Verification verification = new Verification(entityCapabilities.getHashingAlgorithm(), entityCapabilities.getVerificationString());
                            if (entityCapabilities.getHashingAlgorithm() != null && EntityCapabilitiesManager.this.cache.containsKey(verification)) {
                                InfoNode infoNode = (InfoNode)EntityCapabilitiesManager.this.cache.get(verification);
                                EntityCapabilitiesManager.this.jidInfos.put(presence.getFrom(), infoNode);
                            } else {
                                String hashAlgorithm = entityCapabilities.getHashingAlgorithm();
                                if (hashAlgorithm != null) {
                                    try {
                                        MessageDigest messageDigest = MessageDigest.getInstance(entityCapabilities.getHashingAlgorithm());
                                        try {
                                            InfoNode infoDiscovery = EntityCapabilitiesManager.this.serviceDiscoveryManager.discoverInformation(presence.getFrom(), entityCapabilities.getNode() + "#" + entityCapabilities.getVerificationString());
                                            ArrayList<String> ftValues = new ArrayList<String>();
                                            for (DataForm dataForm : infoDiscovery.getExtensions()) {
                                                DataForm.Field formType = dataForm.findField("FORM_TYPE");
                                                if (formType == null || formType.getType() != DataForm.Field.Type.HIDDEN || formType.getValues().isEmpty()) continue;
                                                ArrayList<String> values = new ArrayList<String>();
                                                for (String value : formType.getValues()) {
                                                    if (values.contains(value)) {
                                                        return;
                                                    }
                                                    values.add(value);
                                                }
                                                String value = (String)formType.getValues().get(0);
                                                if (ftValues.contains(value)) {
                                                    return;
                                                }
                                                ftValues.add(value);
                                            }
                                            String verificationString = EntityCapabilities.getVerificationString((InfoNode)infoDiscovery, (MessageDigest)messageDigest);
                                            if (verificationString.equals(entityCapabilities.getVerificationString())) {
                                                EntityCapabilitiesManager.this.cache(new Verification(hashAlgorithm, verificationString), infoDiscovery);
                                            }
                                            EntityCapabilitiesManager.this.jidInfos.put(presence.getFrom(), infoDiscovery);
                                        }
                                        catch (XmppException e1) {
                                            logger.log(Level.WARNING, e1.getMessage(), e1);
                                        }
                                    }
                                    catch (NoSuchAlgorithmException e1) {
                                        try {
                                            InfoNode infoNode = EntityCapabilitiesManager.this.serviceDiscoveryManager.discoverInformation(presence.getFrom(), entityCapabilities.getNode());
                                            EntityCapabilitiesManager.this.jidInfos.put(presence.getFrom(), infoNode);
                                        }
                                        catch (XmppException e2) {
                                            logger.log(Level.WARNING, e2.getMessage(), e2);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        });
        this.setEnabled(true);
    }

    private void publishCapsNode() {
        final HashSet identities = new HashSet(this.serviceDiscoveryManager.getIdentities());
        final HashSet features = new HashSet(this.serviceDiscoveryManager.getFeatures());
        final ArrayList extensions = new ArrayList(this.serviceDiscoveryManager.getExtensions());
        final String node = this.getNode() + "#" + this.currentVerificationString;
        this.serviceDiscoveryManager.addInfoNode(new InfoNode(){

            public String getNode() {
                return node;
            }

            public Set<Identity> getIdentities() {
                return identities;
            }

            public Set<Feature> getFeatures() {
                return features;
            }

            public List<DataForm> getExtensions() {
                return extensions;
            }
        });
    }

    private void recomputeVerificationString(String hashAlgorithm) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance(hashAlgorithm);
        InfoDiscovery infoDiscovery = new InfoDiscovery();
        infoDiscovery.getFeatures().addAll(this.serviceDiscoveryManager.getFeatures());
        infoDiscovery.getIdentities().addAll(this.serviceDiscoveryManager.getIdentities());
        infoDiscovery.getExtensions().addAll(this.serviceDiscoveryManager.getExtensions());
        this.currentVerificationString = EntityCapabilities.getVerificationString((InfoNode)infoDiscovery, (MessageDigest)messageDigest);
        this.cache(new Verification(HASH_ALGORITHM, this.currentVerificationString), (InfoNode)infoDiscovery);
    }

    public String getNode() {
        return this.node != null ? this.node : DEFAULT_NODE;
    }

    public void setNode(String node) {
        this.node = node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InfoNode getCapabilities(Jid jid) throws XmppException {
        InfoNode infoNode = this.jidInfos.get(jid);
        if (infoNode == null) {
            Map<Jid, InfoNode> map = this.jidInfos;
            synchronized (map) {
                infoNode = this.serviceDiscoveryManager.discoverInformation(jid);
                this.jidInfos.put(jid, infoNode);
            }
        }
        return infoNode;
    }

    public boolean isSupported(String feature, Jid jid) throws XmppException {
        InfoNode infoNode = this.getCapabilities(jid);
        return infoNode.getFeatures().contains(new Feature(feature));
    }

    private void cache(Verification verification, InfoNode infoNode) {
        this.cache.put(verification, infoNode);
    }

    private static final class Verification {
        private final String hashAlgorithm;
        private final String verificationString;

        private Verification(String hashAlgorithm, String verificationString) {
            this.hashAlgorithm = hashAlgorithm;
            this.verificationString = verificationString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Verification)) {
                return false;
            }
            Verification other = (Verification)o;
            return (this.hashAlgorithm == null ? other.hashAlgorithm == null : this.hashAlgorithm.equals(other.hashAlgorithm)) && (this.verificationString == null ? other.verificationString == null : this.verificationString.equals(other.verificationString));
        }

        public int hashCode() {
            int result = 17;
            result = 31 * result + (this.hashAlgorithm == null ? 0 : this.hashAlgorithm.hashCode());
            result = 31 * result + (this.verificationString == null ? 0 : this.verificationString.hashCode());
            return result;
        }

        public String toString() {
            return this.hashAlgorithm + "_" + this.verificationString;
        }
    }
}

