/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.filetransfer;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.util.Date;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import rocks.xmpp.core.Jid;
import rocks.xmpp.core.XmppException;
import rocks.xmpp.core.session.ExtensionManager;
import rocks.xmpp.core.session.SessionStatusEvent;
import rocks.xmpp.core.session.SessionStatusListener;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.model.AbstractIQ;
import rocks.xmpp.core.stanza.model.StanzaException;
import rocks.xmpp.core.stanza.model.client.IQ;
import rocks.xmpp.core.stanza.model.errors.Forbidden;
import rocks.xmpp.core.stanza.model.errors.NotAcceptable;
import rocks.xmpp.extensions.caps.EntityCapabilitiesManager;
import rocks.xmpp.extensions.filetransfer.FileTransfer;
import rocks.xmpp.extensions.filetransfer.FileTransferNegotiator;
import rocks.xmpp.extensions.filetransfer.FileTransferOffer;
import rocks.xmpp.extensions.filetransfer.FileTransferOfferEvent;
import rocks.xmpp.extensions.filetransfer.FileTransferOfferListener;
import rocks.xmpp.extensions.filetransfer.FileTransferRejectedException;
import rocks.xmpp.extensions.oob.model.iq.OobIQ;
import rocks.xmpp.extensions.si.StreamInitiationManager;
import rocks.xmpp.extensions.si.profile.filetransfer.model.SIFileTransferOffer;

public final class FileTransferManager
extends ExtensionManager {
    private static final Logger logger = Logger.getLogger(FileTransferManager.class.getName());
    private final StreamInitiationManager streamInitiationManager;
    private final EntityCapabilitiesManager entityCapabilitiesManager;
    private final Set<FileTransferOfferListener> fileTransferOfferListeners = new CopyOnWriteArraySet<FileTransferOfferListener>();
    private final ExecutorService fileTransferOfferExecutor = Executors.newCachedThreadPool(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r, "File Transfer Offer Thread");
            thread.setDaemon(true);
            return thread;
        }
    });

    private FileTransferManager(XmppSession xmppSession) {
        super(xmppSession, new String[0]);
        xmppSession.addSessionStatusListener(new SessionStatusListener(){

            public void sessionStatusChanged(SessionStatusEvent e) {
                if (e.getStatus() == XmppSession.Status.CLOSED) {
                    FileTransferManager.this.fileTransferOfferListeners.clear();
                    FileTransferManager.this.fileTransferOfferExecutor.shutdown();
                }
            }
        });
        this.streamInitiationManager = (StreamInitiationManager)xmppSession.getExtensionManager(StreamInitiationManager.class);
        this.entityCapabilitiesManager = (EntityCapabilitiesManager)xmppSession.getExtensionManager(EntityCapabilitiesManager.class);
    }

    public void offerFile(URL url, String description, Jid recipient, long timeout) throws XmppException {
        try {
            this.xmppSession.query(new IQ(recipient, AbstractIQ.Type.SET, (Object)new OobIQ(url, description)), timeout);
        }
        catch (StanzaException e) {
            if (e.getStanza().getError().getCondition() instanceof NotAcceptable) {
                throw new FileTransferRejectedException();
            }
            throw e;
        }
    }

    public FileTransfer offerFile(File file, String description, Jid recipient, long timeout) throws XmppException, IOException {
        if (file == null) {
            throw new IllegalArgumentException("file must not be null.");
        }
        if (recipient == null) {
            throw new IllegalArgumentException("jid must not be null.");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException(new NoSuchFileException(file.getName()));
        }
        if (this.entityCapabilitiesManager.isSupported("http://jabber.org/protocol/si", recipient) && this.entityCapabilitiesManager.isSupported("http://jabber.org/protocol/si/profile/file-transfer", recipient)) {
            String mimeType;
            SIFileTransferOffer fileTransfer = new SIFileTransferOffer(file.getName(), file.length(), new Date(file.lastModified()), null, description, null);
            try {
                mimeType = Files.probeContentType(file.toPath());
            }
            catch (IOException e) {
                mimeType = null;
            }
            try {
                OutputStream outputStream = this.streamInitiationManager.initiateStream(recipient, fileTransfer, mimeType, timeout);
                FileInputStream inputStream = new FileInputStream(file);
                return new FileTransfer(inputStream, outputStream, file.length());
            }
            catch (StanzaException e) {
                if (e.getStanza().getError().getCondition() instanceof Forbidden) {
                    throw new FileTransferRejectedException();
                }
                throw e;
            }
        }
        throw new UnsupportedOperationException("Feature not supported");
    }

    public void fileTransferOffered(final IQ iq, final String sessionId, final String mimeType, final FileTransferOffer fileTransferOffer, final Object protocol, final FileTransferNegotiator fileTransferNegotiator) {
        this.fileTransferOfferExecutor.execute(new Runnable(){

            @Override
            public void run() {
                FileTransferOfferEvent fileTransferRequestEvent = new FileTransferOfferEvent(this, iq, sessionId, mimeType, fileTransferOffer, protocol, fileTransferNegotiator);
                for (FileTransferOfferListener fileTransferOfferListener : FileTransferManager.this.fileTransferOfferListeners) {
                    try {
                        fileTransferOfferListener.fileTransferOffered(fileTransferRequestEvent);
                    }
                    catch (Exception e) {
                        logger.log(Level.WARNING, e.getMessage(), e);
                    }
                }
            }
        });
    }

    public void addFileTransferOfferListener(FileTransferOfferListener fileTransferOfferListener) {
        this.fileTransferOfferListeners.add(fileTransferOfferListener);
    }

    public void removeFileTransferOfferListener(FileTransferOfferListener fileTransferOfferListener) {
        this.fileTransferOfferListeners.remove(fileTransferOfferListener);
    }
}

