/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.geoloc;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import rocks.xmpp.core.XmppException;
import rocks.xmpp.core.session.ExtensionManager;
import rocks.xmpp.core.session.SessionStatusEvent;
import rocks.xmpp.core.session.SessionStatusListener;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.MessageEvent;
import rocks.xmpp.core.stanza.MessageListener;
import rocks.xmpp.core.stanza.model.client.Message;
import rocks.xmpp.extensions.geoloc.GeoLocationEvent;
import rocks.xmpp.extensions.geoloc.GeoLocationListener;
import rocks.xmpp.extensions.geoloc.model.GeoLocation;
import rocks.xmpp.extensions.pubsub.PubSubManager;
import rocks.xmpp.extensions.pubsub.PubSubService;
import rocks.xmpp.extensions.pubsub.model.Item;
import rocks.xmpp.extensions.pubsub.model.event.Event;

public final class GeoLocationManager
extends ExtensionManager {
    private static final Logger logger = Logger.getLogger(GeoLocationManager.class.getName());
    private final Set<GeoLocationListener> geoLocationListeners = new CopyOnWriteArraySet<GeoLocationListener>();

    private GeoLocationManager(XmppSession xmppSession) {
        super(xmppSession, new String[]{"http://jabber.org/protocol/geoloc", "http://jabber.org/protocol/geoloc+notify"});
        xmppSession.addSessionStatusListener(new SessionStatusListener(){

            public void sessionStatusChanged(SessionStatusEvent e) {
                if (e.getStatus() == XmppSession.Status.CLOSED) {
                    GeoLocationManager.this.geoLocationListeners.clear();
                }
            }
        });
        xmppSession.addMessageListener(new MessageListener(){

            public void handle(MessageEvent e) {
                Message message;
                Event event;
                if (e.isIncoming() && GeoLocationManager.this.isEnabled() && (event = (Event)(message = e.getMessage()).getExtension(Event.class)) != null) {
                    for (Item item : event.getItems()) {
                        Object payload = item.getPayload();
                        if (!(payload instanceof GeoLocation)) continue;
                        for (GeoLocationListener geoLocationListener : GeoLocationManager.this.geoLocationListeners) {
                            try {
                                geoLocationListener.geoLocationUpdated(new GeoLocationEvent((Object)GeoLocationManager.this, (GeoLocation)payload, message.getFrom()));
                            }
                            catch (Exception ex) {
                                logger.log(Level.WARNING, ex.getMessage(), ex);
                            }
                        }
                    }
                }
            }
        });
    }

    public void publish(GeoLocation geoLocation) throws XmppException {
        PubSubService pepService = ((PubSubManager)this.xmppSession.getExtensionManager(PubSubManager.class)).createPersonalEventingService();
        pepService.getNode("http://jabber.org/protocol/geoloc").publish(geoLocation);
    }

    public void addGeoLocationListener(GeoLocationListener geoLocationListener) {
        this.geoLocationListeners.add(geoLocationListener);
    }

    public void removeGeoLocationListener(GeoLocationListener geoLocationListener) {
        this.geoLocationListeners.remove(geoLocationListener);
    }
}

