/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.httpauth;

import java.util.EventObject;
import rocks.xmpp.core.Jid;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.model.AbstractMessage;
import rocks.xmpp.core.stanza.model.Stanza;
import rocks.xmpp.core.stanza.model.StanzaError;
import rocks.xmpp.core.stanza.model.client.IQ;
import rocks.xmpp.core.stanza.model.client.Message;
import rocks.xmpp.core.stanza.model.errors.Condition;
import rocks.xmpp.core.stanza.model.errors.NotAuthorized;
import rocks.xmpp.core.stream.model.ClientStreamElement;
import rocks.xmpp.extensions.httpauth.model.ConfirmationRequest;

public final class HttpAuthenticationEvent
extends EventObject {
    private final ConfirmationRequest confirmationRequest;
    private final XmppSession xmppSession;
    private final Stanza stanza;

    HttpAuthenticationEvent(Object source, XmppSession xmppSession, Stanza stanza, ConfirmationRequest confirmationRequest) {
        super(source);
        this.confirmationRequest = confirmationRequest;
        this.xmppSession = xmppSession;
        this.stanza = stanza;
    }

    public Jid getRequester() {
        return this.stanza.getFrom();
    }

    public ConfirmationRequest getConfirmationRequest() {
        return this.confirmationRequest;
    }

    public void confirm() {
        if (this.stanza instanceof IQ) {
            this.xmppSession.send((ClientStreamElement)((IQ)this.stanza).createResult());
        } else if (this.stanza instanceof Message) {
            Message m = new Message(this.getRequester(), AbstractMessage.Type.NORMAL);
            m.setThread(((Message)this.stanza).getThread());
            m.getExtensions().add(this.confirmationRequest);
            this.xmppSession.send((ClientStreamElement)m);
        }
    }

    public void deny() {
        if (this.stanza instanceof IQ) {
            this.xmppSession.send((ClientStreamElement)((IQ)this.stanza).createError(new StanzaError((Condition)new NotAuthorized())));
        } else if (this.stanza instanceof Message) {
            Message m = new Message(this.getRequester(), AbstractMessage.Type.ERROR);
            m.setThread(((Message)this.stanza).getThread());
            m.getExtensions().add(this.confirmationRequest);
            m.setError(new StanzaError((Condition)new NotAuthorized()));
            this.xmppSession.send((ClientStreamElement)m);
        }
    }
}

