/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.jingle;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import rocks.xmpp.core.Jid;
import rocks.xmpp.core.XmppException;
import rocks.xmpp.core.session.ExtensionManager;
import rocks.xmpp.core.session.SessionStatusEvent;
import rocks.xmpp.core.session.SessionStatusListener;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.IQEvent;
import rocks.xmpp.core.stanza.IQListener;
import rocks.xmpp.core.stanza.model.AbstractIQ;
import rocks.xmpp.core.stanza.model.StanzaError;
import rocks.xmpp.core.stanza.model.client.IQ;
import rocks.xmpp.core.stanza.model.errors.BadRequest;
import rocks.xmpp.core.stanza.model.errors.Condition;
import rocks.xmpp.core.stanza.model.errors.ItemNotFound;
import rocks.xmpp.core.stream.model.ClientStreamElement;
import rocks.xmpp.extensions.jingle.JingleEvent;
import rocks.xmpp.extensions.jingle.JingleListener;
import rocks.xmpp.extensions.jingle.JingleSession;
import rocks.xmpp.extensions.jingle.apps.filetransfer.model.JingleFileTransfer;
import rocks.xmpp.extensions.jingle.apps.model.ApplicationFormat;
import rocks.xmpp.extensions.jingle.model.Jingle;
import rocks.xmpp.extensions.jingle.model.errors.UnknownSession;

public final class JingleManager
extends ExtensionManager {
    private static final Logger logger = Logger.getLogger(JingleManager.class.getName());
    private final Set<Class<? extends ApplicationFormat>> supportedApplicationFormats = new HashSet<Class<? extends ApplicationFormat>>();
    private final Set<JingleListener> jingleListeners = new CopyOnWriteArraySet<JingleListener>();
    private Map<String, JingleSession> jingleSessionMap = new ConcurrentHashMap<String, JingleSession>();

    private JingleManager(final XmppSession xmppSession) {
        super(xmppSession, new String[0]);
        this.supportedApplicationFormats.add(JingleFileTransfer.class);
        xmppSession.addSessionStatusListener(new SessionStatusListener(){

            public void sessionStatusChanged(SessionStatusEvent e) {
                if (e.getStatus() == XmppSession.Status.CLOSED) {
                    JingleManager.this.jingleListeners.clear();
                    JingleManager.this.jingleSessionMap.clear();
                }
            }
        });
        xmppSession.addIQListener(new IQListener(){

            public void handle(IQEvent e) {
                Jingle jingle;
                IQ iq = e.getIQ();
                if (e.isIncoming() && JingleManager.this.isEnabled() && !e.isConsumed() && iq.getType() == AbstractIQ.Type.SET && (jingle = (Jingle)iq.getExtension(Jingle.class)) != null) {
                    if (jingle.getAction() == null) {
                        xmppSession.send((ClientStreamElement)iq.createError(new StanzaError((Condition)new BadRequest(), "No valid action attribute set.")));
                    } else if (jingle.getSessionId() == null) {
                        xmppSession.send((ClientStreamElement)iq.createError(new StanzaError((Condition)new BadRequest(), "No session id set.")));
                    } else if (jingle.getAction() == Jingle.Action.SESSION_INITIATE) {
                        if (jingle.getContents().isEmpty()) {
                            xmppSession.send((ClientStreamElement)iq.createError(new StanzaError((Condition)new BadRequest(), "No contents found.")));
                        } else {
                            boolean hasContentWithDispositionSession = false;
                            boolean hasSupportedApplications = false;
                            boolean hasSupportedTransports = false;
                            for (Jingle.Content content : jingle.getContents()) {
                                if (!hasContentWithDispositionSession && ("session".equals(content.getDisposition()) || content.getDisposition() == null)) {
                                    hasContentWithDispositionSession = true;
                                }
                                if (!hasSupportedApplications && content.getApplicationFormat() != null) {
                                    hasSupportedApplications = true;
                                }
                                if (hasSupportedTransports || content.getTransportMethod() == null) continue;
                                hasSupportedTransports = true;
                            }
                            if (!hasContentWithDispositionSession) {
                                xmppSession.send((ClientStreamElement)iq.createError(new StanzaError((Condition)new BadRequest(), "No content with disposition 'session' found.")));
                            } else {
                                xmppSession.send((ClientStreamElement)iq.createResult());
                                if (!hasSupportedApplications) {
                                    xmppSession.send((ClientStreamElement)new IQ(iq.getFrom(), AbstractIQ.Type.SET, (Object)new Jingle(jingle.getSessionId(), Jingle.Action.SESSION_TERMINATE, new Jingle.Reason((Jingle.Reason.Condition)new Jingle.Reason.UnsupportedApplications()))));
                                } else if (!hasSupportedTransports) {
                                    xmppSession.send((ClientStreamElement)new IQ(iq.getFrom(), AbstractIQ.Type.SET, (Object)new Jingle(jingle.getSessionId(), Jingle.Action.SESSION_TERMINATE, new Jingle.Reason((Jingle.Reason.Condition)new Jingle.Reason.UnsupportedTransports()))));
                                } else {
                                    JingleSession jingleSession = new JingleSession(jingle.getSessionId(), iq.getFrom(), false, xmppSession, JingleManager.this, jingle.getContents());
                                    JingleManager.this.jingleSessionMap.put(jingle.getSessionId(), jingleSession);
                                    JingleManager.this.notifyJingleListeners(new JingleEvent((Object)JingleManager.this, xmppSession, iq, jingle));
                                }
                            }
                        }
                    } else {
                        JingleSession jingleSession = (JingleSession)JingleManager.this.jingleSessionMap.get(jingle.getSessionId());
                        if (jingleSession == null) {
                            StanzaError stanzaError = new StanzaError((Condition)new ItemNotFound());
                            stanzaError.setExtension((Object)new UnknownSession());
                            xmppSession.send((ClientStreamElement)iq.createError(stanzaError));
                        } else {
                            jingleSession.notifyJingleListeners(new JingleEvent((Object)JingleManager.this, xmppSession, iq, jingle));
                            xmppSession.send((ClientStreamElement)iq.createResult());
                        }
                    }
                    e.consume();
                }
            }
        });
    }

    public JingleSession createSession(Jid responder, Jingle.Content ... contents) throws XmppException {
        if (responder == null) {
            throw new IllegalArgumentException("responder must not be null.");
        }
        if (contents.length == 0) {
            throw new IllegalArgumentException("no content provided.");
        }
        String sessionId = UUID.randomUUID().toString();
        JingleSession jingleSession = new JingleSession(sessionId, responder, true, this.xmppSession, this, contents);
        this.jingleSessionMap.put(sessionId, jingleSession);
        return jingleSession;
    }

    void removeSession(String sessionId) {
        this.jingleSessionMap.remove(sessionId);
    }

    public final void addJingleListener(JingleListener jingleListener) {
        this.jingleListeners.add(jingleListener);
    }

    public final void removeJingleListener(JingleListener jingleListener) {
        this.jingleListeners.remove(jingleListener);
    }

    void notifyJingleListeners(JingleEvent jingleEvent) {
        for (JingleListener jingleListener : this.jingleListeners) {
            try {
                jingleListener.jingleReceived(jingleEvent);
            }
            catch (Exception exc) {
                logger.log(Level.WARNING, exc.getMessage(), exc);
            }
        }
    }
}

