/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.last;

import java.util.Date;
import rocks.xmpp.core.Jid;
import rocks.xmpp.core.XmppException;
import rocks.xmpp.core.session.ExtensionManager;
import rocks.xmpp.core.session.SessionStatusEvent;
import rocks.xmpp.core.session.SessionStatusListener;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.IQEvent;
import rocks.xmpp.core.stanza.IQListener;
import rocks.xmpp.core.stanza.MessageEvent;
import rocks.xmpp.core.stanza.MessageListener;
import rocks.xmpp.core.stanza.PresenceEvent;
import rocks.xmpp.core.stanza.PresenceListener;
import rocks.xmpp.core.stanza.model.AbstractIQ;
import rocks.xmpp.core.stanza.model.AbstractPresence;
import rocks.xmpp.core.stanza.model.client.IQ;
import rocks.xmpp.core.stanza.model.client.Presence;
import rocks.xmpp.core.stream.model.ClientStreamElement;
import rocks.xmpp.extensions.last.LastActivityStrategy;
import rocks.xmpp.extensions.last.model.LastActivity;

public final class LastActivityManager
extends ExtensionManager {
    private volatile LastActivityStrategy lastActivityStrategy;

    private LastActivityManager(final XmppSession xmppSession) {
        super(xmppSession, new String[]{"jabber:iq:last"});
        this.lastActivityStrategy = new DefaultLastActivityStrategy(xmppSession);
        xmppSession.addSessionStatusListener(new SessionStatusListener(){

            public void sessionStatusChanged(SessionStatusEvent e) {
                if (e.getStatus() == XmppSession.Status.CLOSED) {
                    LastActivityManager.this.lastActivityStrategy = null;
                }
            }
        });
        xmppSession.addPresenceListener(new PresenceListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handle(PresenceEvent e) {
                Presence presence;
                if (!e.isIncoming() && LastActivityManager.this.isEnabled() && (presence = e.getPresence()).getTo() == null) {
                    LastActivityManager lastActivityManager = LastActivityManager.this;
                    synchronized (lastActivityManager) {
                        if (LastActivityManager.this.lastActivityStrategy != null && LastActivityManager.this.lastActivityStrategy.getLastActivity() != null && presence.isAvailable() && (presence.getShow() == AbstractPresence.Show.AWAY || presence.getShow() == AbstractPresence.Show.XA) && presence.getExtension(LastActivity.class) == null) {
                            presence.getExtensions().add(new LastActivity(LastActivityManager.this.getSecondsSince(LastActivityManager.this.lastActivityStrategy.getLastActivity()), presence.getStatus()));
                        }
                    }
                }
            }
        });
        xmppSession.addIQListener(new IQListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handle(IQEvent e) {
                IQ iq = e.getIQ();
                if (e.isIncoming() && LastActivityManager.this.isEnabled() && !e.isConsumed() && iq.getType() == AbstractIQ.Type.GET && iq.getExtension(LastActivity.class) != null) {
                    LastActivityManager lastActivityManager = LastActivityManager.this;
                    synchronized (lastActivityManager) {
                        IQ result = iq.createResult();
                        long seconds = LastActivityManager.this.lastActivityStrategy != null && LastActivityManager.this.lastActivityStrategy.getLastActivity() != null ? LastActivityManager.this.getSecondsSince(LastActivityManager.this.lastActivityStrategy.getLastActivity()) : 0L;
                        result.setExtension((Object)new LastActivity(seconds, null));
                        xmppSession.send((ClientStreamElement)result);
                        e.consume();
                    }
                }
            }
        });
        this.setEnabled(true);
    }

    private long getSecondsSince(Date date) {
        return Math.max(0L, System.currentTimeMillis() - date.getTime()) / 1000L;
    }

    public LastActivity getLastActivity(Jid jid) throws XmppException {
        IQ result = this.xmppSession.query(new IQ(jid, AbstractIQ.Type.GET, (Object)new LastActivity()));
        return (LastActivity)result.getExtension(LastActivity.class);
    }

    public synchronized LastActivityStrategy getLastActivityStrategy() {
        return this.lastActivityStrategy;
    }

    public synchronized void setLastActivityStrategy(LastActivityStrategy lastActivityStrategy) {
        this.lastActivityStrategy = lastActivityStrategy;
    }

    private static class DefaultLastActivityStrategy
    implements LastActivityStrategy {
        private volatile Date lastActivity;

        public DefaultLastActivityStrategy(XmppSession xmppSession) {
            xmppSession.addMessageListener(new MessageListener(){

                public void handle(MessageEvent e) {
                    if (!e.isIncoming()) {
                        DefaultLastActivityStrategy.this.lastActivity = new Date();
                    }
                }
            });
            xmppSession.addPresenceListener(new PresenceListener(){

                public void handle(PresenceEvent e) {
                    Presence presence = e.getPresence();
                    if (!e.isIncoming() && (!presence.isAvailable() || presence.getShow() != AbstractPresence.Show.AWAY && presence.getShow() != AbstractPresence.Show.XA)) {
                        DefaultLastActivityStrategy.this.lastActivity = new Date();
                    }
                }
            });
        }

        @Override
        public Date getLastActivity() {
            return this.lastActivity;
        }
    }
}

