/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.muc;

import java.util.ArrayList;
import java.util.List;
import rocks.xmpp.core.Jid;
import rocks.xmpp.core.XmppException;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.extensions.disco.ServiceDiscoveryManager;
import rocks.xmpp.extensions.disco.model.items.Item;
import rocks.xmpp.extensions.disco.model.items.ItemNode;
import rocks.xmpp.extensions.muc.ChatRoom;

public final class ChatService {
    private final XmppSession xmppSession;
    private final Jid serviceAddress;
    private final ServiceDiscoveryManager serviceDiscoveryManager;

    ChatService(Jid serviceAddress, XmppSession xmppSession, ServiceDiscoveryManager serviceDiscoveryManager) {
        this.xmppSession = xmppSession;
        this.serviceAddress = serviceAddress;
        this.serviceDiscoveryManager = serviceDiscoveryManager;
    }

    public List<ChatRoom> getPublicRooms() throws XmppException {
        ArrayList<ChatRoom> chatRooms = new ArrayList<ChatRoom>();
        ItemNode itemNode = this.serviceDiscoveryManager.discoverItems(this.serviceAddress);
        for (Item item : itemNode.getItems()) {
            chatRooms.add(new ChatRoom(item.getName(), item.getJid(), this.xmppSession));
        }
        return chatRooms;
    }

    public ChatRoom createRoom(String room) {
        return new ChatRoom(null, new Jid(room, this.serviceAddress.getDomain()), this.xmppSession);
    }

    public Jid getAddress() {
        return this.serviceAddress;
    }

    public String toString() {
        return this.serviceAddress.toString();
    }
}

