/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.oob;

import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import rocks.xmpp.core.session.ExtensionManager;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.IQEvent;
import rocks.xmpp.core.stanza.IQListener;
import rocks.xmpp.core.stanza.model.AbstractIQ;
import rocks.xmpp.core.stanza.model.StanzaError;
import rocks.xmpp.core.stanza.model.client.IQ;
import rocks.xmpp.core.stanza.model.errors.Condition;
import rocks.xmpp.core.stanza.model.errors.ItemNotFound;
import rocks.xmpp.core.stanza.model.errors.NotAcceptable;
import rocks.xmpp.core.stream.model.ClientStreamElement;
import rocks.xmpp.extensions.filetransfer.FileTransfer;
import rocks.xmpp.extensions.filetransfer.FileTransferManager;
import rocks.xmpp.extensions.filetransfer.FileTransferNegotiator;
import rocks.xmpp.extensions.filetransfer.FileTransferOffer;
import rocks.xmpp.extensions.filetransfer.FileTransferStatusEvent;
import rocks.xmpp.extensions.filetransfer.FileTransferStatusListener;
import rocks.xmpp.extensions.filetransfer.Range;
import rocks.xmpp.extensions.hashes.model.Hash;
import rocks.xmpp.extensions.oob.model.iq.OobIQ;

public final class OutOfBandFileTransferManager
extends ExtensionManager
implements FileTransferNegotiator {
    private OutOfBandFileTransferManager(final XmppSession xmppSession) {
        super(xmppSession, new String[]{"jabber:iq:oob", "jabber:x:oob"});
        final FileTransferManager fileTransferManager = (FileTransferManager)xmppSession.getExtensionManager(FileTransferManager.class);
        xmppSession.addIQListener(new IQListener(){

            public void handle(IQEvent e) {
                OobIQ oobIQ;
                IQ iq = e.getIQ();
                if (e.isIncoming() && OutOfBandFileTransferManager.this.isEnabled() && !e.isConsumed() && iq.getType() == AbstractIQ.Type.SET && (oobIQ = (OobIQ)iq.getExtension(OobIQ.class)) != null) {
                    URL url = oobIQ.getUrl();
                    final String description = oobIQ.getDescription();
                    try {
                        HttpURLConnection connection = null;
                        try {
                            URLConnection urlConnection = url.openConnection();
                            if (urlConnection instanceof HttpURLConnection) {
                                connection = (HttpURLConnection)urlConnection;
                                connection.setRequestMethod("HEAD");
                                connection.connect();
                                String mimeType = connection.getContentType();
                                final long length = connection.getContentLengthLong();
                                long lastModified = connection.getLastModified();
                                final Date date = lastModified > 0L ? new Date(lastModified) : null;
                                final String name = url.toString();
                                fileTransferManager.fileTransferOffered(iq, null, mimeType, null, new FileTransferOffer(){

                                    public long getSize() {
                                        return length;
                                    }

                                    public String getName() {
                                        return name;
                                    }

                                    public Date getDate() {
                                        return date;
                                    }

                                    public List<Hash> getHashes() {
                                        return Collections.emptyList();
                                    }

                                    public String getDescription() {
                                        return description;
                                    }

                                    public Range getRange() {
                                        return null;
                                    }
                                }, OutOfBandFileTransferManager.this);
                            } else {
                                xmppSession.send((ClientStreamElement)iq.createError(new StanzaError((Condition)new NotAcceptable())));
                            }
                        }
                        catch (ProtocolException e1) {
                            throw new IOException(e1);
                        }
                        finally {
                            if (connection != null) {
                                connection.disconnect();
                            }
                        }
                    }
                    catch (IOException e1) {
                        xmppSession.send((ClientStreamElement)iq.createError(new StanzaError((Condition)new ItemNotFound())));
                    }
                    e.consume();
                }
            }
        });
        this.setEnabled(true);
    }

    @Override
    public FileTransfer accept(final IQ iq, String sessionId, FileTransferOffer fileTransferOffer, Object protocol, OutputStream outputStream) throws IOException {
        try {
            URL url = new URL(fileTransferOffer.getName());
            URLConnection urlConnection = url.openConnection();
            final FileTransfer fileTransfer = new FileTransfer(urlConnection.getInputStream(), outputStream, fileTransferOffer.getSize());
            fileTransfer.addFileTransferStatusListener(new FileTransferStatusListener(){

                @Override
                public void fileTransferStatusChanged(FileTransferStatusEvent e) {
                    if (e.getStatus() == FileTransfer.Status.COMPLETED) {
                        OutOfBandFileTransferManager.this.xmppSession.send((ClientStreamElement)iq.createResult());
                        fileTransfer.removeFileTransferStatusListener(this);
                    } else if (e.getStatus() == FileTransfer.Status.CANCELED || e.getStatus() == FileTransfer.Status.FAILED) {
                        OutOfBandFileTransferManager.this.xmppSession.send((ClientStreamElement)iq.createError(new StanzaError((Condition)new ItemNotFound())));
                        fileTransfer.removeFileTransferStatusListener(this);
                    }
                }
            });
            return fileTransfer;
        }
        catch (MalformedURLException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void reject(IQ iq) {
        this.xmppSession.send((ClientStreamElement)iq.createError(new StanzaError((Condition)new NotAcceptable())));
    }
}

