/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.ping;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import rocks.xmpp.core.Jid;
import rocks.xmpp.core.XmppException;
import rocks.xmpp.core.session.ExtensionManager;
import rocks.xmpp.core.session.SessionStatusEvent;
import rocks.xmpp.core.session.SessionStatusListener;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.IQEvent;
import rocks.xmpp.core.stanza.IQListener;
import rocks.xmpp.core.stanza.model.AbstractIQ;
import rocks.xmpp.core.stanza.model.client.IQ;
import rocks.xmpp.core.stream.model.ClientStreamElement;
import rocks.xmpp.extensions.ping.model.Ping;

public final class PingManager
extends ExtensionManager {
    private static final Logger logger = Logger.getLogger(PingManager.class.getName());
    private final ScheduledExecutorService scheduledExecutorService;
    private volatile ScheduledFuture<?> nextPing;
    private long pingInterval = 900L;

    private PingManager(final XmppSession xmppSession) {
        super(xmppSession, new String[]{"urn:xmpp:ping"});
        xmppSession.addIQListener(new IQListener(){

            public void handle(IQEvent e) {
                IQ iq = e.getIQ();
                if (e.isIncoming() && PingManager.this.isEnabled() && !e.isConsumed() && iq.getType() == AbstractIQ.Type.GET && iq.getExtension(Ping.class) != null) {
                    xmppSession.send((ClientStreamElement)iq.createResult());
                    e.consume();
                }
            }
        });
        xmppSession.addSessionStatusListener(new SessionStatusListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void sessionStatusChanged(SessionStatusEvent e) {
                if (e.getStatus() == XmppSession.Status.CLOSED) {
                    PingManager pingManager = PingManager.this;
                    synchronized (pingManager) {
                        if (PingManager.this.nextPing != null) {
                            PingManager.this.nextPing.cancel(false);
                        }
                        PingManager.this.nextPing = null;
                        PingManager.this.scheduledExecutorService.shutdown();
                    }
                }
            }
        });
        this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r, "XMPP Scheduled Ping Thread");
                thread.setDaemon(true);
                return thread;
            }
        });
        this.setEnabled(true);
    }

    public void ping(Jid jid) throws XmppException {
        this.xmppSession.query(new IQ(jid, AbstractIQ.Type.GET, (Object)new Ping()));
    }

    public void pingServer() throws XmppException {
        this.ping(null);
    }

    public synchronized long getPingInterval() {
        return this.pingInterval;
    }

    public synchronized void setPingInterval(long pingInterval) {
        this.pingInterval = pingInterval;
        if (this.nextPing != null) {
            this.nextPing.cancel(false);
        }
        this.startPinging();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEnabled(boolean enabled) {
        boolean wasEnabled = this.isEnabled();
        super.setEnabled(enabled);
        if (enabled && !wasEnabled) {
            this.startPinging();
        } else if (!enabled && wasEnabled) {
            PingManager pingManager = this;
            synchronized (pingManager) {
                if (this.nextPing != null) {
                    this.nextPing.cancel(false);
                }
            }
        }
    }

    private synchronized void startPinging() {
        if (this.pingInterval > 0L && !this.scheduledExecutorService.isShutdown()) {
            this.nextPing = this.scheduledExecutorService.schedule(new Runnable(){

                @Override
                public void run() {
                    if (PingManager.this.isEnabled() && PingManager.this.xmppSession.getStatus() == XmppSession.Status.AUTHENTICATED) {
                        try {
                            PingManager.this.pingServer();
                        }
                        catch (XmppException e) {
                            logger.log(Level.WARNING, "Pinging server failed.", e);
                        }
                    }
                    PingManager.this.nextPing = PingManager.this.scheduledExecutorService.schedule(this, PingManager.this.pingInterval, TimeUnit.SECONDS);
                }
            }, this.pingInterval, TimeUnit.SECONDS);
        }
    }
}

