/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.pubsub;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import rocks.xmpp.core.Jid;
import rocks.xmpp.core.XmppException;
import rocks.xmpp.core.session.ExtensionManager;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.MessageEvent;
import rocks.xmpp.core.stanza.MessageListener;
import rocks.xmpp.core.stanza.model.client.Message;
import rocks.xmpp.extensions.disco.ServiceDiscoveryManager;
import rocks.xmpp.extensions.disco.model.info.Feature;
import rocks.xmpp.extensions.disco.model.info.InfoNode;
import rocks.xmpp.extensions.disco.model.items.Item;
import rocks.xmpp.extensions.disco.model.items.ItemNode;
import rocks.xmpp.extensions.pubsub.PubSubListener;
import rocks.xmpp.extensions.pubsub.PubSubService;
import rocks.xmpp.extensions.pubsub.model.event.Event;

public final class PubSubManager
extends ExtensionManager {
    final Set<PubSubListener> pubSubListeners = new CopyOnWriteArraySet<PubSubListener>();
    private final ServiceDiscoveryManager serviceDiscoveryManager;

    private PubSubManager(XmppSession xmppSession) {
        super(xmppSession, new String[0]);
        this.serviceDiscoveryManager = (ServiceDiscoveryManager)xmppSession.getExtensionManager(ServiceDiscoveryManager.class);
        xmppSession.addMessageListener(new MessageListener(){

            public void handle(MessageEvent e) {
                Message message;
                Event event;
                if (e.isIncoming() && (event = (Event)(message = e.getMessage()).getExtension(Event.class)) != null) {
                    boolean bl = false;
                }
            }
        });
    }

    public Collection<PubSubService> getPubSubServices() throws XmppException {
        ItemNode itemNode = this.serviceDiscoveryManager.discoverItems(null);
        ArrayList<PubSubService> pubSubServices = new ArrayList<PubSubService>();
        for (Item item : itemNode.getItems()) {
            InfoNode infoNode = this.serviceDiscoveryManager.discoverInformation(item.getJid());
            if (!infoNode.getFeatures().contains(new Feature("http://jabber.org/protocol/pubsub"))) continue;
            pubSubServices.add(new PubSubService(item.getJid(), this.xmppSession, this.serviceDiscoveryManager));
        }
        return pubSubServices;
    }

    public PubSubService createPubSubService(Jid service) {
        return new PubSubService(service, this.xmppSession, this.serviceDiscoveryManager);
    }

    public PubSubService createPersonalEventingService() {
        return new PubSubService(this.xmppSession.getConnectedResource().asBareJid(), this.xmppSession, this.serviceDiscoveryManager);
    }

    public void addPubSubListener(PubSubListener pubSubListener) {
        this.pubSubListeners.add(pubSubListener);
    }

    public void removePubSubListener(PubSubListener pubSubListener) {
        this.pubSubListeners.remove(pubSubListener);
    }
}

