/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.reach;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import rocks.xmpp.core.Jid;
import rocks.xmpp.core.XmppException;
import rocks.xmpp.core.session.ExtensionManager;
import rocks.xmpp.core.session.SessionStatusEvent;
import rocks.xmpp.core.session.SessionStatusListener;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.IQEvent;
import rocks.xmpp.core.stanza.IQListener;
import rocks.xmpp.core.stanza.MessageEvent;
import rocks.xmpp.core.stanza.MessageListener;
import rocks.xmpp.core.stanza.PresenceEvent;
import rocks.xmpp.core.stanza.PresenceListener;
import rocks.xmpp.core.stanza.model.AbstractIQ;
import rocks.xmpp.core.stanza.model.Stanza;
import rocks.xmpp.core.stanza.model.client.IQ;
import rocks.xmpp.core.stanza.model.client.Presence;
import rocks.xmpp.core.stream.model.ClientStreamElement;
import rocks.xmpp.extensions.reach.ReachabilityEvent;
import rocks.xmpp.extensions.reach.ReachabilityListener;
import rocks.xmpp.extensions.reach.model.Address;
import rocks.xmpp.extensions.reach.model.Reachability;

public final class ReachabilityManager
extends ExtensionManager {
    private static final Logger logger = Logger.getLogger(ReachabilityManager.class.getName());
    private final Set<ReachabilityListener> reachabilityListeners = new CopyOnWriteArraySet<ReachabilityListener>();
    private final Map<Jid, List<Address>> reachabilities = new ConcurrentHashMap<Jid, List<Address>>();
    private final List<Address> addresses = new CopyOnWriteArrayList<Address>();

    private ReachabilityManager(final XmppSession xmppSession) {
        super(xmppSession, new String[]{"urn:xmpp:reach:0"});
        xmppSession.addSessionStatusListener(new SessionStatusListener(){

            public void sessionStatusChanged(SessionStatusEvent e) {
                if (e.getStatus() == XmppSession.Status.CLOSED) {
                    ReachabilityManager.this.reachabilityListeners.clear();
                    ReachabilityManager.this.reachabilities.clear();
                    ReachabilityManager.this.addresses.clear();
                }
            }
        });
        xmppSession.addPresenceListener(new PresenceListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handle(PresenceEvent e) {
                Presence presence = e.getPresence();
                if (e.isIncoming()) {
                    boolean hasReachability = ReachabilityManager.this.checkStanzaForReachabilityAndNotify((Stanza)presence);
                    Jid contact = presence.getFrom().asBareJid();
                    if (!hasReachability && ReachabilityManager.this.reachabilities.remove(contact) != null) {
                        ReachabilityManager.this.notifyReachabilityListeners(contact, new ArrayList());
                    }
                } else if (presence.isAvailable() && presence.getTo() == null) {
                    List list = ReachabilityManager.this.addresses;
                    synchronized (list) {
                        if (!ReachabilityManager.this.addresses.isEmpty()) {
                            presence.getExtensions().add(new Reachability(new ArrayList(ReachabilityManager.this.addresses)));
                        }
                    }
                }
            }
        });
        xmppSession.addMessageListener(new MessageListener(){

            public void handle(MessageEvent e) {
                if (e.isIncoming()) {
                    ReachabilityManager.this.checkStanzaForReachabilityAndNotify((Stanza)e.getMessage());
                }
            }
        });
        xmppSession.addIQListener(new IQListener(){

            public void handle(IQEvent e) {
                IQ iq = e.getIQ();
                if (e.isIncoming() && ReachabilityManager.this.isEnabled() && !e.isConsumed() && iq.getType() == AbstractIQ.Type.GET && iq.getExtension(Reachability.class) != null) {
                    IQ result = iq.createResult();
                    result.setExtension((Object)new Reachability(new ArrayList(ReachabilityManager.this.addresses)));
                    xmppSession.send((ClientStreamElement)result);
                    e.consume();
                }
            }
        });
    }

    public List<Address> getReachabilityAddresses() {
        return this.addresses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkStanzaForReachabilityAndNotify(Stanza stanza) {
        Reachability reachability = (Reachability)stanza.getExtension(Reachability.class);
        if (stanza.getFrom() != null) {
            Jid contact = stanza.getFrom().asBareJid();
            if (reachability != null) {
                Map<Jid, List<Address>> map = this.reachabilities;
                synchronized (map) {
                    List<Address> oldReachabilityAddresses = this.reachabilities.get(contact);
                    if (oldReachabilityAddresses == null || !oldReachabilityAddresses.equals(reachability.getAddresses())) {
                        this.reachabilities.put(contact, reachability.getAddresses());
                        this.notifyReachabilityListeners(contact, reachability.getAddresses());
                    }
                }
            }
        }
        return reachability != null;
    }

    private void notifyReachabilityListeners(Jid from, List<Address> reachabilityAddresses) {
        for (ReachabilityListener reachabilityListener : this.reachabilityListeners) {
            try {
                reachabilityListener.reachabilityChanged(new ReachabilityEvent((Object)this, from, reachabilityAddresses));
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, ex.getMessage(), ex);
            }
        }
    }

    public void addReachabilityListener(ReachabilityListener reachabilityListener) {
        this.reachabilityListeners.add(reachabilityListener);
    }

    public void removeReachabilityListener(ReachabilityListener reachabilityListener) {
        this.reachabilityListeners.remove(reachabilityListener);
    }

    public List<Address> requestReachabilityAddresses(Jid contact) throws XmppException {
        IQ result = this.xmppSession.query(new IQ(contact, AbstractIQ.Type.GET, (Object)new Reachability()));
        Reachability reachability = (Reachability)result.getExtension(Reachability.class);
        if (reachability != null) {
            return reachability.getAddresses();
        }
        return null;
    }
}

