/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.rpc;

import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import rocks.xmpp.core.Jid;
import rocks.xmpp.core.XmppException;
import rocks.xmpp.core.session.ExtensionManager;
import rocks.xmpp.core.session.SessionStatusEvent;
import rocks.xmpp.core.session.SessionStatusListener;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.IQEvent;
import rocks.xmpp.core.stanza.IQListener;
import rocks.xmpp.core.stanza.model.AbstractIQ;
import rocks.xmpp.core.stanza.model.StanzaError;
import rocks.xmpp.core.stanza.model.client.IQ;
import rocks.xmpp.core.stanza.model.errors.Condition;
import rocks.xmpp.core.stanza.model.errors.InternalServerError;
import rocks.xmpp.core.stream.model.ClientStreamElement;
import rocks.xmpp.extensions.rpc.RpcException;
import rocks.xmpp.extensions.rpc.RpcHandler;
import rocks.xmpp.extensions.rpc.model.Rpc;
import rocks.xmpp.extensions.rpc.model.Value;

public final class RpcManager
extends ExtensionManager {
    private static final Logger logger = Logger.getLogger(RpcManager.class.getName());
    ExecutorService executorService = Executors.newCachedThreadPool();
    private RpcHandler rpcHandler;

    private RpcManager(final XmppSession xmppSession) {
        super(xmppSession, new String[]{"jabber:iq:rpc"});
        xmppSession.addSessionStatusListener(new SessionStatusListener(){

            public void sessionStatusChanged(SessionStatusEvent e) {
                if (e.getStatus() == XmppSession.Status.CLOSED) {
                    RpcManager.this.rpcHandler = null;
                    RpcManager.this.executorService.shutdown();
                }
            }
        });
        xmppSession.addIQListener(new IQListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handle(IQEvent e) {
                Rpc rpc;
                final IQ iq = e.getIQ();
                if (e.isIncoming() && RpcManager.this.isEnabled() && !e.isConsumed() && iq.getType() == AbstractIQ.Type.SET && (rpc = (Rpc)iq.getExtension(Rpc.class)) != null) {
                    RpcManager rpcManager = RpcManager.this;
                    synchronized (rpcManager) {
                        if (RpcManager.this.rpcHandler != null) {
                            final Rpc.MethodCall methodCall = rpc.getMethodCall();
                            final ArrayList<Value> parameters = new ArrayList<Value>();
                            for (Value parameter : methodCall.getParameters()) {
                                parameters.add(parameter);
                            }
                            RpcManager.this.executorService.execute(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        Value value = RpcManager.this.rpcHandler.process(iq.getFrom(), methodCall.getMethodName(), parameters);
                                        IQ result = iq.createResult();
                                        result.setExtension((Object)new Rpc(value));
                                        xmppSession.send((ClientStreamElement)result);
                                    }
                                    catch (RpcException e1) {
                                        IQ result = iq.createResult();
                                        result.setExtension((Object)new Rpc(new Rpc.MethodResponse.Fault(e1.getFaultCode(), e1.getFaultString())));
                                        xmppSession.send((ClientStreamElement)result);
                                    }
                                    catch (Throwable e1) {
                                        logger.log(Level.WARNING, e1.getMessage(), e1);
                                        xmppSession.send((ClientStreamElement)iq.createError(new StanzaError((Condition)new InternalServerError())));
                                    }
                                }
                            });
                            e.consume();
                        }
                    }
                }
            }
        });
    }

    public Value call(Jid jid, String methodName, Value ... parameters) throws XmppException, RpcException {
        Rpc.MethodResponse methodResponse;
        Rpc rpc;
        IQ result = this.xmppSession.query(new IQ(jid, AbstractIQ.Type.SET, (Object)new Rpc(methodName, parameters)));
        if (result != null && (rpc = (Rpc)result.getExtension(Rpc.class)) != null && (methodResponse = rpc.getMethodResponse()) != null) {
            if (methodResponse.getFault() != null) {
                throw new RpcException(methodResponse.getFault().getFaultCode(), methodResponse.getFault().getFaultString());
            }
            return methodResponse.getResponse();
        }
        return null;
    }

    public synchronized void setRpcHandler(RpcHandler rpcHandler) {
        this.rpcHandler = rpcHandler;
        this.setEnabled(rpcHandler != null);
    }
}

