/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.version;

import rocks.xmpp.core.Jid;
import rocks.xmpp.core.XmppException;
import rocks.xmpp.core.session.ExtensionManager;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.IQEvent;
import rocks.xmpp.core.stanza.IQListener;
import rocks.xmpp.core.stanza.model.AbstractIQ;
import rocks.xmpp.core.stanza.model.client.IQ;
import rocks.xmpp.core.stream.model.ClientStreamElement;
import rocks.xmpp.extensions.version.model.SoftwareVersion;

public final class SoftwareVersionManager
extends ExtensionManager {
    private SoftwareVersion softwareVersion;

    private SoftwareVersionManager(final XmppSession xmppSession) {
        super(xmppSession, new String[]{"jabber:iq:version"});
        xmppSession.addIQListener(new IQListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handle(IQEvent e) {
                IQ iq = e.getIQ();
                if (e.isIncoming() && SoftwareVersionManager.this.isEnabled() && !e.isConsumed() && iq.getType() == AbstractIQ.Type.GET && iq.getExtension(SoftwareVersion.class) != null) {
                    SoftwareVersionManager softwareVersionManager = SoftwareVersionManager.this;
                    synchronized (softwareVersionManager) {
                        if (SoftwareVersionManager.this.softwareVersion != null) {
                            IQ result = iq.createResult();
                            result.setExtension((Object)SoftwareVersionManager.this.softwareVersion);
                            xmppSession.send((ClientStreamElement)result);
                            e.consume();
                        }
                    }
                }
            }
        });
        this.setEnabled(true);
    }

    public SoftwareVersion getSoftwareVersion(Jid jid) throws XmppException {
        IQ iq = new IQ(AbstractIQ.Type.GET, (Object)new SoftwareVersion());
        iq.setTo(jid);
        IQ result = this.xmppSession.query(iq);
        return (SoftwareVersion)result.getExtension(SoftwareVersion.class);
    }

    public synchronized SoftwareVersion getSoftwareVersion() {
        return this.softwareVersion;
    }

    public synchronized void setSoftwareVersion(SoftwareVersion softwareVersion) {
        this.softwareVersion = softwareVersion;
    }
}

