/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.avatar;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import rocks.xmpp.core.Jid;
import rocks.xmpp.core.XmppException;
import rocks.xmpp.core.XmppUtils;
import rocks.xmpp.core.session.ExtensionManager;
import rocks.xmpp.core.session.SessionStatusEvent;
import rocks.xmpp.core.session.SessionStatusListener;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.MessageEvent;
import rocks.xmpp.core.stanza.MessageListener;
import rocks.xmpp.core.stanza.PresenceEvent;
import rocks.xmpp.core.stanza.PresenceListener;
import rocks.xmpp.core.stanza.StanzaException;
import rocks.xmpp.core.stanza.model.AbstractPresence;
import rocks.xmpp.core.stanza.model.client.Message;
import rocks.xmpp.core.stanza.model.client.Presence;
import rocks.xmpp.core.stream.model.ClientStreamElement;
import rocks.xmpp.core.subscription.PresenceManager;
import rocks.xmpp.core.util.cache.DirectoryCache;
import rocks.xmpp.extensions.address.model.Address;
import rocks.xmpp.extensions.address.model.Addresses;
import rocks.xmpp.extensions.avatar.AvatarChangeEvent;
import rocks.xmpp.extensions.avatar.AvatarChangeListener;
import rocks.xmpp.extensions.avatar.model.data.AvatarData;
import rocks.xmpp.extensions.avatar.model.metadata.AvatarMetadata;
import rocks.xmpp.extensions.muc.model.user.MucUser;
import rocks.xmpp.extensions.pubsub.PubSubManager;
import rocks.xmpp.extensions.pubsub.PubSubService;
import rocks.xmpp.extensions.pubsub.model.Item;
import rocks.xmpp.extensions.pubsub.model.event.Event;
import rocks.xmpp.extensions.vcard.avatar.model.AvatarUpdate;
import rocks.xmpp.extensions.vcard.temp.VCardManager;
import rocks.xmpp.extensions.vcard.temp.model.VCard;

public final class AvatarManager
extends ExtensionManager {
    private static final Logger logger = Logger.getLogger(VCardManager.class.getName());
    private final Map<Jid, String> userHashes = new ConcurrentHashMap<Jid, String>();
    private final ConcurrentHashMap<Jid, Lock> requestingAvatarLocks = new ConcurrentHashMap();
    private final Set<AvatarChangeListener> avatarChangeListeners = new CopyOnWriteArraySet<AvatarChangeListener>();
    private final ExecutorService avatarRequester;
    private final VCardManager vCardManager;
    private final Set<String> nonConformingResources = Collections.synchronizedSet(new HashSet());
    private final Map<String, byte[]> avatarCache;

    private AvatarManager(XmppSession xmppSession) {
        super(xmppSession, new String[]{"urn:xmpp:avatar:metadata+notify", "urn:xmpp:avatar:metadata"});
        this.vCardManager = (VCardManager)xmppSession.getManager(VCardManager.class);
        this.avatarCache = xmppSession.getConfiguration().getCacheDirectory() != null ? new DirectoryCache(xmppSession.getConfiguration().getCacheDirectory().resolve("avatars")) : null;
        this.avatarRequester = Executors.newSingleThreadExecutor(XmppUtils.createNamedThreadFactory((String)"Avatar Request Thread"));
        this.setEnabled(false);
    }

    protected final void initialize() {
        this.xmppSession.addSessionStatusListener(new SessionStatusListener(){

            public void sessionStatusChanged(SessionStatusEvent e) {
                if (e.getStatus() == XmppSession.Status.CLOSED) {
                    AvatarManager.this.avatarChangeListeners.clear();
                    AvatarManager.this.requestingAvatarLocks.clear();
                    AvatarManager.this.nonConformingResources.clear();
                    AvatarManager.this.userHashes.clear();
                    AvatarManager.this.avatarRequester.shutdown();
                }
            }
        });
        this.xmppSession.addInboundPresenceListener(new PresenceListener(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void handlePresence(PresenceEvent e) {
                Jid contact;
                if (!AvatarManager.this.isEnabled()) {
                    return;
                }
                Presence presence = e.getPresence();
                AvatarUpdate avatarUpdate = (AvatarUpdate)presence.getExtension(AvatarUpdate.class);
                if (presence.getFrom().asBareJid().equals((Object)AvatarManager.this.xmppSession.getConnectedResource().asBareJid()) && presence.getFrom().getResource() != null && !presence.getFrom().getResource().equals(AvatarManager.this.xmppSession.getConnectedResource().getResource())) {
                    if (avatarUpdate == null) {
                        if (presence.isAvailable()) {
                            AvatarManager.this.nonConformingResources.add(presence.getFrom().getResource());
                        } else if (presence.getType() == AbstractPresence.Type.UNAVAILABLE && AvatarManager.this.nonConformingResources.remove(presence.getFrom().getResource()) && AvatarManager.this.nonConformingResources.isEmpty()) {
                            AvatarManager.this.resetHash();
                        }
                    } else if (avatarUpdate.getHash() != null && !avatarUpdate.getHash().equals(AvatarManager.this.userHashes.get(AvatarManager.this.xmppSession.getConnectedResource().asBareJid()))) {
                        AvatarManager.this.resetHash();
                    }
                }
                if (avatarUpdate == null || avatarUpdate.getHash() == null) return;
                MucUser mucUser = (MucUser)presence.getExtension(MucUser.class);
                if (mucUser != null) {
                    if (mucUser.getItem() == null || mucUser.getItem().getJid() == null) return;
                    contact = mucUser.getItem().getJid().asBareJid();
                } else {
                    contact = presence.getFrom().asBareJid();
                }
                if (avatarUpdate.getHash().equals(AvatarManager.this.userHashes.put(contact, avatarUpdate.getHash()))) return;
                byte[] imageData = AvatarManager.this.loadFromCache(avatarUpdate.getHash());
                byte[] avatar = null;
                if (imageData != null) {
                    avatar = imageData;
                }
                if (avatar != null) {
                    AvatarManager.this.notifyListeners(contact, avatar);
                    return;
                } else {
                    AvatarManager.this.avatarRequester.execute(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                AvatarManager.this.notifyListeners(contact, AvatarManager.this.getAvatarByVCard(contact));
                            }
                            catch (XmppException e1) {
                                logger.warning(String.format("Failed to retrieve vCard based avatar for user: %s", contact));
                            }
                        }
                    });
                }
            }
        });
        this.xmppSession.addOutboundPresenceListener(new PresenceListener(){

            public void handlePresence(PresenceEvent e) {
                if (!AvatarManager.this.isEnabled()) {
                    return;
                }
                Presence presence = e.getPresence();
                if (presence.isAvailable() && AvatarManager.this.nonConformingResources.isEmpty()) {
                    String myHash = (String)AvatarManager.this.userHashes.get(AvatarManager.this.xmppSession.getConnectedResource().asBareJid());
                    if (myHash == null) {
                        presence.getExtensions().add(new AvatarUpdate());
                        AvatarManager.this.avatarRequester.execute(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                try {
                                    XmppSession xmppSession = AvatarManager.this.xmppSession;
                                    synchronized (xmppSession) {
                                        if (!AvatarManager.this.xmppSession.isConnected()) {
                                            return;
                                        }
                                        AvatarManager.this.getAvatarByVCard(AvatarManager.this.xmppSession.getConnectedResource().asBareJid());
                                        Presence lastPresence = ((PresenceManager)AvatarManager.this.xmppSession.getManager(PresenceManager.class)).getLastSentPresence();
                                        Presence presence = lastPresence != null ? new Presence(null, lastPresence.getType(), lastPresence.getShow(), (Collection)lastPresence.getStatuses(), lastPresence.getPriority(), null, null, lastPresence.getLanguage(), null, null) : new Presence();
                                        AvatarManager.this.xmppSession.send((ClientStreamElement)presence);
                                    }
                                }
                                catch (XmppException e1) {
                                    logger.log(Level.WARNING, "Failed to retrieve own vCard based avatar.", e1);
                                }
                            }
                        });
                    } else if (presence.getExtension(AvatarUpdate.class) == null) {
                        presence.getExtensions().add(new AvatarUpdate(myHash));
                    }
                }
            }
        });
        this.xmppSession.addInboundMessageListener(new MessageListener(){

            public void handleMessage(MessageEvent e) {
                if (!AvatarManager.this.isEnabled()) {
                    return;
                }
                final Message message = e.getMessage();
                Event event = (Event)message.getExtension(Event.class);
                if (event != null) {
                    Addresses addresses = (Addresses)message.getExtension(Addresses.class);
                    if (addresses != null) {
                        for (Address address : addresses.getAddresses()) {
                            if (address.getType() != Address.Type.REPLYTO || !AvatarManager.this.xmppSession.getConnectedResource().equals((Object)address.getJid())) continue;
                            return;
                        }
                    }
                    for (final Item item : event.getItems()) {
                        if (!(item.getPayload() instanceof AvatarMetadata)) continue;
                        AvatarMetadata avatarMetadata = (AvatarMetadata)item.getPayload();
                        if (avatarMetadata.getInfoList().isEmpty()) {
                            AvatarManager.this.notifyListeners(message.getFrom().asBareJid(), null);
                            continue;
                        }
                        byte[] cachedImage = AvatarManager.this.loadFromCache(item.getId());
                        if (cachedImage != null) {
                            AvatarManager.this.notifyListeners(message.getFrom().asBareJid(), cachedImage);
                            continue;
                        }
                        AvatarMetadata.Info chosenInfo = null;
                        for (AvatarMetadata.Info info : avatarMetadata.getInfoList()) {
                            if (info.getUrl() != null) continue;
                            chosenInfo = info;
                        }
                        if (chosenInfo == null) {
                            for (AvatarMetadata.Info info : avatarMetadata.getInfoList()) {
                                if (info.getUrl() == null) continue;
                                chosenInfo = info;
                                break;
                            }
                        }
                        if (chosenInfo != null && chosenInfo.getUrl() != null) {
                            try {
                                URLConnection urlConnection = chosenInfo.getUrl().openConnection();
                                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                                try (InputStream in = urlConnection.getInputStream();){
                                    int n;
                                    byte[] data = new byte[4096];
                                    while ((n = in.read(data, 0, 4096)) != -1) {
                                        baos.write(data, 0, n);
                                    }
                                }
                                byte[] data = baos.toByteArray();
                                AvatarManager.this.storeToCache(item.getId(), data);
                                AvatarManager.this.notifyListeners(message.getFrom().asBareJid(), data);
                            }
                            catch (IOException e1) {
                                logger.warning(String.format("Failed to download avatar from advertised URL: %s.", chosenInfo.getUrl()));
                            }
                            continue;
                        }
                        AvatarManager.this.avatarRequester.execute(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    Item i;
                                    PubSubService pubSubService = ((PubSubManager)AvatarManager.this.xmppSession.getManager(PubSubManager.class)).createPubSubService(message.getFrom());
                                    List<Item> items = pubSubService.node("urn:xmpp:avatar:data").getItems(item.getId());
                                    if (!items.isEmpty() && (i = items.get(0)).getPayload() instanceof AvatarData) {
                                        AvatarData avatarData = (AvatarData)i.getPayload();
                                        AvatarManager.this.storeToCache(item.getId(), avatarData.getData());
                                        AvatarManager.this.notifyListeners(message.getFrom().asBareJid(), avatarData.getData());
                                    }
                                }
                                catch (XmppException e1) {
                                    logger.warning(String.format("Failed to retrieve avatar '%s' from PEP service for user '%s'", item.getId(), message.getFrom()));
                                }
                            }
                        });
                    }
                }
            }
        });
    }

    private void resetHash() {
        this.userHashes.remove(this.xmppSession.getConnectedResource().asBareJid());
        Presence presence = ((PresenceManager)this.xmppSession.getManager(PresenceManager.class)).getLastSentPresence();
        if (presence == null) {
            presence = new Presence();
        }
        presence.getExtensions().clear();
        this.xmppSession.send((ClientStreamElement)presence);
    }

    private void notifyListeners(Jid contact, byte[] avatar) {
        AvatarChangeEvent avatarChangeEvent = new AvatarChangeEvent(this, contact, avatar);
        for (AvatarChangeListener avatarChangeListener : this.avatarChangeListeners) {
            try {
                avatarChangeListener.avatarChanged(avatarChangeEvent);
            }
            catch (Exception e1) {
                logger.log(Level.WARNING, e1.getMessage(), e1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getAvatarByVCard(Jid contact) throws XmppException {
        byte[] avatar = null;
        Lock lock = new ReentrantLock();
        Lock existingLock = this.requestingAvatarLocks.putIfAbsent(contact, lock);
        if (existingLock != null) {
            lock = existingLock;
        }
        lock.lock();
        try {
            String hash = this.userHashes.get(contact);
            if (!"".equals(hash)) {
                byte[] imageData;
                if (hash != null && (imageData = this.loadFromCache(hash)) != null) {
                    avatar = imageData;
                }
                if (avatar == null) {
                    VCard.Image image;
                    VCard vCard;
                    avatar = new byte[]{};
                    hash = "";
                    VCardManager vCardManager = (VCardManager)this.xmppSession.getManager(VCardManager.class);
                    try {
                        vCard = contact.equals((Object)this.xmppSession.getConnectedResource().asBareJid()) ? vCardManager.getVCard() : vCardManager.getVCard(contact);
                    }
                    catch (StanzaException e) {
                        vCard = null;
                    }
                    if (vCard != null && (image = vCard.getPhoto()) != null && image.getValue() != null && (hash = XmppUtils.hash((byte[])image.getValue())) != null) {
                        avatar = image.getValue();
                    }
                    this.userHashes.put(contact, hash);
                    if (!Arrays.equals(avatar, new byte[0])) {
                        this.storeToCache(hash, avatar);
                    }
                }
            }
            byte[] byArray = avatar;
            return byArray;
        }
        finally {
            lock.unlock();
            this.requestingAvatarLocks.remove(contact);
        }
    }

    private byte[] loadFromCache(String hash) {
        if (this.avatarCache != null) {
            try {
                return this.avatarCache.get(hash + ".avatar");
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Could not read avatar from cache.", e);
            }
        }
        return null;
    }

    private void storeToCache(String hash, byte[] image) {
        if (this.avatarCache != null) {
            try {
                this.avatarCache.put(hash + ".avatar", image);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Could not write avatar to cache.", e);
            }
        }
    }

    public final byte[] getAvatar(Jid contact) throws XmppException {
        return this.getAvatarByVCard(contact.asBareJid());
    }

    public final void publishAvatar(byte[] imageData) throws XmppException {
        XmppException vCardException = null;
        String hash = imageData != null ? XmppUtils.hash((byte[])imageData) : null;
        AvatarMetadata.Info info = imageData != null ? new AvatarMetadata.Info(Integer.valueOf(imageData.length), hash, hash) : null;
        try {
            this.publishToVCard(imageData, null, hash);
        }
        catch (XmppException e) {
            vCardException = e;
            logger.warning("Failed to publish avatar to vCard.");
        }
        try {
            this.publishToPersonalEventingService(imageData, hash, info);
        }
        catch (XmppException e) {
            if (vCardException != null) {
                e.addSuppressed((Throwable)vCardException);
                throw e;
            }
            logger.warning("Failed to publish avatar to PEP service.");
        }
    }

    private void publishToVCard(byte[] avatar, String type, String hash) throws XmppException {
        VCard vCard;
        try {
            vCard = this.vCardManager.getVCard();
        }
        catch (StanzaException e) {
            vCard = new VCard();
        }
        if (avatar != null) {
            if (vCard.getPhoto() == null || !Arrays.equals(vCard.getPhoto().getValue(), avatar)) {
                this.userHashes.put(this.xmppSession.getConnectedResource().asBareJid(), hash);
                vCard.setPhoto(new VCard.Image(type, avatar));
                this.vCardManager.setVCard(vCard);
            }
        } else {
            this.userHashes.put(this.xmppSession.getConnectedResource().asBareJid(), "");
            if (vCard.getPhoto() != null && vCard.getPhoto().getValue() != null) {
                vCard.setPhoto(null);
                this.vCardManager.setVCard(vCard);
            }
        }
    }

    private void publishToPersonalEventingService(byte[] avatar, String itemId, AvatarMetadata.Info info) throws XmppException {
        PubSubService personalEventingService = ((PubSubManager)this.xmppSession.getManager(PubSubManager.class)).createPersonalEventingService();
        if (avatar != null) {
            if (info.getUrl() == null) {
                personalEventingService.node("urn:xmpp:avatar:data").publish(itemId, new AvatarData(avatar));
            }
            personalEventingService.node("urn:xmpp:avatar:metadata").publish(itemId, new AvatarMetadata(new AvatarMetadata.Info[]{info}));
        } else {
            personalEventingService.node("urn:xmpp:avatar:metadata").publish(itemId, new AvatarMetadata(new AvatarMetadata.Info[0]));
        }
    }

    public final void addAvatarChangeListener(AvatarChangeListener avatarChangeListener) {
        this.avatarChangeListeners.add(avatarChangeListener);
    }

    public final void removeAvatarChangeListener(AvatarChangeListener avatarChangeListener) {
        this.avatarChangeListeners.remove(avatarChangeListener);
    }
}

