/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.blocking;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import rocks.xmpp.core.Jid;
import rocks.xmpp.core.XmppException;
import rocks.xmpp.core.session.ExtensionManager;
import rocks.xmpp.core.session.Manager;
import rocks.xmpp.core.session.SessionStatusEvent;
import rocks.xmpp.core.session.SessionStatusListener;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.AbstractIQHandler;
import rocks.xmpp.core.stanza.IQHandler;
import rocks.xmpp.core.stanza.model.AbstractIQ;
import rocks.xmpp.core.stanza.model.client.IQ;
import rocks.xmpp.core.stanza.model.errors.Condition;
import rocks.xmpp.extensions.blocking.BlockingEvent;
import rocks.xmpp.extensions.blocking.BlockingListener;
import rocks.xmpp.extensions.blocking.model.Block;
import rocks.xmpp.extensions.blocking.model.BlockList;
import rocks.xmpp.extensions.blocking.model.Unblock;

public final class BlockingManager
extends ExtensionManager {
    private static final Logger logger = Logger.getLogger(BlockingManager.class.getName());
    private final Set<Jid> blockedContacts = new HashSet<Jid>();
    private final Set<BlockingListener> blockingListeners = new CopyOnWriteArraySet<BlockingListener>();

    private BlockingManager(XmppSession xmppSession) {
        super(xmppSession, new String[0]);
    }

    protected final void initialize() {
        this.xmppSession.addSessionStatusListener(new SessionStatusListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void sessionStatusChanged(SessionStatusEvent e) {
                if (e.getStatus() == XmppSession.Status.CLOSED) {
                    BlockingManager.this.blockingListeners.clear();
                    Set set = BlockingManager.this.blockedContacts;
                    synchronized (set) {
                        BlockingManager.this.blockedContacts.clear();
                    }
                }
            }
        });
        AbstractIQHandler iqHandler = new AbstractIQHandler((Manager)this, AbstractIQ.Type.SET){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected IQ processRequest(IQ iq) {
                if (iq.getFrom() == null || iq.getFrom().equals((Object)BlockingManager.this.xmppSession.getConnectedResource().asBareJid())) {
                    Block block = (Block)iq.getExtension(Block.class);
                    if (block != null) {
                        ArrayList<Jid> pushedContacts = new ArrayList<Jid>();
                        Set set = BlockingManager.this.blockedContacts;
                        synchronized (set) {
                            for (Jid item : block.getItems()) {
                                BlockingManager.this.blockedContacts.add(item);
                                pushedContacts.add(item);
                            }
                        }
                        BlockingManager.this.notifyListeners(pushedContacts, Collections.emptyList());
                        return iq.createResult();
                    }
                    Unblock unblock = (Unblock)iq.getExtension(Unblock.class);
                    if (unblock != null) {
                        ArrayList<Jid> pushedContacts = new ArrayList<Jid>();
                        Set set = BlockingManager.this.blockedContacts;
                        synchronized (set) {
                            if (unblock.getItems().isEmpty()) {
                                pushedContacts.addAll(BlockingManager.this.blockedContacts);
                                BlockingManager.this.blockedContacts.clear();
                            } else {
                                for (Jid item : unblock.getItems()) {
                                    BlockingManager.this.blockedContacts.remove(item);
                                    pushedContacts.add(item);
                                }
                            }
                        }
                        BlockingManager.this.notifyListeners(Collections.emptyList(), pushedContacts);
                        return iq.createResult();
                    }
                }
                return iq.createError(Condition.NOT_ACCEPTABLE);
            }
        };
        this.xmppSession.addIQHandler(Block.class, (IQHandler)iqHandler, false);
        this.xmppSession.addIQHandler(Unblock.class, (IQHandler)iqHandler, false);
    }

    private void notifyListeners(List<Jid> blockedContacts, List<Jid> unblockedContacts) {
        BlockingEvent blockingEvent = new BlockingEvent((Object)this, blockedContacts, unblockedContacts);
        for (BlockingListener blockingListener : this.blockingListeners) {
            try {
                blockingListener.blockListChanged(blockingEvent);
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, ex.getMessage(), ex);
            }
        }
    }

    public final void addBlockingListener(BlockingListener blockingListener) {
        this.blockingListeners.add(blockingListener);
    }

    public final void removeBlockingListener(BlockingListener blockingListener) {
        this.blockingListeners.remove(blockingListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Collection<Jid> getBlockedContacts() throws XmppException {
        Set<Jid> set = this.blockedContacts;
        synchronized (set) {
            IQ result = this.xmppSession.query(new IQ(AbstractIQ.Type.GET, (Object)new BlockList()));
            BlockList blockList = (BlockList)result.getExtension(BlockList.class);
            if (blockList != null) {
                for (Jid item : blockList.getItems()) {
                    this.blockedContacts.add(item);
                }
            }
            return this.blockedContacts;
        }
    }

    public final void blockContact(Jid ... jids) throws XmppException {
        ArrayList items = new ArrayList();
        Collections.addAll(items, jids);
        this.xmppSession.query(new IQ(AbstractIQ.Type.SET, (Object)new Block(items)));
    }

    public final void unblockContact(Jid ... jids) throws XmppException {
        ArrayList items = new ArrayList();
        Collections.addAll(items, jids);
        this.xmppSession.query(new IQ(AbstractIQ.Type.SET, (Object)new Unblock(items)));
    }
}

