/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.bob;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import rocks.xmpp.core.Jid;
import rocks.xmpp.core.XmppException;
import rocks.xmpp.core.session.ExtensionManager;
import rocks.xmpp.core.session.Manager;
import rocks.xmpp.core.session.SessionStatusEvent;
import rocks.xmpp.core.session.SessionStatusListener;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.AbstractIQHandler;
import rocks.xmpp.core.stanza.IQHandler;
import rocks.xmpp.core.stanza.model.AbstractIQ;
import rocks.xmpp.core.stanza.model.client.IQ;
import rocks.xmpp.core.stanza.model.errors.Condition;
import rocks.xmpp.extensions.bob.model.Data;

class BitsOfBinaryManager
extends ExtensionManager {
    private final Map<String, Data> dataCache = new ConcurrentHashMap<String, Data>();

    private BitsOfBinaryManager(XmppSession xmppSession) {
        super(xmppSession, new String[]{"urn:xmpp:bob"});
    }

    protected void initialize() {
        this.xmppSession.addSessionStatusListener(new SessionStatusListener(){

            public void sessionStatusChanged(SessionStatusEvent e) {
                if (e.getStatus() == XmppSession.Status.CLOSED) {
                    BitsOfBinaryManager.this.dataCache.clear();
                }
            }
        });
        this.xmppSession.addIQHandler(Data.class, (IQHandler)new AbstractIQHandler((Manager)this, AbstractIQ.Type.GET){

            protected IQ processRequest(IQ iq) {
                Data data = (Data)iq.getExtension(Data.class);
                Data cachedData = (Data)BitsOfBinaryManager.this.dataCache.get(data.getContentId());
                if (cachedData != null) {
                    return iq.createResult((Object)cachedData);
                }
                return iq.createError(Condition.ITEM_NOT_FOUND);
            }
        });
    }

    public Data getData(String contentId, Jid to) throws XmppException {
        IQ result = this.xmppSession.query(new IQ(to, AbstractIQ.Type.GET, (Object)new Data(contentId)));
        Data data = (Data)result.getExtension(Data.class);
        return data;
    }

    public void put(Data data) {
        this.dataCache.put(data.getContentId(), data);
    }
}

