/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.bytestreams;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import rocks.xmpp.core.session.ExtensionManager;
import rocks.xmpp.core.session.SessionStatusEvent;
import rocks.xmpp.core.session.SessionStatusListener;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.extensions.bytestreams.ByteStreamEvent;
import rocks.xmpp.extensions.bytestreams.ByteStreamListener;

public abstract class ByteStreamManager
extends ExtensionManager {
    private static final Logger logger = Logger.getLogger(ByteStreamManager.class.getName());
    private final Set<ByteStreamListener> byteStreamListeners = new CopyOnWriteArraySet<ByteStreamListener>();

    protected ByteStreamManager(XmppSession xmppSession, String ... features) {
        super(xmppSession, features);
    }

    protected void initialize() {
        this.xmppSession.addSessionStatusListener(new SessionStatusListener(){

            public void sessionStatusChanged(SessionStatusEvent e) {
                if (e.getStatus() == XmppSession.Status.CLOSED) {
                    ByteStreamManager.this.byteStreamListeners.clear();
                }
            }
        });
    }

    public final void addByteStreamListener(ByteStreamListener byteStreamListener) {
        this.byteStreamListeners.add(byteStreamListener);
    }

    public final void removeByteStreamListener(ByteStreamListener byteStreamListener) {
        this.byteStreamListeners.remove(byteStreamListener);
    }

    protected final void notifyByteStreamEvent(ByteStreamEvent byteStreamEvent) {
        for (ByteStreamListener byteStreamListener : this.byteStreamListeners) {
            try {
                byteStreamListener.byteStreamRequested(byteStreamEvent);
            }
            catch (Exception exc) {
                logger.log(Level.WARNING, exc.getMessage(), exc);
            }
        }
    }
}

