/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.bytestreams.ibb;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import rocks.xmpp.core.Jid;
import rocks.xmpp.core.XmppException;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.model.AbstractIQ;
import rocks.xmpp.core.stanza.model.client.IQ;
import rocks.xmpp.extensions.bytestreams.ByteStreamSession;
import rocks.xmpp.extensions.bytestreams.ibb.IbbInputStream;
import rocks.xmpp.extensions.bytestreams.ibb.IbbOutputStream;
import rocks.xmpp.extensions.bytestreams.ibb.InBandByteStreamManager;
import rocks.xmpp.extensions.bytestreams.ibb.model.InBandByteStream;

final class IbbSession
extends ByteStreamSession {
    private final IbbOutputStream outputStream;
    private final IbbInputStream inputStream;
    private final Jid jid;
    private final int blockSize;
    private final XmppSession xmppSession;
    private final InBandByteStreamManager inBandByteStreamManager;
    private int inboundSequence = 0;
    private int outboundSequence = 0;
    private boolean closed;

    IbbSession(String sessionId, XmppSession xmppSession, Jid jid, int blockSize, InBandByteStreamManager manager) {
        super(sessionId);
        this.outputStream = new IbbOutputStream(this, blockSize);
        this.inputStream = new IbbInputStream(this);
        this.jid = jid;
        this.xmppSession = xmppSession;
        this.blockSize = blockSize;
        this.inBandByteStreamManager = manager;
    }

    final synchronized boolean dataReceived(InBandByteStream.Data data) {
        if (this.inboundSequence++ == data.getSequence()) {
            this.inputStream.queue.offer(data);
            return true;
        }
        return false;
    }

    final void open() throws XmppException {
        this.xmppSession.query(new IQ(this.jid, AbstractIQ.Type.SET, (Object)new InBandByteStream.Open(this.blockSize, this.getSessionId())));
    }

    @Override
    public final synchronized OutputStream getOutputStream() throws IOException {
        if (this.closed) {
            throw new IOException("IBB session is closed.");
        }
        return this.outputStream;
    }

    @Override
    public final synchronized InputStream getInputStream() throws IOException {
        if (this.closed) {
            throw new IOException("IBB session is closed.");
        }
        return this.inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int getReadTimeout() {
        IbbInputStream ibbInputStream = this.inputStream;
        synchronized (ibbInputStream) {
            return this.inputStream.readTimeout;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setReadTimeout(int readTimeout) {
        IbbInputStream ibbInputStream = this.inputStream;
        synchronized (ibbInputStream) {
            this.inputStream.readTimeout = readTimeout;
        }
    }

    final void send(byte[] bytes) throws XmppException {
        this.xmppSession.query(new IQ(this.jid, AbstractIQ.Type.SET, (Object)new InBandByteStream.Data(bytes, this.getSessionId(), this.outboundSequence)));
        if (++this.outboundSequence > 65535) {
            this.outboundSequence = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() throws Exception {
        IbbSession ibbSession = this;
        synchronized (ibbSession) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        try {
            this.inputStream.close();
            this.outputStream.close();
            this.xmppSession.query(new IQ(this.jid, AbstractIQ.Type.SET, (Object)new InBandByteStream.Close(this.getSessionId())));
        }
        finally {
            this.inBandByteStreamManager.ibbSessionMap.remove(this.getSessionId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void closedByPeer() throws IOException {
        IbbSession ibbSession = this;
        synchronized (ibbSession) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        this.inputStream.close();
        this.outputStream.close();
    }

    public final String toString() {
        return "In-Band Bytestream Session: " + this.getSessionId();
    }
}

