/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.bytestreams.ibb;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import rocks.xmpp.core.Jid;
import rocks.xmpp.core.XmppException;
import rocks.xmpp.core.session.Manager;
import rocks.xmpp.core.session.SessionStatusEvent;
import rocks.xmpp.core.session.SessionStatusListener;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.AbstractIQHandler;
import rocks.xmpp.core.stanza.IQHandler;
import rocks.xmpp.core.stanza.MessageEvent;
import rocks.xmpp.core.stanza.MessageListener;
import rocks.xmpp.core.stanza.model.AbstractIQ;
import rocks.xmpp.core.stanza.model.StanzaError;
import rocks.xmpp.core.stanza.model.client.IQ;
import rocks.xmpp.core.stanza.model.errors.Condition;
import rocks.xmpp.core.stream.model.ClientStreamElement;
import rocks.xmpp.extensions.bytestreams.ByteStreamManager;
import rocks.xmpp.extensions.bytestreams.ByteStreamSession;
import rocks.xmpp.extensions.bytestreams.ibb.IbbEvent;
import rocks.xmpp.extensions.bytestreams.ibb.IbbSession;
import rocks.xmpp.extensions.bytestreams.ibb.model.InBandByteStream;

public final class InBandByteStreamManager
extends ByteStreamManager {
    private static final Logger logger = Logger.getLogger(InBandByteStreamManager.class.getName());
    final Map<String, IbbSession> ibbSessionMap = new ConcurrentHashMap<String, IbbSession>();

    private InBandByteStreamManager(XmppSession xmppSession) {
        super(xmppSession, "http://jabber.org/protocol/ibb");
        this.setEnabled(true);
    }

    @Override
    protected final void initialize() {
        super.initialize();
        this.xmppSession.addIQHandler(InBandByteStream.Open.class, (IQHandler)new AbstractIQHandler((Manager)this, AbstractIQ.Type.SET){

            protected IQ processRequest(IQ iq) {
                InBandByteStream.Open open = (InBandByteStream.Open)iq.getExtension(InBandByteStream.Open.class);
                if (open.getBlockSize() > 65535) {
                    return iq.createError(new StanzaError(StanzaError.Type.MODIFY, Condition.RESOURCE_CONSTRAINT));
                }
                InBandByteStreamManager.this.notifyByteStreamEvent(new IbbEvent((Object)InBandByteStreamManager.this, open.getSessionId(), InBandByteStreamManager.this.xmppSession, iq, open.getBlockSize()));
                return null;
            }
        }, false);
        this.xmppSession.addIQHandler(InBandByteStream.Data.class, (IQHandler)new AbstractIQHandler((Manager)this, AbstractIQ.Type.SET){

            protected IQ processRequest(IQ iq) {
                InBandByteStream.Data data = (InBandByteStream.Data)iq.getExtension(InBandByteStream.Data.class);
                IbbSession ibbSession = InBandByteStreamManager.this.ibbSessionMap.get(data.getSessionId());
                if (ibbSession != null) {
                    if (ibbSession.dataReceived(data)) {
                        return iq.createResult();
                    }
                    return iq.createError(new StanzaError(StanzaError.Type.CANCEL, Condition.UNEXPECTED_REQUEST));
                }
                return iq.createError(Condition.ITEM_NOT_FOUND);
            }
        }, false);
        this.xmppSession.addIQHandler(InBandByteStream.Close.class, (IQHandler)new AbstractIQHandler((Manager)this, AbstractIQ.Type.SET){

            protected IQ processRequest(IQ iq) {
                InBandByteStream.Close close = (InBandByteStream.Close)iq.getExtension(InBandByteStream.Close.class);
                IbbSession ibbSession = InBandByteStreamManager.this.ibbSessionMap.get(close.getSessionId());
                if (ibbSession != null) {
                    try {
                        InBandByteStreamManager.this.ibbSessionMap.remove(close.getSessionId());
                        ibbSession.closedByPeer();
                        return iq.createResult();
                    }
                    catch (IOException e1) {
                        logger.log(Level.WARNING, e1.getMessage(), e1);
                        return iq.createResult();
                    }
                }
                return iq.createError(Condition.ITEM_NOT_FOUND);
            }
        }, false);
        this.xmppSession.addInboundMessageListener(new MessageListener(){

            public void handleMessage(MessageEvent e) {
                InBandByteStream.Data data;
                if (InBandByteStreamManager.this.isEnabled() && (data = (InBandByteStream.Data)e.getMessage().getExtension(InBandByteStream.Data.class)) != null) {
                    IbbSession ibbSession = InBandByteStreamManager.this.ibbSessionMap.get(data.getSessionId());
                    if (ibbSession != null) {
                        if (!ibbSession.dataReceived(data)) {
                            InBandByteStreamManager.this.xmppSession.send((ClientStreamElement)e.getMessage().createError(new StanzaError(StanzaError.Type.CANCEL, Condition.UNEXPECTED_REQUEST)));
                        }
                    } else {
                        InBandByteStreamManager.this.xmppSession.send((ClientStreamElement)e.getMessage().createError(Condition.ITEM_NOT_FOUND));
                    }
                }
            }
        });
        this.xmppSession.addSessionStatusListener(new SessionStatusListener(){

            public void sessionStatusChanged(SessionStatusEvent e) {
                if (e.getStatus() == XmppSession.Status.CLOSED) {
                    InBandByteStreamManager.this.ibbSessionMap.clear();
                }
            }
        });
    }

    IbbSession createSession(Jid receiver, String sessionId, int blockSize) {
        IbbSession ibbSession = new IbbSession(sessionId, this.xmppSession, receiver, blockSize, this);
        this.ibbSessionMap.put(ibbSession.getSessionId(), ibbSession);
        return ibbSession;
    }

    public final ByteStreamSession initiateSession(Jid receiver, String sessionId, int blockSize) throws XmppException {
        if (blockSize > 65535) {
            throw new IllegalArgumentException("blockSize must not be greater than 65535.");
        }
        IbbSession ibbSession = this.createSession(receiver, sessionId, blockSize);
        ibbSession.open();
        return ibbSession;
    }
}

