/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.bytestreams.s5b;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import rocks.xmpp.core.Jid;
import rocks.xmpp.core.XmppException;
import rocks.xmpp.core.XmppUtils;
import rocks.xmpp.core.session.Manager;
import rocks.xmpp.core.session.SessionStatusEvent;
import rocks.xmpp.core.session.SessionStatusListener;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.AbstractIQHandler;
import rocks.xmpp.core.stanza.IQHandler;
import rocks.xmpp.core.stanza.model.AbstractIQ;
import rocks.xmpp.core.stanza.model.client.IQ;
import rocks.xmpp.core.stanza.model.errors.Condition;
import rocks.xmpp.extensions.bytestreams.ByteStreamManager;
import rocks.xmpp.extensions.bytestreams.ByteStreamSession;
import rocks.xmpp.extensions.bytestreams.s5b.LocalSocks5Server;
import rocks.xmpp.extensions.bytestreams.s5b.S5bEvent;
import rocks.xmpp.extensions.bytestreams.s5b.S5bSession;
import rocks.xmpp.extensions.bytestreams.s5b.Socks5Protocol;
import rocks.xmpp.extensions.bytestreams.s5b.model.Socks5ByteStream;
import rocks.xmpp.extensions.bytestreams.s5b.model.StreamHost;
import rocks.xmpp.extensions.disco.ServiceDiscoveryManager;
import rocks.xmpp.extensions.disco.model.items.Item;

public final class Socks5ByteStreamManager
extends ByteStreamManager {
    private final ServiceDiscoveryManager serviceDiscoveryManager;
    private final LocalSocks5Server localSocks5Server;
    private boolean localHostEnabled;

    private Socks5ByteStreamManager(XmppSession xmppSession) {
        super(xmppSession, "http://jabber.org/protocol/bytestreams");
        this.serviceDiscoveryManager = (ServiceDiscoveryManager)xmppSession.getManager(ServiceDiscoveryManager.class);
        this.localSocks5Server = new LocalSocks5Server();
        this.setEnabled(true);
    }

    static S5bSession createS5bSession(Jid requester, Jid target, String sessionId, List<StreamHost> streamHosts) throws IOException {
        Socket socketUsed = null;
        Jid streamHostUsed = null;
        IOException ioException = null;
        for (StreamHost streamHost : streamHosts) {
            try {
                Socket socket = new Socket();
                socket.connect(new InetSocketAddress(streamHost.getHost(), streamHost.getPort()));
                Socks5Protocol.establishClientConnection(socket, XmppUtils.hash((byte[])(sessionId + requester.toEscapedString() + target.toEscapedString()).getBytes()), 0);
                socketUsed = socket;
                streamHostUsed = streamHost.getJid();
                break;
            }
            catch (IOException e) {
                ioException = e;
            }
        }
        if (streamHostUsed == null) {
            throw new IOException("Unable to connect to any stream host.", ioException);
        }
        return new S5bSession(sessionId, socketUsed, streamHostUsed);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.xmppSession.addIQHandler(Socks5ByteStream.class, (IQHandler)new AbstractIQHandler((Manager)this, AbstractIQ.Type.SET){

            protected IQ processRequest(IQ iq) {
                Socks5ByteStream socks5ByteStream = (Socks5ByteStream)iq.getExtension(Socks5ByteStream.class);
                if (socks5ByteStream.getSessionId() == null) {
                    return iq.createError(Condition.BAD_REQUEST);
                }
                Socks5ByteStreamManager.this.notifyByteStreamEvent(new S5bEvent((Object)Socks5ByteStreamManager.this, socks5ByteStream.getSessionId(), Socks5ByteStreamManager.this.xmppSession, iq, socks5ByteStream.getStreamHosts()));
                return null;
            }
        });
        this.xmppSession.addSessionStatusListener(new SessionStatusListener(){

            public void sessionStatusChanged(SessionStatusEvent e) {
                if (e.getStatus() == XmppSession.Status.CLOSED) {
                    Socks5ByteStreamManager.this.localSocks5Server.stop();
                }
            }
        });
    }

    public synchronized boolean isLocalHostEnabled() {
        return this.localHostEnabled;
    }

    public synchronized void setLocalHostEnabled(boolean enabled) {
        this.localHostEnabled = enabled;
        if (!enabled) {
            this.localSocks5Server.stop();
        }
    }

    public int getPort() {
        return this.localSocks5Server.getPort();
    }

    public void setPort(int port) {
        this.localSocks5Server.setPort(port);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (!enabled || !this.isLocalHostEnabled()) {
            this.localSocks5Server.stop();
        }
    }

    public List<StreamHost> discoverProxies() throws XmppException {
        Collection services = this.serviceDiscoveryManager.discoverServices("http://jabber.org/protocol/bytestreams");
        for (Item service : services) {
            IQ result = this.xmppSession.query(new IQ(service.getJid(), AbstractIQ.Type.GET, (Object)new Socks5ByteStream()));
            Socks5ByteStream socks5ByteStream = (Socks5ByteStream)result.getExtension(Socks5ByteStream.class);
            if (socks5ByteStream == null) continue;
            return socks5ByteStream.getStreamHosts();
        }
        return Collections.emptyList();
    }

    public List<StreamHost> getAvailableStreamHosts() throws IOException {
        ArrayList<StreamHost> streamHosts = new ArrayList<StreamHost>();
        if (this.isLocalHostEnabled()) {
            Jid requester = this.xmppSession.getConnectedResource();
            streamHosts.add(new StreamHost(requester, this.localSocks5Server.getAddress(), this.localSocks5Server.getPort()));
        }
        XmppException xmppException = null;
        try {
            streamHosts.addAll(this.discoverProxies());
        }
        catch (XmppException e) {
            xmppException = e;
        }
        if (streamHosts.isEmpty()) {
            throw new IOException("No stream hosts found.", xmppException);
        }
        return streamHosts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteStreamSession initiateSession(Jid target, String sessionId) throws XmppException, IOException {
        if (this.isLocalHostEnabled()) {
            this.localSocks5Server.start();
        }
        List<StreamHost> streamHosts = this.getAvailableStreamHosts();
        Jid requester = this.xmppSession.getConnectedResource();
        String hash = XmppUtils.hash((byte[])(sessionId + requester.toEscapedString() + target.toEscapedString()).getBytes());
        this.localSocks5Server.allowedAddresses.add(hash);
        try {
            Socket socket;
            IQ result = this.xmppSession.query(new IQ(target, AbstractIQ.Type.SET, (Object)new Socks5ByteStream(sessionId, streamHosts, hash)));
            Socks5ByteStream socks5ByteStream = (Socks5ByteStream)result.getExtension(Socks5ByteStream.class);
            StreamHost usedStreamHost = null;
            for (StreamHost streamHost : streamHosts) {
                if (socks5ByteStream.getStreamHostUsed() == null || !socks5ByteStream.getStreamHostUsed().equals((Object)streamHost.getJid())) continue;
                usedStreamHost = streamHost;
                break;
            }
            if (usedStreamHost == null) {
                throw new IOException("Target did not respond with a stream host.");
            }
            if (!usedStreamHost.getJid().equals((Object)requester)) {
                socket = new Socket();
                socket.connect(new InetSocketAddress(usedStreamHost.getHost(), usedStreamHost.getPort()));
                Socks5Protocol.establishClientConnection(socket, hash, 0);
                this.xmppSession.query(new IQ(usedStreamHost.getJid(), AbstractIQ.Type.SET, (Object)Socks5ByteStream.activate((String)sessionId, (Jid)target)));
            } else {
                socket = this.localSocks5Server.getSocket(hash);
            }
            if (socket == null) {
                throw new IOException("Not connected to stream host");
            }
            S5bSession s5bSession = new S5bSession(sessionId, socket, usedStreamHost.getJid());
            return s5bSession;
        }
        finally {
            this.localSocks5Server.removeConnection(hash);
        }
    }
}

