/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.caps;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import rocks.xmpp.core.Jid;
import rocks.xmpp.core.XmppException;
import rocks.xmpp.core.XmppUtils;
import rocks.xmpp.core.session.ExtensionManager;
import rocks.xmpp.core.session.SessionStatusEvent;
import rocks.xmpp.core.session.SessionStatusListener;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.PresenceEvent;
import rocks.xmpp.core.stanza.PresenceListener;
import rocks.xmpp.core.stanza.model.client.Presence;
import rocks.xmpp.core.stream.StreamFeaturesManager;
import rocks.xmpp.core.stream.model.ClientStreamElement;
import rocks.xmpp.core.subscription.PresenceManager;
import rocks.xmpp.core.util.cache.DirectoryCache;
import rocks.xmpp.core.util.cache.LruCache;
import rocks.xmpp.extensions.caps.model.EntityCapabilities;
import rocks.xmpp.extensions.data.model.DataForm;
import rocks.xmpp.extensions.disco.ServiceDiscoveryManager;
import rocks.xmpp.extensions.disco.model.info.Feature;
import rocks.xmpp.extensions.disco.model.info.Identity;
import rocks.xmpp.extensions.disco.model.info.InfoDiscovery;
import rocks.xmpp.extensions.disco.model.info.InfoNode;

public final class EntityCapabilitiesManager
extends ExtensionManager {
    private static final Logger logger = Logger.getLogger(EntityCapabilitiesManager.class.getName());
    private static final String DEFAULT_NODE = "http://xmpp.rocks";
    private static final String HASH_ALGORITHM = "sha-1";
    private static final Map<Verification, InfoNode> CAPS_CACHE = new LruCache(100);
    private static final Map<Jid, InfoNode> ENTITY_CAPABILITIES = new ConcurrentHashMap<Jid, InfoNode>();
    private static final ConcurrentHashMap<Jid, Lock> REQUESTING_LOCKS = new ConcurrentHashMap();
    private final ServiceDiscoveryManager serviceDiscoveryManager;
    private final ExecutorService serviceDiscoverer;
    private final Map<String, Verification> publishedNodes;
    private final DirectoryCache directoryCapsCache;
    private boolean capsSent;
    private String node;

    private EntityCapabilitiesManager(XmppSession xmppSession) {
        super(xmppSession, new String[]{"http://jabber.org/protocol/caps"});
        this.serviceDiscoveryManager = (ServiceDiscoveryManager)xmppSession.getManager(ServiceDiscoveryManager.class);
        this.directoryCapsCache = xmppSession.getConfiguration().getCacheDirectory() != null ? new DirectoryCache(xmppSession.getConfiguration().getCacheDirectory().resolve("caps")) : null;
        this.serviceDiscoverer = Executors.newSingleThreadExecutor(XmppUtils.createNamedThreadFactory((String)"Automatic Service Discovery Thread"));
        this.publishedNodes = new LinkedHashMap<String, Verification>(10, 0.75f, false){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, Verification> eldest) {
                if (this.size() > 10) {
                    EntityCapabilitiesManager.this.serviceDiscoveryManager.removeInfoNode(eldest.getKey());
                    return true;
                }
                return false;
            }
        };
        this.setEnabled(true);
    }

    protected void initialize() {
        this.serviceDiscoveryManager.addPropertyChangeListener(new PropertyChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ServiceDiscoveryManager serviceDiscoveryManager = EntityCapabilitiesManager.this.serviceDiscoveryManager;
                synchronized (serviceDiscoveryManager) {
                    if (EntityCapabilitiesManager.this.capsSent) {
                        EntityCapabilitiesManager.this.publishCapsNode();
                        PresenceManager presenceManager = (PresenceManager)EntityCapabilitiesManager.this.xmppSession.getManager(PresenceManager.class);
                        Presence lastPresence = presenceManager.getLastSentPresence();
                        EntityCapabilitiesManager.this.xmppSession.send((ClientStreamElement)new Presence(null, lastPresence.getType(), lastPresence.getShow(), (Collection)lastPresence.getStatuses(), lastPresence.getPriority(), null, null, lastPresence.getLanguage(), null, null));
                    }
                }
            }
        });
        this.xmppSession.addSessionStatusListener(new SessionStatusListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void sessionStatusChanged(SessionStatusEvent e) {
                switch (e.getStatus()) {
                    case AUTHENTICATED: {
                        EntityCapabilities serverCapabilities = (EntityCapabilities)((StreamFeaturesManager)EntityCapabilitiesManager.this.xmppSession.getManager(StreamFeaturesManager.class)).getFeatures().get(EntityCapabilities.class);
                        if (serverCapabilities == null) break;
                        EntityCapabilitiesManager.this.handleEntityCaps(serverCapabilities, Jid.valueOf((String)EntityCapabilitiesManager.this.xmppSession.getDomain()));
                        break;
                    }
                    case CLOSED: {
                        ExecutorService executorService = EntityCapabilitiesManager.this.serviceDiscoverer;
                        synchronized (executorService) {
                            EntityCapabilitiesManager.this.serviceDiscoverer.shutdown();
                            break;
                        }
                    }
                }
            }
        });
        this.xmppSession.addInboundPresenceListener(new PresenceListener(){

            public void handlePresence(PresenceEvent e) {
                EntityCapabilities entityCapabilities;
                Presence presence;
                if (EntityCapabilitiesManager.this.isEnabled() && !(presence = e.getPresence()).getFrom().equals((Object)EntityCapabilitiesManager.this.xmppSession.getConnectedResource()) && (entityCapabilities = (EntityCapabilities)presence.getExtension(EntityCapabilities.class)) != null) {
                    EntityCapabilitiesManager.this.handleEntityCaps(entityCapabilities, presence.getFrom());
                }
            }
        });
        this.xmppSession.addOutboundPresenceListener(new PresenceListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handlePresence(PresenceEvent e) {
                Presence presence;
                if (EntityCapabilitiesManager.this.isEnabled() && (presence = e.getPresence()).isAvailable() && presence.getTo() == null) {
                    ServiceDiscoveryManager serviceDiscoveryManager = EntityCapabilitiesManager.this.serviceDiscoveryManager;
                    synchronized (serviceDiscoveryManager) {
                        if (EntityCapabilitiesManager.this.publishedNodes.isEmpty()) {
                            EntityCapabilitiesManager.this.publishCapsNode();
                        }
                        ArrayList verifications = new ArrayList(EntityCapabilitiesManager.this.publishedNodes.values());
                        Verification verification = (Verification)verifications.get(verifications.size() - 1);
                        presence.getExtensions().add(new EntityCapabilities(EntityCapabilitiesManager.this.getNode(), verification.hashAlgorithm, verification.verificationString));
                        EntityCapabilitiesManager.this.capsSent = true;
                    }
                }
            }
        });
    }

    private void publishCapsNode() {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(HASH_ALGORITHM);
            final InfoDiscovery infoDiscovery = new InfoDiscovery((Collection)this.serviceDiscoveryManager.getIdentities(), (Collection)this.serviceDiscoveryManager.getFeatures(), (Collection)this.serviceDiscoveryManager.getExtensions());
            Verification verification = new Verification(HASH_ALGORITHM, EntityCapabilities.getVerificationString((InfoNode)infoDiscovery, (MessageDigest)messageDigest));
            this.writeToCache(verification, (InfoNode)infoDiscovery);
            final String node = this.getNode() + "#" + verification.verificationString;
            this.publishedNodes.put(node, verification);
            this.serviceDiscoveryManager.addInfoNode(new InfoNode(){

                public String getNode() {
                    return node;
                }

                public Set<Identity> getIdentities() {
                    return infoDiscovery.getIdentities();
                }

                public Set<Feature> getFeatures() {
                    return infoDiscovery.getFeatures();
                }

                public List<DataForm> getExtensions() {
                    return infoDiscovery.getExtensions();
                }
            });
        }
        catch (NoSuchAlgorithmException e) {
            logger.log(Level.WARNING, e.getMessage(), e);
        }
    }

    public synchronized String getNode() {
        return this.node != null ? this.node : DEFAULT_NODE;
    }

    public synchronized void setNode(String node) {
        this.node = node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final InfoNode discoverCapabilities(Jid jid) throws XmppException {
        InfoNode infoNode = ENTITY_CAPABILITIES.get(jid);
        if (infoNode == null) {
            Lock lock = new ReentrantLock();
            Lock existingLock = REQUESTING_LOCKS.putIfAbsent(jid, lock);
            if (existingLock != null) {
                lock = existingLock;
            }
            lock.lock();
            infoNode = ENTITY_CAPABILITIES.get(jid);
            if (infoNode != null) {
                return infoNode;
            }
            try {
                infoNode = this.serviceDiscoveryManager.discoverInformation(jid);
                ENTITY_CAPABILITIES.put(jid, infoNode);
            }
            finally {
                lock.unlock();
                REQUESTING_LOCKS.remove(jid);
            }
        }
        return infoNode;
    }

    @Deprecated
    public final InfoNode getCapabilities(Jid jid) throws XmppException {
        return this.discoverCapabilities(jid);
    }

    public final boolean isSupported(String feature, Jid jid) throws XmppException {
        InfoNode infoNode = this.discoverCapabilities(jid);
        return infoNode.getFeatures().contains(new Feature(feature));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToCache(Verification verification, InfoNode infoNode) {
        if (this.directoryCapsCache != null) {
            CAPS_CACHE.put(verification, infoNode);
            try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
                try (XMLStreamWriter xmppStreamWriter = null;){
                    xmppStreamWriter = XmppUtils.createXmppStreamWriter((XMLStreamWriter)XMLOutputFactory.newFactory().createXMLStreamWriter(byteArrayOutputStream), (boolean)true);
                    xmppStreamWriter.flush();
                    this.xmppSession.createMarshaller().marshal((Object)infoNode, xmppStreamWriter);
                }
                this.directoryCapsCache.put(XmppUtils.hash((byte[])verification.toString().getBytes()) + ".caps", byteArrayOutputStream.toByteArray());
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Could not write entity capabilities to persistent cache. Reason: " + e.getMessage(), e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private InfoNode readFromCache(Verification verification) {
        if (this.directoryCapsCache == null) return null;
        InfoNode infoNode2 = CAPS_CACHE.get(verification);
        if (infoNode2 != null) {
            return infoNode2;
        }
        String fileName = XmppUtils.hash((byte[])verification.toString().getBytes()) + ".caps";
        try {
            byte[] bytes = this.directoryCapsCache.get((Object)fileName);
            if (bytes == null) return null;
            try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);){
                infoNode2 = (InfoNode)this.xmppSession.createUnmarshaller().unmarshal((InputStream)byteArrayInputStream);
                CAPS_CACHE.put(verification, infoNode2);
                InfoNode infoNode = infoNode2;
                return infoNode;
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Could not read entity capabilities from persistent cache (file: " + fileName + ")", e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleEntityCaps(final EntityCapabilities entityCapabilities, final Jid entity) {
        Verification verification = new Verification(entityCapabilities.getHashingAlgorithm(), entityCapabilities.getVerificationString());
        InfoNode infoNode = this.readFromCache(verification);
        if (entityCapabilities.getHashingAlgorithm() != null && infoNode != null) {
            ENTITY_CAPABILITIES.put(entity, infoNode);
        } else {
            final String hashAlgorithm = entityCapabilities.getHashingAlgorithm();
            if (hashAlgorithm != null) {
                ExecutorService executorService = this.serviceDiscoverer;
                synchronized (executorService) {
                    if (!this.serviceDiscoverer.isShutdown()) {
                        this.serviceDiscoverer.execute(new Runnable(){

                            @Override
                            public void run() {
                                String node = entityCapabilities.getNode() + "#" + entityCapabilities.getVerificationString();
                                try {
                                    MessageDigest messageDigest = MessageDigest.getInstance(entityCapabilities.getHashingAlgorithm());
                                    InfoNode infoDiscovery = EntityCapabilitiesManager.this.serviceDiscoveryManager.discoverInformation(entity, node);
                                    ArrayList<String> ftValues = new ArrayList<String>();
                                    for (DataForm dataForm : infoDiscovery.getExtensions()) {
                                        DataForm.Field formType = dataForm.findField("FORM_TYPE");
                                        if (formType == null || formType.getType() != DataForm.Field.Type.HIDDEN || formType.getValues().isEmpty()) continue;
                                        ArrayList<String> values = new ArrayList<String>();
                                        for (String value : formType.getValues()) {
                                            if (values.contains(value)) {
                                                return;
                                            }
                                            values.add(value);
                                        }
                                        String value = (String)formType.getValues().get(0);
                                        if (ftValues.contains(value)) {
                                            return;
                                        }
                                        ftValues.add(value);
                                    }
                                    String verificationString = EntityCapabilities.getVerificationString((InfoNode)infoDiscovery, (MessageDigest)messageDigest);
                                    if (verificationString.equals(entityCapabilities.getVerificationString())) {
                                        EntityCapabilitiesManager.this.writeToCache(new Verification(hashAlgorithm, verificationString), infoDiscovery);
                                    }
                                    ENTITY_CAPABILITIES.put(entity, infoDiscovery);
                                }
                                catch (XmppException e1) {
                                    logger.log(Level.WARNING, String.format("Failed to discover information for entity '%s' for node '%s'", entity, node));
                                }
                                catch (NoSuchAlgorithmException e1) {
                                    try {
                                        InfoNode infoNode = EntityCapabilitiesManager.this.serviceDiscoveryManager.discoverInformation(entity, node);
                                        ENTITY_CAPABILITIES.put(entity, infoNode);
                                    }
                                    catch (XmppException e2) {
                                        logger.log(Level.WARNING, String.format("Failed to discover information for entity '%s' for node '%s'", entity, node));
                                    }
                                }
                            }
                        });
                    }
                }
            }
        }
    }

    private static final class Verification {
        private final String hashAlgorithm;
        private final String verificationString;

        private Verification(String hashAlgorithm, String verificationString) {
            this.hashAlgorithm = hashAlgorithm;
            this.verificationString = verificationString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Verification)) {
                return false;
            }
            Verification other = (Verification)o;
            return Objects.equals(this.hashAlgorithm, other.hashAlgorithm) && Objects.equals(this.verificationString, other.verificationString);
        }

        public int hashCode() {
            return Objects.hash(this.hashAlgorithm, this.verificationString);
        }

        public String toString() {
            return this.hashAlgorithm + "+" + this.verificationString;
        }
    }
}

