/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.chatstates;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import rocks.xmpp.core.Jid;
import rocks.xmpp.core.chat.Chat;
import rocks.xmpp.core.session.ExtensionManager;
import rocks.xmpp.core.session.SessionStatusEvent;
import rocks.xmpp.core.session.SessionStatusListener;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.MessageEvent;
import rocks.xmpp.core.stanza.MessageListener;
import rocks.xmpp.core.stanza.model.AbstractMessage;
import rocks.xmpp.core.stanza.model.client.Message;
import rocks.xmpp.extensions.chatstates.model.ChatState;

public final class ChatStateManager
extends ExtensionManager {
    private final Map<Chat, ChatState> chatMap = new ConcurrentHashMap<Chat, ChatState>();
    private final Map<Jid, Boolean> contactSupportsChatStateNotifications = new ConcurrentHashMap<Jid, Boolean>();

    private ChatStateManager(XmppSession xmppSession) {
        super(xmppSession, new String[]{"http://jabber.org/protocol/chatstates"});
    }

    protected void initialize() {
        this.xmppSession.addSessionStatusListener(new SessionStatusListener(){

            public void sessionStatusChanged(SessionStatusEvent e) {
                if (e.getStatus() == XmppSession.Status.CLOSED) {
                    ChatStateManager.this.chatMap.clear();
                    ChatStateManager.this.contactSupportsChatStateNotifications.clear();
                }
            }
        });
        MessageListener messageListener = new MessageListener(){

            public void handleMessage(MessageEvent e) {
                Message message;
                if (ChatStateManager.this.isEnabled() && ((message = e.getMessage()).getType() == AbstractMessage.Type.CHAT || message.getType() == AbstractMessage.Type.GROUPCHAT)) {
                    boolean containsChatState;
                    boolean bl = containsChatState = message.getExtension(ChatState.class) != null;
                    if (!e.isInbound()) {
                        Boolean isSupportedByPeer;
                        if (!containsChatState && ((isSupportedByPeer = (Boolean)ChatStateManager.this.contactSupportsChatStateNotifications.get(message.getTo())) == null || isSupportedByPeer.booleanValue())) {
                            message.getExtensions().add(ChatState.ACTIVE);
                        }
                    } else if (message.getType() != AbstractMessage.Type.GROUPCHAT) {
                        ChatStateManager.this.contactSupportsChatStateNotifications.put(message.getFrom(), containsChatState);
                    }
                }
            }
        };
        this.xmppSession.addInboundMessageListener(messageListener);
        this.xmppSession.addOutboundMessageListener(messageListener);
    }

    public final boolean setChatState(ChatState chatState, Chat chat) {
        if (!this.isEnabled()) {
            throw new IllegalStateException("Chat States aren't enabled. Please enable them before sending chat states.");
        }
        if (this.chatMap.put(Objects.requireNonNull(chat), Objects.requireNonNull(chatState)) == chatState) {
            return false;
        }
        Message message = new Message();
        message.getExtensions().add(chatState);
        chat.sendMessage(message);
        return true;
    }
}

