/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.filetransfer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import rocks.xmpp.extensions.filetransfer.FileTransferStatusEvent;
import rocks.xmpp.extensions.filetransfer.FileTransferStatusListener;

public final class FileTransfer {
    private final long length;
    private final InputStream inputStream;
    private final OutputStream outputStream;
    private final Set<FileTransferStatusListener> fileTransferStatusListeners = new CopyOnWriteArraySet<FileTransferStatusListener>();
    private volatile Status status;
    private volatile Exception exception;
    private volatile long bytesTransferred;

    public FileTransfer(InputStream inputStream, OutputStream outputStream, long length) {
        this.inputStream = inputStream;
        this.outputStream = outputStream;
        this.length = length;
    }

    public void addFileTransferStatusListener(FileTransferStatusListener fileTransferStatusListener) {
        this.fileTransferStatusListeners.add(fileTransferStatusListener);
    }

    public void removeFileTransferStatusListener(FileTransferStatusListener fileTransferStatusListener) {
        this.fileTransferStatusListeners.remove(fileTransferStatusListener);
    }

    private final void notifyFileTransferStatusListeners(FileTransferStatusEvent fileTransferStatusEvent) {
        for (FileTransferStatusListener fileTransferStatusListener : this.fileTransferStatusListeners) {
            try {
                fileTransferStatusListener.fileTransferStatusChanged(fileTransferStatusEvent);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private final void notifyFileTransferStatusListeners(Status status, long bytesTransferred) {
        this.notifyFileTransferStatusListeners(new FileTransferStatusEvent(this, status, bytesTransferred));
    }

    private final void notifyFileTransferStatusListeners() {
        this.notifyFileTransferStatusListeners(this.status, this.bytesTransferred);
    }

    public Status getStatus() {
        return this.status;
    }

    private void updateStatus(Status status) {
        if (this.status != status) {
            this.status = status;
            this.notifyFileTransferStatusListeners();
        }
    }

    public boolean isDone() {
        return this.status != Status.IN_PROGRESS;
    }

    public long getBytesTransferred() {
        return this.bytesTransferred;
    }

    private final void setBytesTransferred(long bytesTransferred) {
        if (this.bytesTransferred == bytesTransferred) {
            return;
        }
        this.bytesTransferred = bytesTransferred;
        this.notifyFileTransferStatusListeners();
    }

    private final void addBytesTransferred(long bytesTransferredAdditionally) {
        this.setBytesTransferred(this.bytesTransferred + bytesTransferredAdditionally);
    }

    public double getProgress() {
        if (this.length != 0L) {
            return (double)this.getBytesTransferred() / (double)this.length;
        }
        return -1.0;
    }

    public void transfer() {
        Thread thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                byte[] buffer = new byte[8192];
                FileTransfer.this.bytesTransferred = 0L;
                FileTransfer.this.updateStatus(Status.IN_PROGRESS);
                try {
                    int len;
                    while ((len = FileTransfer.this.inputStream.read(buffer)) > -1 && FileTransfer.this.status != Status.CANCELED) {
                        FileTransfer.this.outputStream.write(buffer, 0, len);
                        FileTransfer.this.addBytesTransferred(len);
                    }
                    if (FileTransfer.this.bytesTransferred == FileTransfer.this.length) return;
                    FileTransfer.this.updateStatus(Status.FAILED);
                    return;
                }
                catch (IOException e) {
                    FileTransfer.this.exception = e;
                    FileTransfer.this.updateStatus(Status.FAILED);
                    return;
                }
                finally {
                    try {
                        FileTransfer.this.inputStream.close();
                        FileTransfer.this.outputStream.close();
                    }
                    catch (IOException e) {
                        FileTransfer.this.exception = e;
                        FileTransfer.this.updateStatus(Status.FAILED);
                    }
                    finally {
                        if (FileTransfer.this.status == Status.IN_PROGRESS) {
                            FileTransfer.this.updateStatus(Status.COMPLETED);
                        }
                    }
                }
            }
        };
        thread.start();
    }

    public void cancel() {
        this.updateStatus(Status.CANCELED);
    }

    public Exception getException() {
        return this.exception;
    }

    public static enum Status {
        CANCELED,
        COMPLETED,
        FAILED,
        IN_PROGRESS;

    }
}

