/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.filetransfer;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Date;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import rocks.xmpp.core.Jid;
import rocks.xmpp.core.XmppException;
import rocks.xmpp.core.XmppUtils;
import rocks.xmpp.core.session.ExtensionManager;
import rocks.xmpp.core.session.SessionStatusEvent;
import rocks.xmpp.core.session.SessionStatusListener;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.StanzaException;
import rocks.xmpp.core.stanza.model.AbstractIQ;
import rocks.xmpp.core.stanza.model.client.IQ;
import rocks.xmpp.core.stanza.model.errors.Condition;
import rocks.xmpp.extensions.caps.EntityCapabilitiesManager;
import rocks.xmpp.extensions.filetransfer.FileTransfer;
import rocks.xmpp.extensions.filetransfer.FileTransferNegotiator;
import rocks.xmpp.extensions.filetransfer.FileTransferOffer;
import rocks.xmpp.extensions.filetransfer.FileTransferOfferEvent;
import rocks.xmpp.extensions.filetransfer.FileTransferOfferListener;
import rocks.xmpp.extensions.filetransfer.FileTransferRejectedException;
import rocks.xmpp.extensions.oob.model.iq.OobIQ;
import rocks.xmpp.extensions.si.StreamInitiationManager;
import rocks.xmpp.extensions.si.profile.filetransfer.model.SIFileTransferOffer;

public final class FileTransferManager
extends ExtensionManager {
    private static final Logger logger = Logger.getLogger(FileTransferManager.class.getName());
    private final StreamInitiationManager streamInitiationManager;
    private final EntityCapabilitiesManager entityCapabilitiesManager;
    private final Set<FileTransferOfferListener> fileTransferOfferListeners = new CopyOnWriteArraySet<FileTransferOfferListener>();
    private final ExecutorService fileTransferOfferExecutor = Executors.newCachedThreadPool(XmppUtils.createNamedThreadFactory((String)"File Transfer Offer Thread"));

    private FileTransferManager(XmppSession xmppSession) {
        super(xmppSession, new String[0]);
        this.streamInitiationManager = (StreamInitiationManager)xmppSession.getManager(StreamInitiationManager.class);
        this.entityCapabilitiesManager = (EntityCapabilitiesManager)xmppSession.getManager(EntityCapabilitiesManager.class);
    }

    protected void initialize() {
        this.xmppSession.addSessionStatusListener(new SessionStatusListener(){

            public void sessionStatusChanged(SessionStatusEvent e) {
                if (e.getStatus() == XmppSession.Status.CLOSED) {
                    FileTransferManager.this.fileTransferOfferListeners.clear();
                    FileTransferManager.this.fileTransferOfferExecutor.shutdown();
                }
            }
        });
    }

    public void offerFile(URL url, String description, Jid recipient, long timeout) throws XmppException {
        try {
            this.xmppSession.query(new IQ(recipient, AbstractIQ.Type.SET, (Object)new OobIQ(url, description)), timeout);
        }
        catch (StanzaException e) {
            if (e.getStanza().getError().getCondition() == Condition.NOT_ACCEPTABLE) {
                throw new FileTransferRejectedException();
            }
            throw e;
        }
    }

    public final FileTransfer offerFile(File file, String description, Jid recipient, long timeout) throws XmppException, IOException {
        return this.offerFile(Objects.requireNonNull(file, "file must not be null.").toPath(), description, recipient, timeout);
    }

    public final FileTransfer offerFile(Path source, String description, Jid recipient, long timeout) throws XmppException, IOException {
        if (Files.notExists(Objects.requireNonNull(source, "source must not be null."), new LinkOption[0])) {
            throw new NoSuchFileException(source.getFileName().toString());
        }
        return this.offerFile(Files.newInputStream(source, new OpenOption[0]), source.getFileName().toString(), Files.size(source), new Date(Files.getLastModifiedTime(source, new LinkOption[0]).toMillis()), description, recipient, timeout);
    }

    public final FileTransfer offerFile(InputStream source, String fileName, long fileSize, Date lastModified, String description, Jid recipient, long timeout) throws XmppException, IOException {
        if (!Objects.requireNonNull(recipient, "jid must not be null.").isFullJid()) {
            throw new IllegalArgumentException("recipient must be a full JID (including resource)");
        }
        if (!this.entityCapabilitiesManager.isSupported("http://jabber.org/protocol/si", recipient) || !this.entityCapabilitiesManager.isSupported("http://jabber.org/protocol/si/profile/file-transfer", recipient)) {
            throw new XmppException("Feature not supported");
        }
        SIFileTransferOffer fileTransfer = new SIFileTransferOffer(fileName, fileSize, lastModified, null, description, null);
        String mimeType = URLConnection.guessContentTypeFromStream(source);
        try {
            OutputStream outputStream = this.streamInitiationManager.initiateStream(recipient, fileTransfer, mimeType, timeout);
            return new FileTransfer(source, outputStream, fileSize);
        }
        catch (StanzaException e) {
            if (e.getStanza().getError().getCondition() == Condition.FORBIDDEN) {
                throw new FileTransferRejectedException();
            }
            throw e;
        }
    }

    public void fileTransferOffered(final IQ iq, final String sessionId, final String mimeType, final FileTransferOffer fileTransferOffer, final Object protocol, final FileTransferNegotiator fileTransferNegotiator) {
        this.fileTransferOfferExecutor.execute(new Runnable(){

            @Override
            public void run() {
                FileTransferOfferEvent fileTransferRequestEvent = new FileTransferOfferEvent(this, iq, sessionId, mimeType, fileTransferOffer, protocol, fileTransferNegotiator);
                for (FileTransferOfferListener fileTransferOfferListener : FileTransferManager.this.fileTransferOfferListeners) {
                    try {
                        fileTransferOfferListener.fileTransferOffered(fileTransferRequestEvent);
                    }
                    catch (Exception e) {
                        logger.log(Level.WARNING, e.getMessage(), e);
                    }
                }
            }
        });
    }

    public void addFileTransferOfferListener(FileTransferOfferListener fileTransferOfferListener) {
        this.fileTransferOfferListeners.add(fileTransferOfferListener);
    }

    public void removeFileTransferOfferListener(FileTransferOfferListener fileTransferOfferListener) {
        this.fileTransferOfferListeners.remove(fileTransferOfferListener);
    }
}

