/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.filetransfer;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import rocks.xmpp.core.Jid;
import rocks.xmpp.core.stanza.model.client.IQ;
import rocks.xmpp.extensions.filetransfer.FileTransfer;
import rocks.xmpp.extensions.filetransfer.FileTransferNegotiator;
import rocks.xmpp.extensions.filetransfer.FileTransferOffer;
import rocks.xmpp.extensions.filetransfer.Range;
import rocks.xmpp.extensions.hashes.model.Hash;

public final class FileTransferOfferEvent
extends EventObject
implements FileTransferOffer {
    private final FileTransferOffer fileTransferOffer;
    private final IQ iq;
    private final String mimeType;
    private final String sessionId;
    private final FileTransferNegotiator fileTransferNegotiator;
    private final Object protocol;

    FileTransferOfferEvent(Object source, IQ iq, String sessionId, String mimeType, FileTransferOffer fileTransferOffer, Object protocol, FileTransferNegotiator fileTransferNegotiator) {
        super(source);
        this.sessionId = sessionId;
        this.iq = iq;
        this.fileTransferOffer = fileTransferOffer;
        this.mimeType = mimeType;
        this.fileTransferNegotiator = fileTransferNegotiator;
        this.protocol = protocol;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public Jid getInitiator() {
        return this.iq.getFrom();
    }

    public FileTransfer accept(OutputStream outputStream) throws IOException {
        return this.fileTransferNegotiator.accept(this.iq, this.sessionId, this.fileTransferOffer, this.protocol, outputStream);
    }

    public final FileTransfer accept(Path destination) throws IOException {
        return this.accept(Files.newOutputStream(destination, new OpenOption[0]));
    }

    public final FileTransfer accept(File target) throws IOException {
        return this.accept(target.toPath());
    }

    public void reject() {
        this.fileTransferNegotiator.reject(this.iq);
    }

    public long getSize() {
        return this.fileTransferOffer.getSize();
    }

    public String getName() {
        return this.fileTransferOffer.getName();
    }

    public Date getDate() {
        return this.fileTransferOffer.getDate();
    }

    public List<Hash> getHashes() {
        return this.fileTransferOffer.getHashes();
    }

    public String getDescription() {
        return this.fileTransferOffer.getDescription();
    }

    public Range getRange() {
        return this.fileTransferOffer.getRange();
    }

    public String getSessionId() {
        return this.sessionId;
    }
}

