/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.httpauth;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import rocks.xmpp.core.session.ExtensionManager;
import rocks.xmpp.core.session.Manager;
import rocks.xmpp.core.session.SessionStatusEvent;
import rocks.xmpp.core.session.SessionStatusListener;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.AbstractIQHandler;
import rocks.xmpp.core.stanza.IQHandler;
import rocks.xmpp.core.stanza.MessageEvent;
import rocks.xmpp.core.stanza.MessageListener;
import rocks.xmpp.core.stanza.model.AbstractIQ;
import rocks.xmpp.core.stanza.model.AbstractMessage;
import rocks.xmpp.core.stanza.model.Stanza;
import rocks.xmpp.core.stanza.model.client.IQ;
import rocks.xmpp.core.stanza.model.client.Message;
import rocks.xmpp.core.stanza.model.errors.Condition;
import rocks.xmpp.extensions.httpauth.HttpAuthenticationEvent;
import rocks.xmpp.extensions.httpauth.HttpAuthenticationListener;
import rocks.xmpp.extensions.httpauth.model.ConfirmationRequest;

public final class HttpAuthenticationManager
extends ExtensionManager {
    private static final Logger logger = Logger.getLogger(HttpAuthenticationManager.class.getName());
    private final Set<HttpAuthenticationListener> httpAuthenticationListeners = new CopyOnWriteArraySet<HttpAuthenticationListener>();

    private HttpAuthenticationManager(XmppSession xmppSession) {
        super(xmppSession, new String[0]);
    }

    protected void initialize() {
        this.xmppSession.addIQHandler(ConfirmationRequest.class, (IQHandler)new AbstractIQHandler((Manager)this, AbstractIQ.Type.GET){

            protected IQ processRequest(IQ iq) {
                ConfirmationRequest confirmationRequest = (ConfirmationRequest)iq.getExtension(ConfirmationRequest.class);
                if (HttpAuthenticationManager.this.notifyHttpAuthListeners((Stanza)iq, confirmationRequest)) {
                    return null;
                }
                return iq.createError(Condition.SERVICE_UNAVAILABLE);
            }
        });
        this.xmppSession.addSessionStatusListener(new SessionStatusListener(){

            public void sessionStatusChanged(SessionStatusEvent e) {
                if (e.getStatus() == XmppSession.Status.CLOSED) {
                    HttpAuthenticationManager.this.httpAuthenticationListeners.clear();
                }
            }
        });
        this.xmppSession.addInboundMessageListener(new MessageListener(){

            public void handleMessage(MessageEvent e) {
                ConfirmationRequest confirmationRequest;
                Message message = e.getMessage();
                if ((message.getType() == null || message.getType() == AbstractMessage.Type.NORMAL) && (confirmationRequest = (ConfirmationRequest)message.getExtension(ConfirmationRequest.class)) != null) {
                    HttpAuthenticationManager.this.notifyHttpAuthListeners((Stanza)message, confirmationRequest);
                }
            }
        });
    }

    private boolean notifyHttpAuthListeners(Stanza stanza, ConfirmationRequest confirmationRequest) {
        boolean handled = false;
        for (HttpAuthenticationListener httpAuthenticationListener : this.httpAuthenticationListeners) {
            try {
                httpAuthenticationListener.confirmationRequested(new HttpAuthenticationEvent((Object)this, this.xmppSession, stanza, confirmationRequest));
                handled = true;
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, ex.getMessage(), ex);
            }
        }
        return handled;
    }

    public void addHttpAuthenticationListener(HttpAuthenticationListener httpAuthenticationListener) {
        this.httpAuthenticationListeners.add(httpAuthenticationListener);
    }

    public void removeHttpAuthenticationListener(HttpAuthenticationListener httpAuthenticationListener) {
        this.httpAuthenticationListeners.remove(httpAuthenticationListener);
    }
}

