/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.jingle;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import rocks.xmpp.core.Jid;
import rocks.xmpp.core.XmppException;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.model.AbstractIQ;
import rocks.xmpp.core.stanza.model.client.IQ;
import rocks.xmpp.extensions.jingle.JingleEvent;
import rocks.xmpp.extensions.jingle.JingleListener;
import rocks.xmpp.extensions.jingle.JingleManager;
import rocks.xmpp.extensions.jingle.model.Jingle;
import rocks.xmpp.extensions.jingle.transports.model.TransportMethod;

public final class JingleSession {
    private static final Logger logger = Logger.getLogger(JingleManager.class.getName());
    private final Set<JingleListener> jingleListeners = new CopyOnWriteArraySet<JingleListener>();
    private final String sessionId;
    private final XmppSession xmppSession;
    private final Jid peer;
    private final JingleManager jingleManager;
    private final boolean createdLocally;
    private final List<Jingle.Content> contents;
    private State state = State.INITIAL;

    JingleSession(String sessionId, Jid peer, boolean createdLocally, XmppSession xmppSession, JingleManager jingleManager, Jingle.Content ... contents) {
        this(sessionId, peer, createdLocally, xmppSession, jingleManager, Arrays.asList(contents));
    }

    JingleSession(String sessionId, Jid peer, boolean createdLocally, XmppSession xmppSession, JingleManager jingleManager, List<Jingle.Content> contents) {
        this.sessionId = sessionId;
        this.xmppSession = xmppSession;
        this.peer = peer;
        this.jingleManager = jingleManager;
        this.createdLocally = createdLocally;
        this.contents = new ArrayList<Jingle.Content>(contents);
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void initiate() throws XmppException {
        if (this.state != State.INITIAL) {
            throw new IllegalStateException("Session has already been initiated.");
        }
        if (!this.createdLocally) {
            throw new UnsupportedOperationException("You are not the initiator.");
        }
        this.xmppSession.query(new IQ(this.peer, AbstractIQ.Type.SET, (Object)Jingle.initiator((Jid)this.xmppSession.getConnectedResource(), (String)this.sessionId, (Jingle.Action)Jingle.Action.SESSION_INITIATE, this.contents)));
        this.state = State.PENDING;
    }

    public void accept(Jingle.Content ... contents) throws XmppException {
        if (this.state != State.PENDING) {
            throw new IllegalStateException("The session is not in pending state.");
        }
        if (this.createdLocally) {
            throw new UnsupportedOperationException("You are the initiator and cannot accept the session.");
        }
        if (contents.length == 0) {
            throw new IllegalArgumentException("No content element provided.");
        }
        for (Jingle.Content content : contents) {
            if (content.getApplicationFormat() == null) {
                throw new IllegalArgumentException("No application format provided in content.");
            }
            if (content.getTransportMethod() != null) continue;
            throw new IllegalArgumentException("No transport method provided in content.");
        }
        this.xmppSession.query(new IQ(this.peer, AbstractIQ.Type.SET, (Object)Jingle.responder((Jid)this.xmppSession.getConnectedResource(), (String)this.sessionId, (Jingle.Action)Jingle.Action.SESSION_ACCEPT, Arrays.asList(contents))));
        this.state = State.ACTIVE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate(Jingle.Reason reason) throws XmppException {
        if (this.state == State.INITIAL) {
            throw new IllegalStateException("The session has not yet been initialized.");
        }
        this.state = State.ENDED;
        try {
            this.xmppSession.query(new IQ(this.peer, AbstractIQ.Type.SET, (Object)new Jingle(this.sessionId, Jingle.Action.SESSION_TERMINATE, reason)));
        }
        finally {
            this.jingleManager.removeSession(this.sessionId);
        }
    }

    public void replaceTransport(String contentName, TransportMethod transportMethod) throws XmppException {
        Jingle.Content content = new Jingle.Content(contentName, Jingle.Content.Creator.INITIATOR, null, transportMethod);
        this.xmppSession.query(new IQ(this.peer, AbstractIQ.Type.SET, (Object)Jingle.initiator((Jid)this.xmppSession.getConnectedResource(), (String)this.sessionId, (Jingle.Action)Jingle.Action.TRANSPORT_REPLACE, Arrays.asList(content))));
    }

    public void acceptTransport(String contentName, TransportMethod transportMethod) throws XmppException {
        Jingle.Content content = new Jingle.Content(contentName, Jingle.Content.Creator.INITIATOR, null, transportMethod);
        this.xmppSession.query(new IQ(this.peer, AbstractIQ.Type.SET, (Object)Jingle.initiator((Jid)this.xmppSession.getConnectedResource(), (String)this.sessionId, (Jingle.Action)Jingle.Action.TRANSPORT_ACCEPT, Arrays.asList(content))));
    }

    public void rejectTransport(String contentName, TransportMethod transportMethod) throws XmppException {
        Jingle.Content content = new Jingle.Content(contentName, Jingle.Content.Creator.INITIATOR, null, transportMethod);
        this.xmppSession.query(new IQ(this.peer, AbstractIQ.Type.SET, (Object)Jingle.initiator((Jid)this.xmppSession.getConnectedResource(), (String)this.sessionId, (Jingle.Action)Jingle.Action.TRANSPORT_REJECT, Arrays.asList(content))));
    }

    public void sendSessionInfo(Object object) throws XmppException {
        if (this.state == State.INITIAL) {
            throw new IllegalStateException("The session has not yet been initialized.");
        }
        this.xmppSession.query(new IQ(this.peer, AbstractIQ.Type.SET, (Object)new Jingle(this.sessionId, Jingle.Action.SESSION_INFO, object)));
    }

    public final void addJingleListener(JingleListener jingleListener) {
        this.jingleListeners.add(jingleListener);
    }

    public final void removeJingleListener(JingleListener jingleListener) {
        this.jingleListeners.remove(jingleListener);
    }

    void notifyJingleListeners(JingleEvent jingleEvent) {
        for (JingleListener jingleListener : this.jingleListeners) {
            try {
                jingleListener.jingleReceived(jingleEvent);
            }
            catch (Exception exc) {
                logger.log(Level.WARNING, exc.getMessage(), exc);
            }
        }
    }

    public static enum State {
        INITIAL,
        PENDING,
        ACTIVE,
        ENDED;

    }
}

