/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.jingle.apps.filetransfer;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import rocks.xmpp.core.Jid;
import rocks.xmpp.core.XmppException;
import rocks.xmpp.core.session.ExtensionManager;
import rocks.xmpp.core.session.NoResponseException;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.extensions.bytestreams.ibb.InBandByteStreamManager;
import rocks.xmpp.extensions.filetransfer.FileTransferRejectedException;
import rocks.xmpp.extensions.jingle.JingleEvent;
import rocks.xmpp.extensions.jingle.JingleListener;
import rocks.xmpp.extensions.jingle.JingleManager;
import rocks.xmpp.extensions.jingle.JingleSession;
import rocks.xmpp.extensions.jingle.apps.filetransfer.JingleFileTransferSession;
import rocks.xmpp.extensions.jingle.apps.filetransfer.model.JingleFileTransfer;
import rocks.xmpp.extensions.jingle.apps.model.ApplicationFormat;
import rocks.xmpp.extensions.jingle.model.Jingle;
import rocks.xmpp.extensions.jingle.transports.ibb.model.InBandBytestreamsTransportMethod;
import rocks.xmpp.extensions.jingle.transports.model.TransportMethod;

public final class JingleFileTransferManager
extends ExtensionManager {
    private final JingleManager jingleManager;

    private JingleFileTransferManager(XmppSession xmppSession) {
        super(xmppSession, new String[]{"urn:xmpp:jingle:apps:file-transfer:4"});
        this.jingleManager = (JingleManager)xmppSession.getManager(JingleManager.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JingleFileTransferSession initiateFileTransferSession(Jid responder, File file, String description, long timeout) throws XmppException, IOException {
        JingleFileTransfer.File jingleFile = new JingleFileTransfer.File(file.getName(), file.length(), new Date(file.lastModified()), null, description);
        JingleFileTransfer jingleFileTransfer = new JingleFileTransfer(jingleFile);
        String ibbSessionId = UUID.randomUUID().toString();
        InBandBytestreamsTransportMethod ibbTransportMethod = new InBandBytestreamsTransportMethod(ibbSessionId, 4096);
        Jingle.Content content = new Jingle.Content("a-file-offer", Jingle.Content.Creator.INITIATOR, (ApplicationFormat)jingleFileTransfer, (TransportMethod)ibbTransportMethod);
        JingleSession jingleSession = this.jingleManager.createSession(responder, content);
        final ReentrantLock lock = new ReentrantLock();
        final Condition condition = lock.newCondition();
        final Jingle[] response = new Jingle[1];
        jingleSession.addJingleListener(new JingleListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void jingleReceived(JingleEvent e) {
                if (e.getJingle().getAction() == Jingle.Action.SESSION_ACCEPT || e.getJingle().getAction() == Jingle.Action.SESSION_TERMINATE) {
                    lock.lock();
                    try {
                        response[0] = e.getJingle();
                        condition.signalAll();
                    }
                    finally {
                        lock.unlock();
                    }
                }
            }
        });
        jingleSession.initiate();
        lock.lock();
        try {
            if (!condition.await(timeout, TimeUnit.MILLISECONDS)) {
                throw new NoResponseException("The receiver did not respond in time.");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            lock.unlock();
        }
        Jingle jingle = response[0];
        if (jingle.getAction() == Jingle.Action.SESSION_TERMINATE) {
            throw new FileTransferRejectedException();
        }
        if (jingle.getAction() == Jingle.Action.SESSION_ACCEPT) {
            InBandByteStreamManager inBandByteStreamManager = (InBandByteStreamManager)this.xmppSession.getManager(InBandByteStreamManager.class);
            inBandByteStreamManager.initiateSession(responder, ibbSessionId, 4096);
        }
        return new JingleFileTransferSession(jingleSession);
    }
}

