/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.last;

import java.util.Date;
import rocks.xmpp.core.Jid;
import rocks.xmpp.core.XmppException;
import rocks.xmpp.core.session.ExtensionManager;
import rocks.xmpp.core.session.Manager;
import rocks.xmpp.core.session.SessionStatusEvent;
import rocks.xmpp.core.session.SessionStatusListener;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.AbstractIQHandler;
import rocks.xmpp.core.stanza.IQHandler;
import rocks.xmpp.core.stanza.MessageEvent;
import rocks.xmpp.core.stanza.MessageListener;
import rocks.xmpp.core.stanza.PresenceEvent;
import rocks.xmpp.core.stanza.PresenceListener;
import rocks.xmpp.core.stanza.model.AbstractIQ;
import rocks.xmpp.core.stanza.model.AbstractPresence;
import rocks.xmpp.core.stanza.model.client.IQ;
import rocks.xmpp.core.stanza.model.client.Presence;
import rocks.xmpp.extensions.last.LastActivityStrategy;
import rocks.xmpp.extensions.last.model.LastActivity;

public final class LastActivityManager
extends ExtensionManager {
    private volatile LastActivityStrategy lastActivityStrategy;

    private LastActivityManager(XmppSession xmppSession) {
        super(xmppSession, new String[]{"jabber:iq:last"});
        this.lastActivityStrategy = new DefaultLastActivityStrategy(xmppSession);
        this.setEnabled(true);
    }

    protected void initialize() {
        this.xmppSession.addSessionStatusListener(new SessionStatusListener(){

            public void sessionStatusChanged(SessionStatusEvent e) {
                if (e.getStatus() == XmppSession.Status.CLOSED) {
                    LastActivityManager.this.lastActivityStrategy = null;
                }
            }
        });
        this.xmppSession.addOutboundPresenceListener(new PresenceListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handlePresence(PresenceEvent e) {
                Presence presence;
                if (LastActivityManager.this.isEnabled() && (presence = e.getPresence()).getTo() == null) {
                    LastActivityManager lastActivityManager = LastActivityManager.this;
                    synchronized (lastActivityManager) {
                        if (LastActivityManager.this.lastActivityStrategy != null && LastActivityManager.this.lastActivityStrategy.getLastActivity() != null && presence.isAvailable() && (presence.getShow() == AbstractPresence.Show.AWAY || presence.getShow() == AbstractPresence.Show.XA) && presence.getExtension(LastActivity.class) == null) {
                            presence.getExtensions().add(new LastActivity(LastActivityManager.this.getSecondsSince(LastActivityManager.this.lastActivityStrategy.getLastActivity()), presence.getStatus()));
                        }
                    }
                }
            }
        });
        this.xmppSession.addIQHandler(LastActivity.class, (IQHandler)new AbstractIQHandler((Manager)this, AbstractIQ.Type.GET){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected IQ processRequest(IQ iq) {
                LastActivityManager lastActivityManager = LastActivityManager.this;
                synchronized (lastActivityManager) {
                    long seconds = LastActivityManager.this.lastActivityStrategy != null && LastActivityManager.this.lastActivityStrategy.getLastActivity() != null ? LastActivityManager.this.getSecondsSince(LastActivityManager.this.lastActivityStrategy.getLastActivity()) : 0L;
                    return iq.createResult((Object)new LastActivity(seconds, null));
                }
            }
        });
    }

    private long getSecondsSince(Date date) {
        return Math.max(0L, System.currentTimeMillis() - date.getTime()) / 1000L;
    }

    public LastActivity getLastActivity(Jid jid) throws XmppException {
        IQ result = this.xmppSession.query(new IQ(jid, AbstractIQ.Type.GET, (Object)new LastActivity()));
        return (LastActivity)result.getExtension(LastActivity.class);
    }

    public synchronized LastActivityStrategy getLastActivityStrategy() {
        return this.lastActivityStrategy;
    }

    public synchronized void setLastActivityStrategy(LastActivityStrategy lastActivityStrategy) {
        this.lastActivityStrategy = lastActivityStrategy;
    }

    private static class DefaultLastActivityStrategy
    implements LastActivityStrategy,
    MessageListener,
    PresenceListener {
        private volatile Date lastActivity;

        public DefaultLastActivityStrategy(XmppSession xmppSession) {
            xmppSession.addOutboundMessageListener((MessageListener)this);
            xmppSession.addOutboundPresenceListener((PresenceListener)this);
        }

        @Override
        public Date getLastActivity() {
            return this.lastActivity;
        }

        public void handleMessage(MessageEvent e) {
            this.lastActivity = new Date();
        }

        public void handlePresence(PresenceEvent e) {
            Presence presence = e.getPresence();
            if (!presence.isAvailable() || presence.getShow() != AbstractPresence.Show.AWAY && presence.getShow() != AbstractPresence.Show.XA) {
                this.lastActivity = new Date();
            }
        }
    }
}

