/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.muc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import rocks.xmpp.core.Jid;
import rocks.xmpp.core.XmppException;
import rocks.xmpp.core.chat.Chat;
import rocks.xmpp.core.session.SessionStatusEvent;
import rocks.xmpp.core.session.SessionStatusListener;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.MessageEvent;
import rocks.xmpp.core.stanza.MessageListener;
import rocks.xmpp.core.stanza.PresenceEvent;
import rocks.xmpp.core.stanza.PresenceListener;
import rocks.xmpp.core.stanza.StanzaFilter;
import rocks.xmpp.core.stanza.model.AbstractIQ;
import rocks.xmpp.core.stanza.model.AbstractMessage;
import rocks.xmpp.core.stanza.model.AbstractPresence;
import rocks.xmpp.core.stanza.model.client.IQ;
import rocks.xmpp.core.stanza.model.client.Message;
import rocks.xmpp.core.stanza.model.client.Presence;
import rocks.xmpp.core.stream.model.ClientStreamElement;
import rocks.xmpp.extensions.data.model.DataForm;
import rocks.xmpp.extensions.delay.model.DelayedDelivery;
import rocks.xmpp.extensions.disco.ServiceDiscoveryManager;
import rocks.xmpp.extensions.disco.model.info.Feature;
import rocks.xmpp.extensions.disco.model.info.Identity;
import rocks.xmpp.extensions.disco.model.info.InfoNode;
import rocks.xmpp.extensions.disco.model.items.ItemNode;
import rocks.xmpp.extensions.muc.InvitationDeclineEvent;
import rocks.xmpp.extensions.muc.InvitationDeclineListener;
import rocks.xmpp.extensions.muc.MultiUserChatManager;
import rocks.xmpp.extensions.muc.Occupant;
import rocks.xmpp.extensions.muc.OccupantEvent;
import rocks.xmpp.extensions.muc.OccupantListener;
import rocks.xmpp.extensions.muc.RoomInformation;
import rocks.xmpp.extensions.muc.SubjectChangeEvent;
import rocks.xmpp.extensions.muc.SubjectChangeListener;
import rocks.xmpp.extensions.muc.conference.model.DirectInvitation;
import rocks.xmpp.extensions.muc.model.Actor;
import rocks.xmpp.extensions.muc.model.Affiliation;
import rocks.xmpp.extensions.muc.model.History;
import rocks.xmpp.extensions.muc.model.Item;
import rocks.xmpp.extensions.muc.model.Muc;
import rocks.xmpp.extensions.muc.model.MucFeature;
import rocks.xmpp.extensions.muc.model.RequestVoice;
import rocks.xmpp.extensions.muc.model.Role;
import rocks.xmpp.extensions.muc.model.RoomConfiguration;
import rocks.xmpp.extensions.muc.model.RoomInfo;
import rocks.xmpp.extensions.muc.model.admin.MucAdmin;
import rocks.xmpp.extensions.muc.model.owner.MucOwner;
import rocks.xmpp.extensions.muc.model.user.Decline;
import rocks.xmpp.extensions.muc.model.user.Invite;
import rocks.xmpp.extensions.muc.model.user.MucUser;
import rocks.xmpp.extensions.muc.model.user.Status;
import rocks.xmpp.extensions.register.model.Registration;

public final class ChatRoom
extends Chat
implements Comparable<ChatRoom> {
    private static final Logger logger = Logger.getLogger(ChatRoom.class.getName());
    private final Set<InvitationDeclineListener> invitationDeclineListeners = new CopyOnWriteArraySet<InvitationDeclineListener>();
    private final Set<SubjectChangeListener> subjectChangeListeners = new CopyOnWriteArraySet<SubjectChangeListener>();
    private final Set<OccupantListener> occupantListeners = new CopyOnWriteArraySet<OccupantListener>();
    private final Map<String, Occupant> occupantMap = new HashMap<String, Occupant>();
    private final ServiceDiscoveryManager serviceDiscoveryManager;
    private final MultiUserChatManager multiUserChatManager;
    private final String name;
    private final Jid roomJid;
    private final XmppSession xmppSession;
    private final MessageListener messageListener;
    private final PresenceListener presenceListener;
    private volatile String nick;
    private volatile boolean entered;

    ChatRoom(final Jid roomJid, String name, XmppSession xmppSession, ServiceDiscoveryManager serviceDiscoveryManager, MultiUserChatManager multiUserChatManager) {
        this.name = name;
        this.roomJid = roomJid;
        this.xmppSession = xmppSession;
        this.serviceDiscoveryManager = serviceDiscoveryManager;
        this.multiUserChatManager = multiUserChatManager;
        this.messageListener = new MessageListener(){

            public void handleMessage(MessageEvent e) {
                Message message = e.getMessage();
                if (message.getFrom().asBareJid().equals((Object)roomJid)) {
                    if (message.getType() == AbstractMessage.Type.GROUPCHAT) {
                        if (message.getSubject() != null && message.getBody() == null) {
                            DelayedDelivery delayedDelivery = (DelayedDelivery)message.getExtension(DelayedDelivery.class);
                            Date date = delayedDelivery != null ? delayedDelivery.getTimeStamp() : new Date();
                            ChatRoom.this.notifySubjectChangeListeners(new SubjectChangeEvent(ChatRoom.this, message.getSubject(), message.getFrom().getResource(), delayedDelivery != null, date));
                        } else {
                            ChatRoom.this.notifyInboundMessageListeners(new MessageEvent((Object)ChatRoom.this, message, true));
                        }
                    } else {
                        Decline decline;
                        MucUser mucUser = (MucUser)message.getExtension(MucUser.class);
                        if (mucUser != null && (decline = mucUser.getDecline()) != null) {
                            ChatRoom.this.notifyInvitationDeclineListeners(new InvitationDeclineEvent(ChatRoom.this, roomJid, decline.getFrom(), decline.getReason()));
                        }
                    }
                }
            }
        };
        this.presenceListener = new PresenceListener(){

            public void handlePresence(PresenceEvent e) {
                String nick;
                MucUser mucUser;
                Presence presence = e.getPresence();
                if (presence.getFrom() != null && presence.getFrom().asBareJid().equals((Object)roomJid) && (mucUser = (MucUser)presence.getExtension(MucUser.class)) != null && (nick = presence.getFrom().getResource()) != null) {
                    boolean isSelfPresence = ChatRoom.this.isSelfPresence(presence);
                    if (presence.isAvailable()) {
                        Occupant occupant = new Occupant(presence, isSelfPresence);
                        Occupant previousOccupant = ChatRoom.this.occupantMap.put(nick, occupant);
                        if (previousOccupant == null) {
                            if (!isSelfPresence && ChatRoom.this.entered) {
                                ChatRoom.this.notifyOccupantListeners(new OccupantEvent(ChatRoom.this, occupant, OccupantEvent.Type.ENTERED, null, null, null));
                            }
                        } else {
                            ChatRoom.this.notifyOccupantListeners(new OccupantEvent(ChatRoom.this, occupant, OccupantEvent.Type.STATUS_CHANGED, null, null, null));
                        }
                    } else if (presence.getType() == AbstractPresence.Type.UNAVAILABLE) {
                        Occupant occupant = (Occupant)ChatRoom.this.occupantMap.remove(nick);
                        if (occupant != null) {
                            if (mucUser.getItem() != null) {
                                Actor actor = mucUser.getItem().getActor();
                                String reason = mucUser.getItem().getReason();
                                if (!mucUser.getStatusCodes().isEmpty()) {
                                    if (mucUser.getStatusCodes().contains(Status.KICKED)) {
                                        ChatRoom.this.notifyOccupantListeners(new OccupantEvent(ChatRoom.this, occupant, OccupantEvent.Type.KICKED, actor, reason, null));
                                    } else if (mucUser.getStatusCodes().contains(Status.BANNED)) {
                                        ChatRoom.this.notifyOccupantListeners(new OccupantEvent(ChatRoom.this, occupant, OccupantEvent.Type.BANNED, actor, reason, null));
                                    } else if (mucUser.getStatusCodes().contains(Status.MEMBERSHIP_REVOKED)) {
                                        ChatRoom.this.notifyOccupantListeners(new OccupantEvent(ChatRoom.this, occupant, OccupantEvent.Type.MEMBERSHIP_REVOKED, actor, reason, null));
                                    } else if (mucUser.getStatusCodes().contains(Status.NICK_CHANGED)) {
                                        ChatRoom.this.notifyOccupantListeners(new OccupantEvent(ChatRoom.this, occupant, OccupantEvent.Type.NICKNAME_CHANGED, actor, reason, null));
                                    } else if (mucUser.getStatusCodes().contains(Status.SERVICE_SHUT_DOWN)) {
                                        ChatRoom.this.notifyOccupantListeners(new OccupantEvent(ChatRoom.this, occupant, OccupantEvent.Type.SYSTEM_SHUTDOWN, actor, reason, null));
                                    }
                                } else if (mucUser.getDestroy() != null) {
                                    ChatRoom.this.notifyOccupantListeners(new OccupantEvent(ChatRoom.this, occupant, OccupantEvent.Type.ROOM_DESTROYED, actor, mucUser.getDestroy().getReason(), mucUser.getDestroy().getJid()));
                                } else {
                                    ChatRoom.this.notifyOccupantListeners(new OccupantEvent(ChatRoom.this, occupant, OccupantEvent.Type.EXITED, null, null, null));
                                }
                            } else {
                                ChatRoom.this.notifyOccupantListeners(new OccupantEvent(ChatRoom.this, occupant, OccupantEvent.Type.EXITED, null, null, null));
                            }
                        }
                        if (isSelfPresence) {
                            ChatRoom.this.userHasExited();
                        }
                    }
                }
            }
        };
    }

    void initialize() {
        this.xmppSession.addSessionStatusListener(new SessionStatusListener(){

            public void sessionStatusChanged(SessionStatusEvent e) {
                if (e.getStatus() == XmppSession.Status.CLOSED) {
                    ChatRoom.this.invitationDeclineListeners.clear();
                    ChatRoom.this.subjectChangeListeners.clear();
                    ChatRoom.this.occupantListeners.clear();
                    ChatRoom.this.inboundMessageListeners.clear();
                    ChatRoom.this.occupantMap.clear();
                }
            }
        });
    }

    private void userHasExited() {
        this.xmppSession.removeInboundMessageListener(this.messageListener);
        this.xmppSession.removeInboundPresenceListener(this.presenceListener);
    }

    private void notifyInvitationDeclineListeners(InvitationDeclineEvent invitationDeclineEvent) {
        for (InvitationDeclineListener invitationDeclineListener : this.invitationDeclineListeners) {
            try {
                invitationDeclineListener.invitationDeclined(invitationDeclineEvent);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
    }

    private void notifyOccupantListeners(OccupantEvent occupantEvent) {
        for (OccupantListener occupantListener : this.occupantListeners) {
            try {
                occupantListener.occupantChanged(occupantEvent);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
    }

    private void notifySubjectChangeListeners(SubjectChangeEvent subjectChangeEvent) {
        for (SubjectChangeListener subjectChangeListener : this.subjectChangeListeners) {
            try {
                subjectChangeListener.subjectChanged(subjectChangeEvent);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
    }

    private boolean isSelfPresence(Presence presence) {
        boolean isSelfPresence = false;
        MucUser mucUser = (MucUser)presence.getExtension(MucUser.class);
        if (mucUser != null) {
            boolean nicknameChanged = mucUser.getStatusCodes().contains(Status.SERVICE_HAS_ASSIGNED_OR_MODIFIED_NICK);
            if (nicknameChanged) {
                this.nick = presence.getFrom().getResource();
            }
            isSelfPresence = mucUser.getStatusCodes().contains(Status.SELF_PRESENCE) || nicknameChanged;
        }
        return isSelfPresence || this.nick != null && presence.getFrom() != null && this.nick.equals(presence.getFrom().getResource());
    }

    public void addInvitationDeclineListener(InvitationDeclineListener invitationDeclineListener) {
        this.invitationDeclineListeners.add(invitationDeclineListener);
    }

    public void removeInvitationDeclineListener(InvitationDeclineListener invitationDeclineListener) {
        this.invitationDeclineListeners.remove(invitationDeclineListener);
    }

    public void addSubjectChangeListener(SubjectChangeListener subjectChangeListener) {
        this.subjectChangeListeners.add(subjectChangeListener);
    }

    public void removeSubjectChangeListener(SubjectChangeListener subjectChangeListener) {
        this.subjectChangeListeners.remove(subjectChangeListener);
    }

    public void addOccupantListener(OccupantListener occupantListener) {
        this.occupantListeners.add(occupantListener);
    }

    public void removeOccupantListener(OccupantListener occupantListener) {
        this.occupantListeners.remove(occupantListener);
    }

    public void enter(String nick) throws XmppException {
        this.enter(nick, null, null);
    }

    public void enter(String nick, String password) throws XmppException {
        this.enter(nick, password, null);
    }

    public void enter(String nick, History history) throws XmppException {
        this.enter(nick, null, history);
    }

    public synchronized void enter(String nick, String password, History history) throws XmppException {
        Objects.requireNonNull(nick, "nick must not be null.");
        if (this.entered) {
            throw new IllegalStateException("You already entered this room.");
        }
        try {
            this.xmppSession.addInboundMessageListener(this.messageListener);
            this.xmppSession.addInboundPresenceListener(this.presenceListener);
            Presence enterPresence = new Presence(this.roomJid.withResource(nick));
            enterPresence.getExtensions().add(new Muc(password, history));
            this.nick = nick;
            this.xmppSession.sendAndAwaitPresence((ClientStreamElement)enterPresence, (StanzaFilter)new StanzaFilter<Presence>(){

                public boolean accept(Presence presence) {
                    Jid room = presence.getFrom().asBareJid();
                    return presence.isAvailable() && room.equals((Object)ChatRoom.this.roomJid) && ChatRoom.this.isSelfPresence(presence);
                }
            });
        }
        catch (XmppException e) {
            this.xmppSession.removeInboundMessageListener(this.messageListener);
            this.xmppSession.removeInboundPresenceListener(this.presenceListener);
            throw e;
        }
        this.multiUserChatManager.roomEntered(this, nick);
        this.entered = true;
    }

    public void changeSubject(final String subject) throws XmppException {
        Message message = new Message(this.roomJid, AbstractMessage.Type.GROUPCHAT, null, subject, null);
        this.xmppSession.sendAndAwaitMessage((ClientStreamElement)message, (StanzaFilter)new StanzaFilter<Message>(){

            public boolean accept(Message message) {
                return message.getSubject() != null && message.getSubject().equals(subject);
            }
        });
    }

    public Message sendMessage(String message) {
        Message m = new Message(this.roomJid, AbstractMessage.Type.GROUPCHAT, message);
        this.xmppSession.send((ClientStreamElement)m);
        return m;
    }

    public Message sendMessage(Message message) {
        Message m = new Message(this.roomJid, AbstractMessage.Type.GROUPCHAT, (Collection)message.getBodies(), (Collection)message.getSubjects(), message.getThread(), message.getParentThread(), message.getId(), message.getFrom(), message.getLanguage(), (Collection)message.getExtensions(), message.getError());
        this.xmppSession.send((ClientStreamElement)m);
        return m;
    }

    public synchronized void changeNickname(String newNickname) throws XmppException {
        if (!this.entered) {
            throw new IllegalStateException("You must have entered the room to change your nickname.");
        }
        final Presence changeNickNamePresence = new Presence(this.roomJid.withResource(newNickname));
        this.xmppSession.sendAndAwaitPresence((ClientStreamElement)changeNickNamePresence, (StanzaFilter)new StanzaFilter<Presence>(){

            public boolean accept(Presence presence) {
                return presence.getFrom().equals((Object)changeNickNamePresence.getTo());
            }
        });
    }

    public synchronized void changeAvailabilityStatus(AbstractPresence.Show show, String status) {
        if (!this.entered) {
            throw new IllegalStateException("You must have entered the room to change the availability status.");
        }
        this.xmppSession.send((ClientStreamElement)new Presence(this.roomJid.withResource(this.nick), show, status));
    }

    public void invite(Jid invitee, String reason) {
        this.invite(invitee, reason, false);
    }

    public void invite(Jid invitee, String reason, boolean direct) {
        Message message;
        if (direct) {
            message = new Message(invitee, AbstractMessage.Type.NORMAL);
            message.getExtensions().add(new DirectInvitation(this.roomJid, null, reason));
        } else {
            message = new Message(this.roomJid, AbstractMessage.Type.NORMAL);
            message.getExtensions().add(MucUser.withInvites((Invite[])new Invite[]{new Invite(invitee, reason)}));
        }
        this.xmppSession.send((ClientStreamElement)message);
    }

    public DataForm getRegistrationForm() throws XmppException {
        IQ iq = new IQ(this.roomJid, AbstractIQ.Type.GET, (Object)new Registration());
        IQ result = this.xmppSession.query(iq);
        Registration registration = (Registration)result.getExtension(Registration.class);
        if (registration != null) {
            return registration.getRegistrationForm();
        }
        return null;
    }

    @Deprecated
    public void submitRegistrationForm(DataForm dataForm) throws XmppException {
        this.register(Registration.builder().registrationForm(dataForm).build());
    }

    public void register(Registration registration) throws XmppException {
        Objects.requireNonNull(registration, "registration must not be null.");
        if (registration.getRegistrationForm() != null) {
            if (registration.getRegistrationForm().getType() != DataForm.Type.SUBMIT) {
                throw new IllegalArgumentException("Data Form must be of type 'submit'");
            }
            if (!"http://jabber.org/protocol/muc#register".equals(registration.getRegistrationForm().getFormType())) {
                throw new IllegalArgumentException("Data Form is not of type 'http://jabber.org/protocol/muc#register'");
            }
        }
        IQ iq = new IQ(this.roomJid, AbstractIQ.Type.SET, (Object)registration);
        this.xmppSession.query(iq);
    }

    public String discoverReservedNickname() throws XmppException {
        ServiceDiscoveryManager serviceDiscoveryManager = (ServiceDiscoveryManager)this.xmppSession.getManager(ServiceDiscoveryManager.class);
        InfoNode infoNode = serviceDiscoveryManager.discoverInformation(this.roomJid, "x-roomuser-item");
        if (infoNode != null) {
            for (Identity identity : infoNode.getIdentities()) {
                if (!"conference".equals(identity.getCategory()) || !"text".equals(identity.getType())) continue;
                return identity.getName();
            }
        }
        return null;
    }

    public void requestVoice() {
        Message message = new Message(this.roomJid);
        RequestVoice requestVoice = RequestVoice.builder().role(Role.PARTICIPANT).build();
        message.getExtensions().add(requestVoice.getDataForm());
        this.xmppSession.send((ClientStreamElement)message);
    }

    public void exit() throws XmppException {
        this.exit(null);
    }

    public synchronized void exit(String message) throws XmppException {
        if (!this.entered) {
            throw new IllegalStateException("You can't exit a room, when you didn't enter it.");
        }
        this.xmppSession.sendAndAwaitPresence((ClientStreamElement)new Presence(this.roomJid.withResource(this.nick), AbstractPresence.Type.UNAVAILABLE, message), (StanzaFilter)new StanzaFilter<Presence>(){

            public boolean accept(Presence presence) {
                Jid room = presence.getFrom().asBareJid();
                return !presence.isAvailable() && room.equals((Object)ChatRoom.this.roomJid) && ChatRoom.this.isSelfPresence(presence);
            }
        });
        this.userHasExited();
        this.nick = null;
        this.multiUserChatManager.roomExited(this);
        this.entered = false;
        this.occupantMap.clear();
    }

    public List<? extends Item> getVoiceList() throws XmppException {
        IQ result = this.xmppSession.query(new IQ(this.roomJid, AbstractIQ.Type.GET, (Object)MucAdmin.withItem((Role)Role.PARTICIPANT, null, null)));
        MucAdmin mucAdmin = (MucAdmin)result.getExtension(MucAdmin.class);
        return mucAdmin.getItems();
    }

    public void changeAffiliationsOrRoles(List<Item> items) throws XmppException {
        this.xmppSession.query(new IQ(this.roomJid, AbstractIQ.Type.SET, (Object)MucAdmin.withItems(items)));
    }

    public List<? extends Item> getBanList() throws XmppException {
        IQ result = this.xmppSession.query(new IQ(this.roomJid, AbstractIQ.Type.GET, (Object)MucAdmin.withItem((Affiliation)Affiliation.OUTCAST, null, null)));
        MucAdmin mucAdmin = (MucAdmin)result.getExtension(MucAdmin.class);
        return mucAdmin.getItems();
    }

    public void changeAffiliation(Affiliation affiliation, Jid user, String reason) throws XmppException {
        this.xmppSession.query(new IQ(this.roomJid, AbstractIQ.Type.SET, (Object)MucAdmin.withItem((Affiliation)affiliation, (Jid)user, (String)reason)));
    }

    public void changeRole(Role role, String nickname, String reason) throws XmppException {
        this.xmppSession.query(new IQ(this.roomJid, AbstractIQ.Type.SET, (Object)MucAdmin.withItem((Role)role, (String)nickname, (String)reason)));
    }

    public List<? extends Item> getMembers() throws XmppException {
        IQ result = this.xmppSession.query(new IQ(this.roomJid, AbstractIQ.Type.GET, (Object)MucAdmin.withItem((Affiliation)Affiliation.MEMBER, null, null)));
        MucAdmin mucAdmin = (MucAdmin)result.getExtension(MucAdmin.class);
        return mucAdmin.getItems();
    }

    public List<? extends Item> getModerators() throws XmppException {
        IQ result = this.xmppSession.query(new IQ(this.roomJid, AbstractIQ.Type.GET, (Object)MucAdmin.withItem((Role)Role.MODERATOR, null, null)));
        MucAdmin mucAdmin = (MucAdmin)result.getExtension(MucAdmin.class);
        return mucAdmin.getItems();
    }

    public void createRoom() throws XmppException {
        this.enter(this.nick);
        this.xmppSession.query(new IQ(this.roomJid, AbstractIQ.Type.SET, (Object)new MucOwner(new DataForm(DataForm.Type.SUBMIT))));
    }

    public RoomInformation getRoomInformation() throws XmppException {
        InfoNode infoNode = this.serviceDiscoveryManager.discoverInformation(this.roomJid);
        Identity identity = null;
        HashSet<MucFeature> mucFeatures = new HashSet<MucFeature>();
        RoomInfo roomInfo = null;
        if (infoNode != null) {
            Set identities = infoNode.getIdentities();
            Iterator iterator = identities.iterator();
            if (iterator.hasNext()) {
                identity = (Identity)iterator.next();
            }
            for (Feature feature : infoNode.getFeatures()) {
                for (MucFeature mucFeature : MucFeature.values()) {
                    if (!mucFeature.getServiceDiscoveryFeature().equals(feature.getVar())) continue;
                    mucFeatures.add(mucFeature);
                }
            }
            for (DataForm dataForm : infoNode.getExtensions()) {
                String formType = dataForm.getFormType();
                if (!"http://jabber.org/protocol/muc#roominfo".equals(formType)) continue;
                roomInfo = new RoomInfo(dataForm);
                break;
            }
        }
        return new RoomInformation(identity, mucFeatures, roomInfo);
    }

    public List<String> discoverOccupants() throws XmppException {
        ItemNode itemNode = this.serviceDiscoveryManager.discoverItems(this.roomJid);
        ArrayList<String> occupants = new ArrayList<String>();
        List items = itemNode.getItems();
        for (rocks.xmpp.extensions.disco.model.items.Item item : items) {
            String nickname;
            if (item.getJid() == null || (nickname = item.getJid().getResource()) == null) continue;
            occupants.add(nickname);
        }
        return occupants;
    }

    public Collection<Occupant> getOccupants() {
        return this.occupantMap.values();
    }

    public Occupant getOccupant(String nickname) {
        return this.occupantMap.get(nickname);
    }

    public DataForm getConfigurationForm() throws XmppException {
        IQ result = this.xmppSession.query(new IQ(this.roomJid, AbstractIQ.Type.GET, (Object)new MucOwner()));
        MucOwner mucOwner = (MucOwner)result.getExtension(MucOwner.class);
        return mucOwner.getConfigurationForm();
    }

    @Deprecated
    public void submitConfigurationForm(DataForm dataForm) throws XmppException {
        Objects.requireNonNull(dataForm, "dataForm must not be null.");
        if (dataForm.getType() != DataForm.Type.SUBMIT && dataForm.getType() != DataForm.Type.CANCEL) {
            throw new IllegalArgumentException("Data Form must be of type 'submit' or 'cancel'");
        }
        if (!"http://jabber.org/protocol/muc#roomconfig".equals(dataForm.getFormType())) {
            throw new IllegalArgumentException("Data Form is not of type 'http://jabber.org/protocol/muc#roomconfig'");
        }
        MucOwner mucOwner = new MucOwner(dataForm);
        IQ iq = new IQ(this.roomJid, AbstractIQ.Type.SET, (Object)mucOwner);
        this.xmppSession.query(iq);
    }

    public void configure(RoomConfiguration roomConfiguration) throws XmppException {
        Objects.requireNonNull(roomConfiguration, "roomConfiguration must not be null.");
        MucOwner mucOwner = new MucOwner(roomConfiguration.getDataForm());
        IQ iq = new IQ(this.roomJid, AbstractIQ.Type.SET, (Object)mucOwner);
        this.xmppSession.query(iq);
    }

    public String getName() {
        return this.name;
    }

    public void destroy(String reason) throws XmppException {
        MucOwner mucOwner = MucOwner.withDestroy((Jid)this.roomJid, (String)reason);
        IQ iq = new IQ(this.roomJid, AbstractIQ.Type.SET, (Object)mucOwner);
        this.xmppSession.query(iq);
    }

    public Jid getAddress() {
        return this.roomJid;
    }

    public Set<Feature> discoverAllowableTraffic() throws XmppException {
        return this.serviceDiscoveryManager.discoverInformation(this.roomJid, "http://jabber.org/protocol/muc#traffic").getFeatures();
    }

    public String toString() {
        return this.roomJid != null ? this.roomJid.toString() : super.toString();
    }

    @Override
    public int compareTo(ChatRoom o) {
        if (this == o) {
            return 0;
        }
        if (o != null) {
            int result = this.name != null ? (o.name != null ? this.name.compareTo(o.name) : -1) : (o.name != null ? 1 : 0);
            if (result == 0) {
                result = this.roomJid != null ? (o.roomJid != null ? this.roomJid.compareTo(o.roomJid) : -1) : (o.roomJid != null ? 1 : 0);
            }
            return result;
        }
        return -1;
    }
}

