/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.muc;

import java.util.EventObject;
import rocks.xmpp.core.Jid;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.model.client.Message;
import rocks.xmpp.core.stream.model.ClientStreamElement;
import rocks.xmpp.extensions.muc.model.user.Decline;

public final class InvitationEvent
extends EventObject {
    private final Jid inviter;
    private final boolean aContinue;
    private final Jid room;
    private final String password;
    private final String reason;
    private final String thread;
    private final boolean mediated;
    private final XmppSession xmppSession;

    InvitationEvent(Object source, XmppSession xmppSession, Jid inviter, Jid room, String reason, String password, boolean aContinue, String thread, boolean mediated) {
        super(source);
        this.inviter = inviter;
        this.room = room;
        this.reason = reason;
        this.password = password;
        this.aContinue = aContinue;
        this.thread = thread;
        this.mediated = mediated;
        this.xmppSession = xmppSession;
    }

    public void decline(String reason) {
        if (this.mediated) {
            Message message = new Message(this.room);
            message.getExtensions().add(new Decline(this.inviter, reason));
            this.xmppSession.send((ClientStreamElement)message);
        }
    }

    public Jid getInviter() {
        return this.inviter;
    }

    public boolean isContinue() {
        return this.aContinue;
    }

    public Jid getRoomAddress() {
        return this.room;
    }

    public String getPassword() {
        return this.password;
    }

    public String getReason() {
        return this.reason;
    }

    public String getThread() {
        return this.thread;
    }

    public boolean isMediated() {
        return this.mediated;
    }
}

