/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.muc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import rocks.xmpp.core.Jid;
import rocks.xmpp.core.XmppException;
import rocks.xmpp.core.session.ExtensionManager;
import rocks.xmpp.core.session.SessionStatusEvent;
import rocks.xmpp.core.session.SessionStatusListener;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.MessageEvent;
import rocks.xmpp.core.stanza.MessageListener;
import rocks.xmpp.core.stanza.model.client.Message;
import rocks.xmpp.extensions.disco.DefaultItemProvider;
import rocks.xmpp.extensions.disco.ServiceDiscoveryManager;
import rocks.xmpp.extensions.disco.model.items.Item;
import rocks.xmpp.extensions.muc.ChatRoom;
import rocks.xmpp.extensions.muc.ChatService;
import rocks.xmpp.extensions.muc.InvitationEvent;
import rocks.xmpp.extensions.muc.InvitationListener;
import rocks.xmpp.extensions.muc.conference.model.DirectInvitation;
import rocks.xmpp.extensions.muc.model.user.Invite;
import rocks.xmpp.extensions.muc.model.user.MucUser;
import rocks.xmpp.extensions.rsm.ResultSetProvider;

public final class MultiUserChatManager
extends ExtensionManager {
    private static final Logger logger = Logger.getLogger(MultiUserChatManager.class.getName());
    private static final String ROOMS_NODE = "http://jabber.org/protocol/muc#rooms";
    private final ServiceDiscoveryManager serviceDiscoveryManager;
    private final Set<InvitationListener> invitationListeners = new CopyOnWriteArraySet<InvitationListener>();
    private final Map<Jid, Item> enteredRoomsMap = new ConcurrentHashMap<Jid, Item>();

    private MultiUserChatManager(XmppSession xmppSession) {
        super(xmppSession, new String[]{"http://jabber.org/protocol/muc"});
        this.serviceDiscoveryManager = (ServiceDiscoveryManager)xmppSession.getManager(ServiceDiscoveryManager.class);
    }

    protected void initialize() {
        this.xmppSession.addSessionStatusListener(new SessionStatusListener(){

            public void sessionStatusChanged(SessionStatusEvent e) {
                if (e.getStatus() == XmppSession.Status.CLOSED) {
                    MultiUserChatManager.this.invitationListeners.clear();
                }
            }
        });
        this.xmppSession.addInboundMessageListener(new MessageListener(){

            public void handleMessage(MessageEvent e) {
                Message message = e.getMessage();
                MucUser mucUser = (MucUser)message.getExtension(MucUser.class);
                if (mucUser != null) {
                    for (Invite invite : mucUser.getInvites()) {
                        MultiUserChatManager.this.notifyListeners(new InvitationEvent((Object)MultiUserChatManager.this, MultiUserChatManager.this.xmppSession, invite.getFrom(), message.getFrom(), invite.getReason(), mucUser.getPassword(), invite.isContinue(), invite.getThread(), true));
                    }
                } else {
                    DirectInvitation directInvitation = (DirectInvitation)message.getExtension(DirectInvitation.class);
                    if (directInvitation != null) {
                        MultiUserChatManager.this.notifyListeners(new InvitationEvent((Object)MultiUserChatManager.this, MultiUserChatManager.this.xmppSession, message.getFrom(), directInvitation.getRoomAddress(), directInvitation.getReason(), directInvitation.getPassword(), directInvitation.isContinue(), directInvitation.getThread(), false));
                    }
                }
            }
        });
        this.serviceDiscoveryManager.setItemProvider(ROOMS_NODE, (ResultSetProvider)new DefaultItemProvider(this.enteredRoomsMap.values()));
    }

    private void notifyListeners(InvitationEvent invitationEvent) {
        for (InvitationListener invitationListener : this.invitationListeners) {
            try {
                invitationListener.invitationReceived(invitationEvent);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
    }

    public void addInvitationListener(InvitationListener invitationListener) {
        this.invitationListeners.add(invitationListener);
    }

    public void removeInvitationListener(InvitationListener invitationListener) {
        this.invitationListeners.remove(invitationListener);
    }

    @Deprecated
    public Collection<ChatService> getChatServices() throws XmppException {
        return this.discoverChatServices();
    }

    public Collection<ChatService> discoverChatServices() throws XmppException {
        Collection services = this.serviceDiscoveryManager.discoverServices("http://jabber.org/protocol/muc");
        ArrayList<ChatService> chatServices = new ArrayList<ChatService>();
        for (Item service : services) {
            chatServices.add(new ChatService(service.getJid(), service.getName(), this.xmppSession, this.serviceDiscoveryManager, this));
        }
        return chatServices;
    }

    public Collection<Item> discoverEnteredRooms(Jid contact) throws XmppException {
        return this.serviceDiscoveryManager.discoverItems(contact, ROOMS_NODE).getItems();
    }

    public ChatService createChatService(Jid chatService) {
        return new ChatService(chatService, null, this.xmppSession, this.serviceDiscoveryManager, this);
    }

    void roomEntered(ChatRoom chatRoom, String nick) {
        this.enteredRoomsMap.put(chatRoom.getAddress(), new Item(chatRoom.getAddress(), null, nick));
    }

    void roomExited(ChatRoom chatRoom) {
        this.enteredRoomsMap.remove(chatRoom.getAddress());
    }
}

