/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.ping;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import rocks.xmpp.core.Jid;
import rocks.xmpp.core.XmppException;
import rocks.xmpp.core.XmppUtils;
import rocks.xmpp.core.session.ExtensionManager;
import rocks.xmpp.core.session.Manager;
import rocks.xmpp.core.session.SessionStatusEvent;
import rocks.xmpp.core.session.SessionStatusListener;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.AbstractIQHandler;
import rocks.xmpp.core.stanza.IQEvent;
import rocks.xmpp.core.stanza.IQHandler;
import rocks.xmpp.core.stanza.IQListener;
import rocks.xmpp.core.stanza.MessageEvent;
import rocks.xmpp.core.stanza.MessageListener;
import rocks.xmpp.core.stanza.PresenceEvent;
import rocks.xmpp.core.stanza.PresenceListener;
import rocks.xmpp.core.stanza.StanzaException;
import rocks.xmpp.core.stanza.model.AbstractIQ;
import rocks.xmpp.core.stanza.model.client.IQ;
import rocks.xmpp.core.stanza.model.errors.Condition;
import rocks.xmpp.extensions.ping.model.Ping;

public final class PingManager
extends ExtensionManager {
    private final ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(XmppUtils.createNamedThreadFactory((String)"XMPP Scheduled Ping Thread"));
    private ScheduledFuture<?> nextPing;
    private long pingInterval = 900L;

    private PingManager(XmppSession xmppSession) {
        super(xmppSession, new String[]{"urn:xmpp:ping"});
        this.setEnabled(true);
    }

    protected final void initialize() {
        this.xmppSession.addIQHandler(Ping.class, (IQHandler)new AbstractIQHandler((Manager)this, AbstractIQ.Type.GET){

            protected IQ processRequest(IQ iq) {
                return iq.createResult();
            }
        });
        this.xmppSession.addSessionStatusListener(new SessionStatusListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void sessionStatusChanged(SessionStatusEvent e) {
                if (e.getStatus() == XmppSession.Status.CLOSED) {
                    2 var2_2 = this;
                    synchronized (var2_2) {
                        PingManager.this.cancelNextPing();
                        PingManager.this.scheduledExecutorService.shutdown();
                    }
                }
            }
        });
        this.xmppSession.addInboundMessageListener(new MessageListener(){

            public void handleMessage(MessageEvent e) {
                PingManager.this.rescheduleNextPing();
            }
        });
        this.xmppSession.addInboundPresenceListener(new PresenceListener(){

            public void handlePresence(PresenceEvent e) {
                PingManager.this.rescheduleNextPing();
            }
        });
        this.xmppSession.addInboundIQListener(new IQListener(){

            public void handleIQ(IQEvent e) {
                PingManager.this.rescheduleNextPing();
            }
        });
    }

    public final boolean ping(Jid jid) {
        return this.ping(jid, this.xmppSession.getConfiguration().getDefaultResponseTimeout());
    }

    public final boolean ping(Jid jid, long timeout) {
        try {
            this.xmppSession.query(new IQ(jid, AbstractIQ.Type.GET, (Object)Ping.INSTANCE), timeout);
            return true;
        }
        catch (StanzaException e) {
            return (jid == null || jid.isBareJid()) && e.getStanza().getError().getCondition() == Condition.SERVICE_UNAVAILABLE;
        }
        catch (XmppException e) {
            return false;
        }
    }

    public final boolean pingServer() {
        return this.ping(new Jid(this.xmppSession.getDomain()));
    }

    public final synchronized long getPingInterval() {
        return this.pingInterval;
    }

    public final synchronized void setPingInterval(long pingInterval) {
        this.pingInterval = pingInterval;
        this.rescheduleNextPing();
    }

    public final void setEnabled(boolean enabled) {
        boolean wasEnabled = this.isEnabled();
        super.setEnabled(enabled);
        if (enabled && !wasEnabled) {
            this.rescheduleNextPing();
        } else if (!enabled && wasEnabled) {
            this.cancelNextPing();
        }
    }

    private void rescheduleNextPing() {
        this.scheduledExecutorService.schedule(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                PingManager pingManager = PingManager.this;
                synchronized (pingManager) {
                    PingManager.this.cancelNextPing();
                    if (PingManager.this.pingInterval > 0L && !PingManager.this.scheduledExecutorService.isShutdown()) {
                        PingManager.this.nextPing = PingManager.this.scheduledExecutorService.schedule(new Runnable(){

                            @Override
                            public void run() {
                                if (PingManager.this.isEnabled() && PingManager.this.xmppSession.getStatus() == XmppSession.Status.AUTHENTICATED && !PingManager.this.pingServer()) {
                                    try {
                                        throw new XmppException("Server ping failed.");
                                    }
                                    catch (XmppException e) {
                                        PingManager.this.xmppSession.notifyException((Exception)((Object)e));
                                    }
                                }
                            }
                        }, PingManager.this.pingInterval, TimeUnit.SECONDS);
                    }
                }
            }
        }, 0L, TimeUnit.MILLISECONDS);
    }

    private synchronized void cancelNextPing() {
        if (this.nextPing != null) {
            this.nextPing.cancel(true);
            this.nextPing = null;
        }
    }
}

