/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.privacy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import rocks.xmpp.core.XmppException;
import rocks.xmpp.core.session.ExtensionManager;
import rocks.xmpp.core.session.Manager;
import rocks.xmpp.core.session.SessionStatusEvent;
import rocks.xmpp.core.session.SessionStatusListener;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.AbstractIQHandler;
import rocks.xmpp.core.stanza.IQHandler;
import rocks.xmpp.core.stanza.model.AbstractIQ;
import rocks.xmpp.core.stanza.model.client.IQ;
import rocks.xmpp.core.stanza.model.errors.Condition;
import rocks.xmpp.extensions.privacy.PrivacyListEvent;
import rocks.xmpp.extensions.privacy.PrivacyListListener;
import rocks.xmpp.extensions.privacy.model.Privacy;
import rocks.xmpp.extensions.privacy.model.PrivacyList;

public final class PrivacyListManager
extends ExtensionManager {
    private final Set<PrivacyListListener> privacyListListeners = new CopyOnWriteArraySet<PrivacyListListener>();

    private PrivacyListManager(XmppSession xmppSession) {
        super(xmppSession, new String[0]);
    }

    protected void initialize() {
        this.xmppSession.addSessionStatusListener(new SessionStatusListener(){

            public void sessionStatusChanged(SessionStatusEvent e) {
                if (e.getStatus() == XmppSession.Status.CLOSED) {
                    PrivacyListManager.this.privacyListListeners.clear();
                }
            }
        });
        this.xmppSession.addIQHandler(Privacy.class, (IQHandler)new AbstractIQHandler((Manager)this, AbstractIQ.Type.SET){

            protected IQ processRequest(IQ iq) {
                if (iq.getFrom() == null || iq.getFrom().equals((Object)PrivacyListManager.this.xmppSession.getConnectedResource().asBareJid())) {
                    List privacyLists;
                    Privacy privacy = (Privacy)iq.getExtension(Privacy.class);
                    if (privacy != null && (privacyLists = privacy.getPrivacyLists()).size() == 1) {
                        for (PrivacyListListener privacyListListener : PrivacyListManager.this.privacyListListeners) {
                            privacyListListener.privacyListUpdated(new PrivacyListEvent((Object)PrivacyListManager.this, ((PrivacyList)privacyLists.get(0)).getName()));
                        }
                    }
                    return iq.createResult();
                }
                return iq.createError(Condition.NOT_ACCEPTABLE);
            }
        }, false);
    }

    public void addPrivacyListListener(PrivacyListListener privacyListListener) {
        this.privacyListListeners.add(privacyListListener);
    }

    public void removePrivacyListListener(PrivacyListListener privacyListListener) {
        this.privacyListListeners.remove(privacyListListener);
    }

    public Collection<PrivacyList> getPrivacyLists() throws XmppException {
        IQ result = this.xmppSession.query(new IQ(AbstractIQ.Type.GET, (Object)new Privacy()));
        Privacy privacy = (Privacy)result.getExtension(Privacy.class);
        ArrayList<PrivacyList> privacyLists = new ArrayList<PrivacyList>();
        for (PrivacyList privacyList : privacy.getPrivacyLists()) {
            if (privacyList.getName() != null && privacyList.getName().equals(privacy.getDefaultName())) {
                privacyLists.add(privacyList.asDefault());
            }
            if (privacyList.getName() == null || !privacyList.getName().equals(privacy.getActiveName())) continue;
            privacyLists.add(privacyList.asActive());
        }
        return privacyLists;
    }

    public PrivacyList getPrivacyList(String name) throws XmppException {
        IQ result = this.xmppSession.query(new IQ(AbstractIQ.Type.GET, (Object)new Privacy(new PrivacyList[]{new PrivacyList(name)})));
        Privacy privacy = (Privacy)result.getExtension(Privacy.class);
        if (privacy != null) {
            return (PrivacyList)privacy.getPrivacyLists().get(0);
        }
        return null;
    }

    public void setActiveList(String name) throws XmppException {
        this.setPrivacy(Privacy.withActive((String)name));
    }

    public void declineActiveList() throws XmppException {
        this.setActiveList("");
    }

    public void setDefaultList(String name) throws XmppException {
        this.setPrivacy(Privacy.withDefault((String)name));
    }

    public void declineDefaultList() throws XmppException {
        this.setDefaultList("");
    }

    public void createOrUpdateList(PrivacyList privacyList) throws XmppException {
        this.setPrivacy(new Privacy(new PrivacyList[]{privacyList}));
    }

    public void removeList(String name) throws XmppException {
        this.setPrivacy(new Privacy(new PrivacyList[]{new PrivacyList(name)}));
    }

    private void setPrivacy(Privacy privacy) throws XmppException {
        this.xmppSession.query(new IQ(AbstractIQ.Type.SET, (Object)privacy));
    }
}

